/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.stats;

import com.ibm.wssvt.acme.common.stats.ExceptionInfoStats;
import com.ibm.wssvt.acme.common.stats.ExecutionStats;
import com.ibm.wssvt.acme.common.stats.IExecutionStatsFormatter;
import com.ibm.wssvt.acme.common.stats.ThreadInfoStats;
import java.util.HashMap;
import java.util.Map;

public class ExecutionStatsFormatter
implements IExecutionStatsFormatter {
    public static final String HTML_NEW_LINE = "<BR>";
    public static final String FILE_NEW_LINE = "\n";
    private String newLineMarker;

    public ExecutionStatsFormatter(String newLineMarker) {
        this.newLineMarker = newLineMarker;
        if (this.newLineMarker == null) {
            this.newLineMarker = FILE_NEW_LINE;
        }
    }

    public String getNewLineMarker() {
        return this.newLineMarker;
    }

    @Override
    public String format() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNewLineMarker());
        sb.append("Execution Stats Data Snapshot:");
        sb.append(this.getExceptionTotals());
        sb.append(this.getNewLineMarker());
        sb.append(this.getServerInfoTotals());
        sb.append(this.getNewLineMarker());
        sb.append(this.getThreadStatus());
        sb.append(this.getNewLineMarker());
        sb.append(this.getCRUDTotals());
        sb.append(this.getNewLineMarker());
        sb.append(this.getRequestTotals());
        sb.append(this.getNewLineMarker());
        return sb.toString();
    }

    protected String getRequestTotals() {
        long requests = ExecutionStats.getInstance().getRequest();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNewLineMarker());
        sb.append("The following is the total Server Requests: ");
        sb.append(this.getNewLineMarker());
        sb.append("Overall Requests : ").append(requests);
        return sb.toString();
    }

    protected String getCRUDTotals() {
        long total = ExecutionStats.getInstance().getCRUDTotal();
        long create = ExecutionStats.getInstance().getCreate();
        long read = ExecutionStats.getInstance().getRead();
        long update = ExecutionStats.getInstance().getUpdate();
        long delete = ExecutionStats.getInstance().getDelete();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNewLineMarker());
        sb.append("The following are the CRUD Counts: ");
        if (total == 0L) {
            sb.append(this.getNewLineMarker());
            sb.append("No CRUD Operations.");
        } else {
            sb.append(this.getNewLineMarker());
            sb.append("All CRUD Count   : ").append(total);
            sb.append(this.getNewLineMarker());
            sb.append("Total Create     : ").append(create).append(" which is: ").append(create * 100L / total).append("% of all CRUD operations");
            sb.append(this.getNewLineMarker());
            sb.append("Total Read       : ").append(read).append(" which is: ").append(read * 100L / total).append("% of all CRUD operations");
            sb.append(this.getNewLineMarker());
            sb.append("Total Update     : ").append(update).append(" which is: ").append(update * 100L / total).append("% of all CRUD operations");
            sb.append(this.getNewLineMarker());
            sb.append("Total Delete     : ").append(delete).append(" which is: ").append(delete * 100L / total).append("% of all CRUD operations");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServerInfoTotals() {
        Map<String, Long> serverRunInfo = ExecutionStats.getInstance().getServerRunInfo();
        Map<String, Long> overallServerRunInfo = ExecutionStats.getInstance().getOverallServerRunInfo();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNewLineMarker());
        sb.append("The following are the Servers and their hit count: ");
        if (serverRunInfo.isEmpty()) {
            sb.append(this.getNewLineMarker());
            sb.append("No Server Run Info Available.");
        } else {
            if (overallServerRunInfo.isEmpty()) {
                Map<String, Long> map = serverRunInfo;
                synchronized (map) {
                    for (String serverName : serverRunInfo.keySet()) {
                        sb.append(this.getNewLineMarker());
                        long hitCount = serverRunInfo.get(serverName);
                        sb.append("Server: ").append(serverName).append(" was hit: (approximate) ").append(hitCount).append(hitCount > 1L ? " times." : " time.");
                    }
                }
            }
            Map<String, Long> map = overallServerRunInfo;
            synchronized (map) {
                for (String serverName : overallServerRunInfo.keySet()) {
                    sb.append(this.getNewLineMarker());
                    long overallHitCount = overallServerRunInfo.get(serverName);
                    long hitCount = serverRunInfo.get(serverName) == null ? 0L : serverRunInfo.get(serverName);
                    sb.append("Server: ").append(serverName).append(" was hit: (approximate) ").append(hitCount).append(hitCount > 1L ? " times" : " time");
                    sb.append(" by the client, and ").append(overallHitCount).append(overallHitCount > 1L ? " times" : " time").append(" overall.");
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getThreadStatus() {
        HashMap<Integer, ThreadInfoStats> threadInfoStatsMap = new HashMap<Integer, ThreadInfoStats>(ExecutionStats.getInstance().getThreadInfoStatsMap());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNewLineMarker());
        sb.append("The following are the threads, their loop count and Status: ");
        if (threadInfoStatsMap.isEmpty()) {
            sb.append(this.getNewLineMarker());
            sb.append("No Loops executed!");
        } else {
            HashMap<Integer, ThreadInfoStats> hashMap = threadInfoStatsMap;
            synchronized (hashMap) {
                for (Integer threadId : threadInfoStatsMap.keySet()) {
                    ThreadInfoStats threadStats = (ThreadInfoStats)threadInfoStatsMap.get(threadId);
                    sb.append(this.getNewLineMarker());
                    sb.append("Thread id: ").append(threadId).append(" Looped: ").append(threadStats.getLoopCount()).append(threadStats.getLoopCount() > 1L ? " times" : " time").append(".  Status: ").append((Object)threadStats.getExecutionStatus()).append(".  Status Date: ").append(threadStats.getLastStatusDate()).append(".  Start Time: ").append(threadStats.getThreadStartTime()).append(".  End Time: ").append(threadStats.getThreadEndTime() == null ? "still running ..." : threadStats.getThreadEndTime()).append(".  Clock Time: ").append(threadStats.getExecutionClockTime()).append(" milliseconds").append(".  Active Time: ").append(threadStats.getExecutionActiveTime()).append(" milliseconds").append(this.getNewLineMarker());
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getExceptionTotals() {
        long crudTotal = ExecutionStats.getInstance().getCRUDTotal();
        HashMap<String, ExceptionInfoStats> exceptionCountMap = new HashMap<String, ExceptionInfoStats>(ExecutionStats.getInstance().getExceptionCount());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNewLineMarker());
        sb.append("The following errors were reported so far: (Based on the Exception Handler Configuration)");
        if (exceptionCountMap.isEmpty()) {
            sb.append(" No Errors Reported.");
        } else {
            HashMap<String, ExceptionInfoStats> hashMap = exceptionCountMap;
            synchronized (hashMap) {
                for (String exName : exceptionCountMap.keySet()) {
                    Map<Long, String> exceptionData;
                    ExceptionInfoStats stats = (ExceptionInfoStats)exceptionCountMap.get(exName);
                    if (crudTotal == 0L) {
                        Map<Long, String> exceptionData2;
                        sb.append(this.getNewLineMarker());
                        sb.append("Exception Class: ").append(exName).append(" was encountered: ").append(stats.getCount()).append(" time(s).  Ratio to total CRUD: INFINITY. (Exception Count/Total CURD).  Note: Total CRUD is ZERO\n");
                        sb.append(this.getNewLineMarker());
                        sb.append("Detail Data about this Exception:");
                        sb.append(this.getNewLineMarker());
                        Map<Long, String> map = exceptionData2 = stats.getExceptionData();
                        synchronized (map) {
                            for (Long count : exceptionData2.keySet()) {
                                sb.append("   Incident number: ").append(count).append(" in: ").append(exceptionData2.get(count));
                                sb.append(this.getNewLineMarker());
                            }
                            continue;
                        }
                    }
                    sb.append(this.getNewLineMarker());
                    sb.append("Exception Class: ").append(exName).append(" was encountered: ").append(stats.getCount()).append(" time(s).  Ratio to total CRUD: ");
                    float f = stats.getCount() * 100L / crudTotal;
                    sb.append(f).append(" % (Exception Count/Total CURD)\n");
                    sb.append(this.getNewLineMarker());
                    sb.append("Detail Data about this Exception:");
                    sb.append(this.getNewLineMarker());
                    Map<Long, String> map = exceptionData = stats.getExceptionData();
                    synchronized (map) {
                        for (Long count : exceptionData.keySet()) {
                            sb.append("   Incident number: ").append(count).append(" in: ").append(exceptionData.get(count));
                            sb.append(this.getNewLineMarker());
                        }
                    }
                }
            }
        }
        return sb.toString();
    }
}

