/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.business;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.nonbusinessimpl.AnnuitySpecialImplFactory;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.AnnuityMgmtSvcEJB30JAXWSImpl;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.pojoimpl.AnnuityMgmtSvcPojoJAXWSImpl;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuitySecurityException;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2.EJB2xServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2xjaxrpc.EJB2xJAXRPCEJBServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2xjaxrpc.EJB2xJAXRPCJAXRPCServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3.EJB3ServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb31.EJB31AsynchServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc.EJB30JAXRPCJAXRPCServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc.EJB3JAXRPCEJBServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxws.EJB3JAXWSEJBServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxws.EJB3JAXWSJAXWSServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrs.JAXRSServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.pojojaxrpc.PojoJAXRPCServiceLookup;
import com.ibm.wssvt.acme.annuity.common.servicelookup.pojojaxws.JAXWSServiceLookup;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityServiceName;
import com.ibm.wssvt.acme.annuity.common.util.ServerInjectedObjects;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.bean.StringConfigrable;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.naming.NamingException;

public class AnnuityBusinessServiceLookup {
    private static final String INTERNAL_CURRENT_SERVICE_NUMBER = "internal.CURRENT_SERVICE_NUMBER";

    public IAnnuityService getAnnuityAnnuityService(Configrable<String, String> inConfig) throws InvalidConfigurationException, NamingException, RemoteException, CreateException, AnnuitySecurityException {
        AnnuityServiceName annuityServiceName = this.getServiceName(inConfig);
        StringConfigrable configrable = new StringConfigrable();
        AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(inConfig, this.getClass().getName());
        if (AnnuityServiceName.EJB31.equals((Object)annuityServiceName)) {
            logger.fine("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB31ServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB31AsynchServiceLookup.getAnnuityEJB31Service(null, null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB30.equals((Object)annuityServiceName)) {
            logger.fine("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB30ServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB3ServiceLookup.getAnnuityEJB3Service(null, null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB2x.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB2xServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB2xServiceLookup.getAnnuityEJB2xService((Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB30JAXWS_EJB.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB30JAXWS_EJBServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB3JAXWSEJBServiceLookup.getAnnuityEJB3JAXWSEJBService((Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB30JAXRPC_EJB.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB30JAXRPC_EJBServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB3JAXRPCEJBServiceLookup.getAnnuityEJB3JAXRPCEJBService((Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB2xJAXRPC_EJB.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB2xJAXRPC_EJBServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB2xJAXRPCEJBServiceLookup.getAnnuityEJB2xJAXRPCEJBService((Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB30JAXWS_JAXWS.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB30JAXWS_JAXWSServiceConfig(inConfig, (Configrable<String, String>)configrable);
            if ("useInjection".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"connectionMode"))) {
                logger.info("connectionMode is set to useInjection");
                AnnuityMgmtSvcEJB30JAXWSImpl injectedObject = (AnnuityMgmtSvcEJB30JAXWSImpl)((Object)ServerInjectedObjects.getInstance().getObject("AnnuityMgmtSvcEJB30JAXWSImpl"));
                logger.info("injected Service AnnuityMgmtSvcEJB30JAXWSImpl: " + (Object)((Object)injectedObject));
                if (injectedObject == null) {
                    throw new InvalidConfigurationException("The Configuration requested to use the Injected Object of AnnuityMgmtSvcEJB30JAXWSImpl, but the object value is null.");
                }
                return EJB3JAXWSJAXWSServiceLookup.getAnnuityJAXWSService(injectedObject, (Configrable<String, String>)configrable, logger);
            }
            return EJB3JAXWSJAXWSServiceLookup.getAnnuityJAXWSService(null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB30JAXRPC_JAXRPC.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getEJB30JAXRPC_JAXRPCServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB30JAXRPCJAXRPCServiceLookup.getAnnuityEJB30JAXRPCJAXRPCService(null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.EJB2xJAXRPC_JAXRPC.equals((Object)annuityServiceName)) {
            this.getEJB2xJAXRPC_JAXRPCServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return EJB2xJAXRPCJAXRPCServiceLookup.getAnnuityEJB2xJAXRPCJAXRPCService(null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.POJO_JAXWS.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getPOJO_JAXWSServiceConfig(inConfig, (Configrable<String, String>)configrable);
            if ("useInjection".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"connectionMode"))) {
                logger.info("connectionMode is set to useInjection");
                AnnuityMgmtSvcPojoJAXWSImpl injectedObject = (AnnuityMgmtSvcPojoJAXWSImpl)((Object)ServerInjectedObjects.getInstance().getObject("AnnuityMgmtSvcPojoJAXWSImpl"));
                logger.info("injected Service AnnuityMgmtSvcPojoJAXWSImpl: " + (Object)((Object)injectedObject));
                if (injectedObject == null) {
                    throw new InvalidConfigurationException("The Configuration requested to use the Injected Object of AnnuityMgmtSvcPojoJAXWSImpl, but the object value is null.");
                }
                return JAXWSServiceLookup.getAnnuityJAXWSService(injectedObject, (Configrable<String, String>)configrable, logger);
            }
            if ("useInjection1".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"connectionMode"))) {
                logger.info("connectionMode is set to useInjection1");
                AnnuityMgmtSvcPojoJAXWSImpl injectedObject = (AnnuityMgmtSvcPojoJAXWSImpl)((Object)ServerInjectedObjects.getInstance().getObject("AnnuityMgmtSvcPojoJAXWSImpl1"));
                logger.info("injected Service AnnuityMgmtSvcPojoJAXWSImpl1: " + (Object)((Object)injectedObject));
                if (injectedObject == null) {
                    throw new InvalidConfigurationException("The Configuration requested to use the Injected Object of AnnuityMgmtSvcPojoJAXWSImpl1, but the object value is null.");
                }
                return JAXWSServiceLookup.getAnnuityJAXWSService(injectedObject, (Configrable<String, String>)configrable, logger);
            }
            if ("useInjection2".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"connectionMode"))) {
                logger.info("connectionMode is set to useInjection2");
                AnnuityMgmtSvcPojoJAXWSImpl injectedObject = (AnnuityMgmtSvcPojoJAXWSImpl)((Object)ServerInjectedObjects.getInstance().getObject("AnnuityMgmtSvcPojoJAXWSImpl2"));
                logger.info("injected Service AnnuityMgmtSvcPojoJAXWSImpl2: " + (Object)((Object)injectedObject));
                if (injectedObject == null) {
                    throw new InvalidConfigurationException("The Configuration requested to use the Injected Object of AnnuityMgmtSvcPojoJAXWSImpl2, but the object value is null.");
                }
                return JAXWSServiceLookup.getAnnuityJAXWSService(injectedObject, (Configrable<String, String>)configrable, logger);
            }
            if ("useInjection3".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"connectionMode"))) {
                logger.info("connectionMode is set to useInjection3");
                AnnuityMgmtSvcPojoJAXWSImpl injectedObject = (AnnuityMgmtSvcPojoJAXWSImpl)((Object)ServerInjectedObjects.getInstance().getObject("AnnuityMgmtSvcPojoJAXWSImpl3"));
                logger.info("injected Service AnnuityMgmtSvcPojoJAXWSImpl3: " + (Object)((Object)injectedObject));
                if (injectedObject == null) {
                    throw new InvalidConfigurationException("The Configuration requested to use the Injected Object of AnnuityMgmtSvcPojoJAXWSImpl3, but the object value is null.");
                }
                return JAXWSServiceLookup.getAnnuityJAXWSService(injectedObject, (Configrable<String, String>)configrable, logger);
            }
            return JAXWSServiceLookup.getAnnuityJAXWSService(null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.JAXRS_1.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getConfigForJAXRS(inConfig, (Configrable<String, String>)configrable);
            return JAXRSServiceLookup.getAnnuityJAXRSService((Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.JAXRS_2.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getConfigForJAXRS(inConfig, (Configrable<String, String>)configrable);
            return JAXRSServiceLookup.getAnnuityJAXRSService((Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.POJO_JAXRPC.equals((Object)annuityServiceName)) {
            logger.info("Hopping to: " + (Object)((Object)annuityServiceName));
            this.getPOJO_JAXRPCServiceConfig(inConfig, (Configrable<String, String>)configrable);
            return PojoJAXRPCServiceLookup.getAnnuityPojoJAXRPCService(null, (Configrable<String, String>)configrable, logger);
        }
        if (AnnuityServiceName.SPECIAL_SERVICE.equals((Object)annuityServiceName)) {
            return new AnnuitySpecialImplFactory().getSpecialAnnuityService(inConfig);
        }
        throw new InvalidConfigurationException("Service name: " + (Object)((Object)annuityServiceName) + " does not support service hopper configuration.");
    }

    public AnnuityServiceName getServiceName(Configrable<String, String> inConfig) throws InvalidConfigurationException {
        String currentServiceNumber;
        int shCount;
        AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(inConfig, this.getClass().getName());
        String specialService = (String)inConfig.getConfiguration().getParameterValue((Object)"specialServiceName");
        if (specialService != null && specialService.trim().length() > 0) {
            return AnnuityServiceName.SPECIAL_SERVICE;
        }
        try {
            shCount = Integer.parseInt((String)inConfig.getConfiguration().getParameterValue((Object)"SH.Count"));
        }
        catch (Throwable t) {
            shCount = 0;
        }
        logger.fine("shCount: " + shCount);
        if (shCount <= 0) {
            logger.fine("No Service Hopping is requested. Final destination is EJB30");
            return AnnuityServiceName.EJB30;
        }
        if (shCount > 0) {
            logger.info("shCount: " + shCount);
        }
        if ((currentServiceNumber = (String)inConfig.getConfiguration().getParameterValue((Object)INTERNAL_CURRENT_SERVICE_NUMBER)) == null) {
            currentServiceNumber = "1";
            inConfig.getConfiguration().addParameter((Object)INTERNAL_CURRENT_SERVICE_NUMBER, (Object)currentServiceNumber);
        } else if (Integer.parseInt(currentServiceNumber) > shCount) {
            logger.fine("Completed all Service hops - final service is to EJB30");
            return AnnuityServiceName.EJB30;
        }
        logger.info("Hopping to Service Number: " + (String)inConfig.getConfiguration().getParameterValue((Object)INTERNAL_CURRENT_SERVICE_NUMBER));
        String serviceNameKey = "SH" + currentServiceNumber + ".Name";
        String shName = (String)inConfig.getConfiguration().getParameterValue((Object)serviceNameKey);
        if (shName == null) {
            throw new InvalidConfigurationException("Invalid value for a service name at key: " + serviceNameKey);
        }
        try {
            return AnnuityServiceName.valueOf(shName);
        }
        catch (Throwable t) {
            throw new InvalidConfigurationException("Service name is not valid.  Key: " + serviceNameKey + " current value value: " + shName);
        }
    }

    private void getEJB2xJAXRPC_JAXRPCServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericJAXRPCServiceConfig(inConfig, outConfig, prefix, "ejb2xJAXRPCServiceURL");
    }

    private void getEJB30JAXRPC_JAXRPCServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericJAXRPCServiceConfig(inConfig, outConfig, prefix, "ejb3JAXRPCServiceURL");
    }

    private void getEJB30JAXWS_JAXWSServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericJAXWSServiceConfig(inConfig, outConfig, prefix, "ejb30JaxwsServiceURL");
    }

    private void getPOJO_JAXRPCServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericJAXRPCServiceConfig(inConfig, outConfig, prefix, "pojoJAXRPCServiceURL");
    }

    private void getPOJO_JAXWSServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericJAXWSServiceConfig(inConfig, outConfig, prefix, "jaxwsPojoServiceURL");
    }

    private void getEJB2xJAXRPC_EJBServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericEJBServiceConfigs(inConfig, outConfig, prefix, "ejb2xJaxrpcRemoteHomeJNDI", "ejb2xJaxrpcLocalHomeJNDI");
    }

    private void getEJB30JAXRPC_EJBServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericEJBServiceConfigs(inConfig, outConfig, prefix, "ejb3JaxrpcRemoteJNDI", "ejb3JaxrpcLocalJNDI");
    }

    private void getEJB30JAXWS_EJBServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericEJBServiceConfigs(inConfig, outConfig, prefix, "ejb3JaxwsRemoteJNDI", "ejb3JaxwsLocalJNDI");
    }

    private void getEJB2xServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericEJBServiceConfigs(inConfig, outConfig, prefix, "ejb2xRemoteHomeJNDI", "ejb2xLocalHomeJNDI");
    }

    private void getEJB31ServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        this.getGenericEJBServiceConfigs(inConfig, outConfig, "", "ejb31RemoteJNDI", "ejb31LocalJNDI");
    }

    private void getEJB30ServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        this.getGenericEJBServiceConfigs(inConfig, outConfig, "", "ejb3RemoteJNDI", "ejb3LocalJNDI");
    }

    private void getConfigForJAXRS(Configrable<String, String> inConfig, Configrable<String, String> outConfig) throws InvalidConfigurationException {
        String prefix = this.getPrefixAndUpdatedServiceNumber(inConfig);
        this.getGenericJAXRSServiceConfig(inConfig, outConfig, prefix, "jaxrsServerURL");
    }

    private void getGenericEJBServiceConfigs(Configrable<String, String> inConfig, Configrable<String, String> outConfig, String prefix, String remoteJNDIKey, String localJNDIKey) throws InvalidConfigurationException {
        String connectionMode = (String)inConfig.getConfiguration().getParameterValue((Object)(prefix + "connectionMode"));
        if ("remote".equalsIgnoreCase(connectionMode)) {
            outConfig.getConfiguration().addParameter((Object)"connectionMode", (Object)"remote");
            if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "iiopAddress")) == null) {
                throw new InvalidConfigurationException(prefix + "iiopAddress for EJB service is null");
            }
            outConfig.getConfiguration().addParameter((Object)"iiopAddress", inConfig.getConfiguration().getParameterValue((Object)(prefix + "iiopAddress")));
            if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "initialContextFactory")) == null) {
                throw new InvalidConfigurationException(prefix + "initialContextFactory for EJB service is null");
            }
            outConfig.getConfiguration().addParameter((Object)"initialContextFactory", inConfig.getConfiguration().getParameterValue((Object)(prefix + "initialContextFactory")));
            if (inConfig.getConfiguration().getParameterValue((Object)(prefix + remoteJNDIKey)) == null) {
                throw new InvalidConfigurationException(prefix + remoteJNDIKey + " for EJB service is null");
            }
            outConfig.getConfiguration().addParameter((Object)remoteJNDIKey, inConfig.getConfiguration().getParameterValue((Object)(prefix + remoteJNDIKey)));
        } else if ("local".equalsIgnoreCase(connectionMode)) {
            outConfig.getConfiguration().addParameter((Object)"connectionMode", (Object)"local");
            if (inConfig.getConfiguration().getParameterValue((Object)(prefix + localJNDIKey)) == null) {
                throw new InvalidConfigurationException(prefix + localJNDIKey + " for EJB service is null");
            }
            outConfig.getConfiguration().addParameter((Object)localJNDIKey, inConfig.getConfiguration().getParameterValue((Object)(prefix + localJNDIKey)));
        } else {
            throw new InvalidConfigurationException("Service Configurations are not valid for Service" + prefix + "connectionMode" + "  Expected connectionMode to be remote or local, but found: " + connectionMode);
        }
    }

    private void getGenericJAXWSServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig, String prefix, String serviceURLKey) throws InvalidConfigurationException {
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + serviceURLKey)) == null) {
            throw new InvalidConfigurationException(prefix + serviceURLKey + " for jaxws service is null");
        }
        outConfig.getConfiguration().addParameter((Object)serviceURLKey, inConfig.getConfiguration().getParameterValue((Object)(prefix + serviceURLKey)));
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "useAsync")) == null) {
            throw new InvalidConfigurationException(prefix + "useAsync for jaxws service is null");
        }
        outConfig.getConfiguration().addParameter((Object)"useAsync", inConfig.getConfiguration().getParameterValue((Object)(prefix + "useAsync")));
        if ("true".equalsIgnoreCase((String)outConfig.getConfiguration().getParameterValue((Object)"useAsync"))) {
            if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "waitTime")) == null) {
                throw new InvalidConfigurationException(prefix + "waitTime for jaxws service is null");
            }
            outConfig.getConfiguration().addParameter((Object)"waitTime", inConfig.getConfiguration().getParameterValue((Object)(prefix + "waitTime")));
            if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "waitCount")) == null) {
                throw new InvalidConfigurationException(prefix + "waitCount for jaxws service is null");
            }
            outConfig.getConfiguration().addParameter((Object)"waitCount", inConfig.getConfiguration().getParameterValue((Object)(prefix + "waitCount")));
        }
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "connectionMode")) == null) {
            outConfig.getConfiguration().addParameter((Object)"connectionMode", (Object)"noInjection");
        } else {
            outConfig.getConfiguration().addParameter((Object)"connectionMode", inConfig.getConfiguration().getParameterValue((Object)(prefix + "connectionMode")));
        }
    }

    private void getGenericJAXRPCServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig, String prefix, String serviceURL) throws InvalidConfigurationException {
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + serviceURL)) == null) {
            throw new InvalidConfigurationException(prefix + serviceURL + " for jaxrpc service is null");
        }
        outConfig.getConfiguration().addParameter((Object)serviceURL, inConfig.getConfiguration().getParameterValue((Object)(prefix + serviceURL)));
    }

    private void getGenericJAXRSServiceConfig(Configrable<String, String> inConfig, Configrable<String, String> outConfig, String prefix, String serverURL) throws InvalidConfigurationException {
        AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(inConfig, this.getClass().getName());
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + serverURL)) == null) {
            throw new InvalidConfigurationException(prefix + serverURL + " for jaxrs service is null");
        }
        outConfig.getConfiguration().addParameter((Object)"serverURL", inConfig.getConfiguration().getParameterValue((Object)(prefix + serverURL)));
        logger.fine("jaxrs serverURL is " + (String)inConfig.getConfiguration().getParameterValue((Object)(prefix + serverURL)));
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "contentType")) == null) {
            outConfig.getConfiguration().addParameter((Object)"contentType", (Object)"JAXB");
        } else {
            outConfig.getConfiguration().addParameter((Object)"contentType", inConfig.getConfiguration().getParameterValue((Object)(prefix + "contentType")));
        }
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "useSecurity")) == null) {
            outConfig.getConfiguration().addParameter((Object)"useSecurity", (Object)"NONE");
        } else {
            outConfig.getConfiguration().addParameter((Object)"useSecurity", inConfig.getConfiguration().getParameterValue((Object)(prefix + "useSecurity")));
        }
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "readTimeout")) == null) {
            outConfig.getConfiguration().addParameter((Object)"readTimeout", (Object)"300000");
        } else {
            outConfig.getConfiguration().addParameter((Object)"readTimeout", inConfig.getConfiguration().getParameterValue((Object)(prefix + "readTimeout")));
        }
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "userName")) == null) {
            outConfig.getConfiguration().addParameter((Object)"userName", (Object)"NONE");
        } else {
            outConfig.getConfiguration().addParameter((Object)"userName", inConfig.getConfiguration().getParameterValue((Object)(prefix + "userName")));
        }
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "userPassword")) == null) {
            outConfig.getConfiguration().addParameter((Object)"userPassword", (Object)"NONE");
        } else {
            outConfig.getConfiguration().addParameter((Object)"userPassword", inConfig.getConfiguration().getParameterValue((Object)(prefix + "userPassword")));
        }
        if (inConfig.getConfiguration().getParameterValue((Object)(prefix + "useApacheClient")) == null) {
            outConfig.getConfiguration().addParameter((Object)"useApacheClient", (Object)"true");
        } else {
            outConfig.getConfiguration().addParameter((Object)"useApacheClient", inConfig.getConfiguration().getParameterValue((Object)(prefix + "useApacheClient")));
        }
    }

    private String getPrefixAndUpdatedServiceNumber(Configrable<String, String> inConfig) {
        String serviceNumber = (String)inConfig.getConfiguration().getParameterValue((Object)INTERNAL_CURRENT_SERVICE_NUMBER);
        String prefix = "SH" + serviceNumber + ".";
        int updatedNextCount = Integer.parseInt(serviceNumber) + 1;
        inConfig.getConfiguration().addParameter((Object)INTERNAL_CURRENT_SERVICE_NUMBER, (Object)("" + updatedNextCount));
        return prefix;
    }
}

