/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.adapter.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneContact;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.business.IPolicyService;
import com.ibm.wssvt.acme.annuity.common.client.adapter.policy.IPolicyServerAdapter;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.common.adapter.AbstractServerAdapter;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import com.ibm.wssvt.acme.common.log.AcmeLoggerConfig;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractPolicyServerAdapter
extends AbstractServerAdapter
implements IPolicyServerAdapter {
    private static final long serialVersionUID = 6826107504077969435L;

    protected AcmeLogger getLogger(String loggerName) {
        Logger root = Logger.getLogger(this.getClientContext().getPrefixedRootLoggerName());
        AcmeLoggerConfig.setClientFileNamePattern((String)"", (String)this.getClientContext().getClientId(), (int)this.getClientContext().getThreadId(), (Configrable)this);
        Logger theLogger = AnnuityLoggerFactory.getClientLogger(root, (Configrable<String, String>)this, this.getClientContext().getLoggerPrefix() + loggerName);
        return new AcmeLogger(theLogger);
    }

    @Override
    public IPolicy createPolicy(IPolicy policy) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IPolicy result = service.createPolicy(policy);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IBeneficiary createBeneficiary(IBeneficiary beneficiary) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IBeneficiary result = service.createBeneficiary(beneficiary);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IBeneContact createBeneContact(IBeneContact beneContact) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IBeneContact result = service.createBeneContact(beneContact);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IPolicy findPolicyById(IPolicy policy) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IPolicy result = service.findPolicyById(policy);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IBeneficiary findBeneficiaryById(IBeneficiary beneficiary) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IBeneficiary result = service.findBeneficiaryById(beneficiary);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IBeneContact findBeneContactById(IBeneContact beneContact) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IBeneContact result = service.findBeneContactById(beneContact);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder holder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, ServerAdapterCommunicationException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuityHolder result = service.findHolderById(holder);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public void deletePolicy(IPolicy policy) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deletePolicy(policy);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public void deleteBeneficiary(IBeneficiary beneficiary) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteBeneficiary(beneficiary);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public void deleteBeneContact(IBeneContact beneContact) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteBeneContact(beneContact);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public IPolicy updatePolicy(IPolicy policy) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IPolicy result = service.updatePolicy(policy);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IBeneficiary updateBeneficiary(IBeneficiary beneficiary) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IBeneficiary result = service.updateBeneficiary(beneficiary);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IBeneContact updateBeneContact(IBeneContact beneContact) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IBeneContact result = service.updateBeneContact(beneContact);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public List<IPolicy> findHolderPolicies(IAnnuityHolder annuityHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        List<IPolicy> results = service.findHolderPolicies(annuityHolder);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    @Override
    public List<IBeneficiary> findHolderBeneficiaries(IAnnuityHolder annuityHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        List<IBeneficiary> results = service.findHolderBeneficiaries(annuityHolder);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    @Override
    public List<String> findHolderBeneficiaryContactEmails(IAnnuityHolder annuityHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        List<String> results = service.findHolderBeneficiaryContactEmails(annuityHolder);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    @Override
    public IFund findFundIndexRateFromFundName(IAnnuityHolder holder, String fundName) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        IFund result = service.findFundIndexRateFromFundName(holder, fundName);
        this.getServerAdapterEvent().incrumentRead();
        return result;
    }

    @Override
    public List<IFund> findFundsFromState(IAnnuityHolder holder, String state) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        List<IFund> results = service.findFundsFromState(holder, state);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    @Override
    public List<IPersisteble<?>> customQuery(IAnnuityHolder holder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IPolicyService service = this.getPolicyService();
        this.getServerAdapterEvent().incrumentRequest();
        List<IPersisteble<?>> results = service.customQuery(holder);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    private void incrumentRunServerInfo(Configrable<String, String> configrable) {
        if (configrable != null && configrable.getConfiguration() != null) {
            if (configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo") != null) {
                String[] servers = ((String)configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo")).split(";;");
                this.getServerAdapterEvent().incrumentRunServerCount(servers[0]);
                for (int i = 0; i < servers.length; ++i) {
                    this.getServerAdapterEvent().incrumentOverallRunServerCount(servers[i]);
                }
            }
            configrable.getConfiguration().removeParameter((Object)"internal.runningOnServerInfo");
        }
    }

    protected abstract IPolicyService getPolicyService() throws ServerAdapterCommunicationException;
}

