/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.adapter.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneContact;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.business.IPolicyService;
import com.ibm.wssvt.acme.annuity.common.client.adapter.policy.AbstractPolicyServerAdapter;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.persistence.PolicyPersistence;
import com.ibm.wssvt.acme.annuity.common.persistence.PolicyPersistenceFactory;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.List;
import java.util.logging.Level;

public class PolicyJPASAAdapter
extends AbstractPolicyServerAdapter {
    private static final long serialVersionUID = -7761738176018995756L;
    private static PolicyJPAStandAlonePersistenceProxy standAlonePersistence = null;

    @Override
    protected synchronized IPolicyService getPolicyService() throws ServerAdapterCommunicationException {
        AcmeLogger logger = this.getLogger(this.getClass().getName());
        try {
            if (standAlonePersistence == null) {
                logger.fine("We are in the JPA SA");
                logger.fine(this.getConfiguration().getParameters().toString());
                PolicyPersistence<IPersisteble<?>, String, String> policyPersistence = PolicyPersistenceFactory.getPolicyPersistence((Configrable<String, String>)this, logger);
                standAlonePersistence = new PolicyJPAStandAlonePersistenceProxy(policyPersistence);
            }
        }
        catch (ServerPersistenceModuleException e) {
            logger.log(Level.SEVERE, "Failed to get a PolicyJPAStandAlonePersistenceProxy - error: " + (Object)((Object)e), (Throwable)((Object)e));
            throw new ServerAdapterCommunicationException("Failed to get a PolicyJPAStandAlonePersistenceProxy ");
        }
        return standAlonePersistence;
    }

    private class PolicyJPAStandAlonePersistenceProxy
    implements IPolicyService {
        private PolicyPersistence<IPersisteble<?>, String, String> policyPersistence;

        public PolicyJPAStandAlonePersistenceProxy(PolicyPersistence<IPersisteble<?>, String, String> persistenceAdapter) {
            this.policyPersistence = persistenceAdapter;
        }

        @Override
        public IPolicy createPolicy(IPolicy pol) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IPolicy)((Object)this.policyPersistence.createObject((IPersisteble)((Object)pol)));
        }

        @Override
        public IPolicy findPolicyById(IPolicy policy) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IPolicy)this.policyPersistence.readObject(policy.getClass(), policy.getId(), policy);
        }

        @Override
        public void deletePolicy(IPolicy policy) throws ServerInternalErrorException, InvalidArgumentException {
            this.policyPersistence.deleteObject(policy.getClass(), policy.getId(), policy);
        }

        @Override
        public IPolicy updatePolicy(IPolicy policy) throws ServerInternalErrorException, InvalidArgumentException {
            return (IPolicy)((Object)this.policyPersistence.updateObject((IPersisteble)((Object)policy)));
        }

        @Override
        public IAnnuityHolder findHolderById(IAnnuityHolder holder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IAnnuityHolder)this.policyPersistence.readObject(holder.getClass(), holder.getId(), holder);
        }

        @Override
        public IBeneficiary createBeneficiary(IBeneficiary beneficiary) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IBeneficiary)((Object)this.policyPersistence.createObject((IPersisteble)((Object)beneficiary)));
        }

        @Override
        public void deleteBeneficiary(IBeneficiary beneficiary) throws ServerInternalErrorException, InvalidArgumentException {
            this.policyPersistence.deleteObject(beneficiary.getClass(), beneficiary.getId(), beneficiary);
        }

        @Override
        public IBeneficiary findBeneficiaryById(IBeneficiary beneficiary) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IBeneficiary)this.policyPersistence.readObject(beneficiary.getClass(), beneficiary.getId(), beneficiary);
        }

        @Override
        public IBeneficiary updateBeneficiary(IBeneficiary beneficiary) throws ServerInternalErrorException, InvalidArgumentException {
            return (IBeneficiary)((Object)this.policyPersistence.updateObject((IPersisteble)((Object)beneficiary)));
        }

        @Override
        public IBeneContact createBeneContact(IBeneContact beneContact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
            return (IBeneContact)((Object)this.policyPersistence.createObject((IPersisteble)((Object)beneContact)));
        }

        @Override
        public void deleteBeneContact(IBeneContact beneContact) throws ServerInternalErrorException, InvalidArgumentException {
            this.policyPersistence.deleteObject(beneContact.getClass(), beneContact.getId(), beneContact);
        }

        @Override
        public IBeneContact findBeneContactById(IBeneContact beneContact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
            return (IBeneContact)this.policyPersistence.readObject(beneContact.getClass(), beneContact.getId(), beneContact);
        }

        @Override
        public IBeneContact updateBeneContact(IBeneContact beneContact) throws ServerInternalErrorException, InvalidArgumentException {
            return (IBeneContact)((Object)this.policyPersistence.updateObject((IPersisteble)((Object)beneContact)));
        }

        @Override
        public List<IPolicy> findHolderPolicies(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
            return this.policyPersistence.getHolderPolicies(annuityHolder);
        }

        @Override
        public List<IBeneficiary> findHolderBeneficiaries(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
            return this.policyPersistence.getHolderBeneficiaries(annuityHolder);
        }

        @Override
        public List<String> findHolderBeneficiaryContactEmails(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
            return this.policyPersistence.getHolderBeneficiaryContactEmails(annuityHolder);
        }

        @Override
        public IFund findFundIndexRateFromFundName(IAnnuityHolder holder, String fundName) throws InvalidArgumentException, ServerInternalErrorException {
            return this.policyPersistence.getFundIndexRateFromFundName(holder, fundName);
        }

        @Override
        public List<IFund> findFundsFromState(IAnnuityHolder holder, String state) throws InvalidArgumentException, ServerInternalErrorException {
            return this.policyPersistence.getFundsInState(holder, state);
        }

        @Override
        public List<IPersisteble<?>> customQuery(IAnnuityHolder holder) throws InvalidArgumentException, ServerInternalErrorException {
            return this.policyPersistence.customQuery(holder);
        }
    }
}

