/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityBeansFactory;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.executionunit.AbstractExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import com.ibm.wssvt.acme.common.log.AcmeLoggerConfig;
import com.ibm.wssvt.acme.common.util.StringUtils;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;

public abstract class AbstractBasicExecutionUnit
extends AbstractExecutionUnit {
    private static final long serialVersionUID = 1L;

    public int getParameterValueInt(String key) throws InvalidExecutionUnitParameterException {
        String value = (String)this.getConfiguration().getParameterValue((Object)key);
        try {
            return StringUtils.toInt((String)value);
        }
        catch (NumberFormatException e) {
            throw new InvalidExecutionUnitParameterException("The parameter: " + key + " is not an integer for scenario with description: " + this.getDescription() + " Additional Error: " + e);
        }
    }

    public boolean getParameterValueBoolean(String key) throws InvalidExecutionUnitParameterException {
        String value = (String)this.getConfiguration().getParameterValue((Object)key);
        if (value == null) {
            throw new InvalidExecutionUnitParameterException("The parameter: " + key + " is null or not defined for the for scenario with description: " + this.getDescription());
        }
        if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("0".equals(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new InvalidExecutionUnitParameterException("The parameter: " + key + " is not a valid boolean value.  Valid boolean values are 0, 1, true or false" + ".  It is defined for the for scenario with description: " + this.getDescription() + " Current value is: " + value);
    }

    public <T extends Enum<T>> T getParameterValueEnum(Class<T> enumType, String key) throws InvalidExecutionUnitParameterException {
        String value = (String)this.getConfiguration().getParameterValue((Object)key);
        try {
            if (value == null || value.trim().length() < 1) {
                throw new InvalidExecutionUnitParameterException("The parameter: " + key + " is null or empty for Scenario with description: " + this.getDescription());
            }
            return (T)StringUtils.toEnum(enumType, (String)value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidExecutionUnitParameterException("The parameter: " + key + " with value: " + value + " is not a valid value" + " Scenario with description: " + this.getDescription() + " Additional Error: " + e);
        }
    }

    public int getRandomInteger(int lowerLimit, int upperLimit) {
        int n = upperLimit - lowerLimit + 1;
        int i = new Random(UUID.randomUUID().hashCode()).nextInt(Math.abs(n));
        return lowerLimit + i;
    }

    public <T extends Enum<T>> T getRandomEnum(Class<T> enumType) {
        Enum[] t = (Enum[])enumType.getEnumConstants();
        int i = this.getRandomInteger(0, t.length - 1);
        return (T)t[i];
    }

    public IAnnuityBeansFactory getAnnuityBeansFactory() {
        return (IAnnuityBeansFactory)this.getBeansFactory();
    }

    protected AcmeLogger getLogger(String loggerName) {
        Logger root = Logger.getLogger(this.getClientContext().getPrefixedRootLoggerName());
        AcmeLoggerConfig.setClientFileNamePattern((String)"", (String)this.getClientContext().getClientId(), (int)this.getClientContext().getThreadId(), (Configrable)this);
        Logger theLogger = AnnuityLoggerFactory.getClientLogger(root, (Configrable<String, String>)this, this.getClientContext().getLoggerPrefix() + loggerName);
        AcmeLogger al = new AcmeLogger(theLogger);
        return al;
    }
}

