/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AsynchMethodHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CRUDHoldeAndContactEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8978758038714550844L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating Contact");
        IContact contact = null;
        try {
            contact = this.createContact();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Contact");
        try {
            this.verifyContactValue(contact);
        }
        catch (Exception e) {
            this.logger.info("Create Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Creating AnnuityHolder");
        IAnnuityHolder holder = null;
        try {
            holder = this.createAnnuityHolder(contact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to create AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create AnnuityHolder");
        try {
            this.verifyAnnuityHolderValue(holder);
        }
        catch (Exception e) {
            this.logger.info("Create AnnuityHolder verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating Contact");
        IContact updatedContact = null;
        try {
            updatedContact = this.updateContact(contact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update Contact");
        try {
            this.verifyContactValue(updatedContact);
        }
        catch (Exception e) {
            this.logger.info("Update Contact verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating AnnuityHolder");
        IAnnuityHolder updatedHolder = null;
        try {
            updatedHolder = this.updateAnnuityHolder(holder, updatedContact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update AnnuityHolder");
        try {
            this.verifyAnnuityHolderValue(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Update AnnuityHolder verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting AnnuityHolder");
        try {
            this.deleteAnnuityHolder(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete AnnuityHolder");
        try {
            this.verifyDelete(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Delete AnnuityHolder verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting Contact");
        try {
            this.deleteContact(updatedContact);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete Contact");
        try {
            this.verifyDelete(updatedContact);
        }
        catch (Exception e) {
            this.logger.info("Delete Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IAnnuityHolder createAnnuityHolder(IContact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        holder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        holder.setContact(contact);
        holder.setConfiguration(this.getConfiguration());
        holder = this.getServerAdapter().createAnnuityHolder(holder);
        return holder;
    }

    private IAnnuityHolder updateAnnuityHolder(IAnnuityHolder before, IContact updatedContact) throws EntityNotFoundException, EntityAlreadyExistsException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder after = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findHolderById(after);
        after.setGovernmentId(after.getGovernmentId() + "-updated");
        after.setContact(updatedContact);
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateAnnuityHolder(after);
        after.setContact(null);
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateAnnuityHolder(after);
        IContact newc = this.createContact();
        after.setContact(newc);
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateAnnuityHolder(after);
        return after;
    }

    private void deleteAnnuityHolder(IAnnuityHolder holder) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        String contactId = (String)holder.getContact().getId();
        IAnnuityHolder removed = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        removed.setId(holder.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteAnnuityHolder(removed);
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        contact.setId(contactId);
        contact.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteContact(contact);
    }

    private void verifyAnnuityHolderValue(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(holder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, holder, results, "AnnuityHolder from client is not equal to DB value", "AnnuityHolder Create mismacth was found.");
    }

    private void verifyDelete(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InterruptedException, InvalidExecutionUnitParameterException {
        AsynchMethodHelper.verifyHolderDelete(holder, this, this.logger);
    }

    private IContact createContact() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        contact.setConfiguration(this.getConfiguration());
        contact.setContactType(this.getRandomEnum(ContactType.class));
        contact = this.getServerAdapter().createContact(contact);
        return contact;
    }

    private IContact updateContact(IContact before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IContact after = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findContactById(after);
        after.setPhone(after.getPhone() + "-updated");
        after.setEmail(after.getEmail() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateContact(after);
        return after;
    }

    private void deleteContact(IContact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact removed = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        removed.setId(contact.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteContact(removed);
    }

    private void verifyContactValue(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "Contact from client is not equal to DB value", "Contact Create mismacth was found.");
    }

    private void verifyDelete(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InterruptedException, InvalidExecutionUnitParameterException {
        AsynchMethodHelper.verifyContactDelete(contact, this, this.logger);
    }
}

