/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AsynchMethodHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CRUDHolderEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8980258038714550844L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating AnnuityHolder");
        IAnnuityHolder holder = null;
        try {
            holder = this.createAnnuityHolder();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create AnnuityHolder");
        try {
            this.verifyAnnuityHolderValue(holder);
        }
        catch (Exception e) {
            this.logger.info("Create AnnuityHolder verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Updating AnnuityHolder");
        IAnnuityHolder updated = null;
        try {
            updated = this.updateAnnuityHolder(holder);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update AnnuityHolder");
        try {
            this.verifyAnnuityHolderValue(updated);
        }
        catch (Exception e) {
            this.logger.info("Update AnnuityHolder verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Deleting AnnuityHolder");
        try {
            this.deleteAnnuityHolder(updated);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete AnnuityHolder");
        try {
            this.verifyDelete(updated);
        }
        catch (Exception e) {
            this.logger.info("Delete AnnuityHolder verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IAnnuityHolder createAnnuityHolder() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        holder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        holder.setConfiguration(this.getConfiguration());
        holder = this.getServerAdapter().createAnnuityHolder(holder);
        return holder;
    }

    private IAnnuityHolder updateAnnuityHolder(IAnnuityHolder before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder after = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findHolderById(after);
        after.setGovernmentId(after.getGovernmentId() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateAnnuityHolder(after);
        return after;
    }

    private void deleteAnnuityHolder(IAnnuityHolder holder) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder removed = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        removed.setId(holder.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteAnnuityHolder(removed);
    }

    private void verifyAnnuityHolderValue(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(holder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, holder, results, "AnnuityHolder from client is not equal to DB value", "AnnuityHolder Create mismacth was found.");
    }

    private void verifyDelete(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InvalidExecutionUnitParameterException, InterruptedException {
        AsynchMethodHelper.verifyHolderDelete(holder, this, this.logger);
    }
}

