/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.RiderType;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleRunExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleThreadedExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class PopulateDatabaseEU
extends AbastractAnnuityExecutionUnit
implements ISingleThreadedExecutionUnit,
ISingleRunExecutionUnit {
    private static final long serialVersionUID = -5421478878181609584L;
    private int startId;
    private boolean useCharPrefixID = true;
    private int numberOfHolderEntries;
    private int numberOfPayorEntries;
    private int maxNumberOfAnnuitiesPerHolder;
    private int maxNumberOfPayoutsPerAnnuity;
    private int maxNumberOfPayorsPerAnnuity;
    private int maxNumberOfRidersPerAnnuity;
    boolean enableVerify = true;
    boolean randomizeSelection = true;
    private Random populateRandom = new Random();
    private AcmeLogger logger = null;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setAndVerifyScenarioParams();
        }
        catch (Exception e) {
            this.logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Create Payors:" + this.numberOfPayorEntries);
        List<Object> payorList = new ArrayList();
        try {
            payorList = this.createPayors();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Payors. Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            if (this.enableVerify) {
                for (IPayor iPayor : payorList) {
                    this.verifyPayor(iPayor);
                }
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify create payor. Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Starting id=" + this.startId + " Count=" + this.numberOfHolderEntries);
        IAnnuityHolder annuityHolder = null;
        Object var3_7 = null;
        Long startTime = System.currentTimeMillis();
        for (int i = this.startId; i < this.startId + this.numberOfHolderEntries; ++i) {
            IContact iContact;
            String hid;
            String id = hid = "" + i;
            if (i % 1000 == 0 && i != this.startId) {
                this.logger.info("1000 holders+children created in:" + (System.currentTimeMillis() - startTime) + " ms. " + 1000000L / (System.currentTimeMillis() - startTime) + " Holders/sec." + (i - this.startId) + " holders created.");
                startTime = System.currentTimeMillis();
            }
            try {
                IContact iContact2 = this.getContact(id);
                iContact2.setConfiguration(this.getConfiguration());
                iContact = this.getServerAdapter().createContact(iContact2);
            }
            catch (Exception e) {
                this.logger.warning("Failed to create contact. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
            try {
                if (this.enableVerify) {
                    this.verifyContact(iContact);
                }
            }
            catch (Exception e) {
                this.logger.warning("Failed to verify create contact. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
            try {
                annuityHolder = this.getAnnuityHolder(id);
                annuityHolder.setContact(iContact);
                annuityHolder.setConfiguration(this.getConfiguration());
                this.logger.fine("ID:" + id + " Saving annuityHolder");
                annuityHolder = this.getServerAdapter().createAnnuityHolder(annuityHolder);
            }
            catch (Exception e) {
                this.logger.warning("Failed to create AnnuityHolder. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
            try {
                if (this.enableVerify) {
                    this.verifyHolder(annuityHolder);
                }
            }
            catch (Exception e) {
                this.logger.warning("Failed to verify create AnnuityHolder. Error is: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
            int numberOfAnnuitiesForThisHolder = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfAnnuitiesPerHolder) : this.maxNumberOfAnnuitiesPerHolder;
            for (int j = 1; j <= numberOfAnnuitiesForThisHolder; ++j) {
                int numberOfPayorsForThisAnnuity;
                id = hid + "-" + j;
                IAnnuity annuity = this.getAnnuity(id);
                annuity.setAnnuityHolderId((String)annuityHolder.getId());
                int numberOfRidersForThisAnnuity = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfRidersPerAnnuity) : this.maxNumberOfRidersPerAnnuity;
                for (int k = 1; k <= numberOfRidersForThisAnnuity; ++k) {
                    String riderId = hid + "-" + j + "-" + k;
                    IRider rider = this.getRider(riderId);
                    annuity.getRiders().add(rider);
                }
                IPayor randomPayor = null;
                int n = numberOfPayorsForThisAnnuity = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfPayorsPerAnnuity) : this.maxNumberOfPayorsPerAnnuity;
                while (annuity.getPayors().size() < numberOfPayorsForThisAnnuity) {
                    randomPayor = (IPayor)payorList.get(this.getRandomInteger(0, payorList.size() - 1));
                    boolean exists = false;
                    for (IPayor payor : annuity.getPayors()) {
                        if (!((String)payor.getId()).equals(randomPayor.getId())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    annuity.getPayors().add(randomPayor);
                }
                try {
                    annuity.setConfiguration(this.getConfiguration());
                    annuity = this.getServerAdapter().createAnnuity(annuity);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to create Annuity. Error is: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                int numberOfPayoutsForThisAnnuity = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfPayoutsPerAnnuity) : this.maxNumberOfPayoutsPerAnnuity;
                for (int k = 1; k <= numberOfPayoutsForThisAnnuity; ++k) {
                    String payoutId = id + "-" + k;
                    IPayout payout = this.getPayout(payoutId);
                    payout.setAnnuity(annuity);
                    try {
                        payout.setConfiguration(this.getConfiguration());
                        payout = this.getServerAdapter().createPayout(payout);
                        annuity.getPayouts().add(payout);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.warning("Failed to create payout. Error is: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                }
                try {
                    if (!this.enableVerify) continue;
                    this.verifyAnnuity(annuity);
                    continue;
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify create annuity. Error is: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
        }
    }

    private List<IPayor> createPayors() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, RemoteException {
        ArrayList<IPayor> payorList = new ArrayList<IPayor>();
        for (int i = this.startId; i < this.startId + this.numberOfPayorEntries; ++i) {
            IPayor payor = this.getPayor(Integer.toString(i));
            payor.setConfiguration(this.getConfiguration());
            payor = this.getServerAdapter().createPayor(payor);
            payorList.add(payor);
        }
        return payorList;
    }

    private void setAndVerifyScenarioParams() throws InvalidExecutionUnitParameterException {
        String START_ID_KEY = "startId";
        String NUMBER_OF_HOLDER_ENTRIES_KEY = "numberOfHolders";
        String NUMBER_OF_PAYOR_ENTRIES_KEY = "numberOfPayors";
        String MAX_NUMBER_OF_PAYOUTS_PER_ANNUITY_KEY = "maxNumberOfPayoutsPerAnnuity";
        String MAX_NUMBER_OF_PAYORS_PER_ANNUITY_KEY = "maxNumberOfPayorsPerAnnuity";
        String MAX_NUMBER_OF_RIDERS_PER_ANNUITY_KEY = "maxNumberOfRidersPerAnnuity";
        String MAX_NUMBER_OF_ANNUITIES_PER_HOLDER_KEY = "maxNumberOfAnnuitiesPerHolder";
        String ENABLE_VERIFY_KEY = "enableVerify";
        String RANDOMIZE_SELECTION_KEY = "randomizeSelection";
        String USE_ID_CHAR_PREFIX = "useIdCharPrefix";
        this.startId = this.getParameterValueInt("startId");
        this.numberOfHolderEntries = this.getParameterValueInt("numberOfHolders");
        this.numberOfPayorEntries = this.getParameterValueInt("numberOfPayors");
        this.maxNumberOfAnnuitiesPerHolder = this.getParameterValueInt("maxNumberOfAnnuitiesPerHolder");
        this.maxNumberOfPayoutsPerAnnuity = this.getParameterValueInt("maxNumberOfPayoutsPerAnnuity");
        this.maxNumberOfPayorsPerAnnuity = this.getParameterValueInt("maxNumberOfPayorsPerAnnuity");
        this.maxNumberOfRidersPerAnnuity = this.getParameterValueInt("maxNumberOfRidersPerAnnuity");
        if (this.startId <= 0) {
            throw new InvalidExecutionUnitParameterException("startId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.numberOfHolderEntries <= 0) {
            throw new InvalidExecutionUnitParameterException("numberOfHolders is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.numberOfPayorEntries <= 0) {
            throw new InvalidExecutionUnitParameterException("numberOfPayors is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfAnnuitiesPerHolder < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfAnnuitiesPerHolder is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfPayorsPerAnnuity < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfPayorsPerAnnuity is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfPayoutsPerAnnuity < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfPayoutsPerAnnuity is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfRidersPerAnnuity < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfRidersPerAnnuity is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfPayorsPerAnnuity > this.numberOfPayorEntries) {
            throw new InvalidExecutionUnitParameterException("The number of payors to create is less than the max number of payors per annuity. This is invalid.  Scenario Description: " + this.getDescription() + "Update the scenario params and make sure that max number of payors is LESS or EQUAL to number of payour entries.");
        }
        try {
            this.useCharPrefixID = this.getParameterValueBoolean("useIdCharPrefix");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: useIdCharPrefix is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.useCharPrefixID = true;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: enableVerify is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.enableVerify = true;
        }
        try {
            this.randomizeSelection = this.getParameterValueBoolean("randomizeSelection");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: randomizeSelection is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.randomizeSelection = true;
        }
    }

    private void verifyAnnuity(IAnnuity annuity) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuity results = null;
        if (annuity instanceof IFixedAnnuity) {
            results = this.getAnnuityBeansFactory().createAnnFixed();
            results.setId(annuity.getId());
            results.setConfiguration(this.getConfiguration());
            results = this.getServerAdapter().findAnnuityById(results);
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IFixedAnnuity)annuity, (IFixedAnnuity)results, "Annuity from Client is not equal to DB value", "Mismatch was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            results = this.getAnnuityBeansFactory().createAnnEquity();
            results.setId(annuity.getId());
            results.setConfiguration(this.getConfiguration());
            results = this.getServerAdapter().findAnnuityById(results);
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IEquityAnnuity)annuity, (IEquityAnnuity)results, "Annuity from Client is not equal to DB value", "Mismatch was found.");
        } else {
            results = this.getAnnuityBeansFactory().createAnnuity();
            results.setId(annuity.getId());
            results.setConfiguration(this.getConfiguration());
            results = this.getServerAdapter().findAnnuityById(results);
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity, results, "Annuity from Client is not equal to DB value", "Mismatch was found.");
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismatch was found in number of payouts");
        boolean found = false;
        IPayout clientPayout = null;
        for (int i = 0; i < annuity.getPayouts().size(); ++i) {
            found = false;
            clientPayout = annuity.getPayouts().get(i);
            for (IPayout resultPayout : results.getPayouts()) {
                if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                found = true;
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout.getAnnuity(), resultPayout.getAnnuity(), "Annuity from payout from Client is not equal to DB value at location: " + i, "Mismatch was found");
            }
            if (found || clientPayout == null) continue;
            throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismatch was found in number of rider");
        IRider clientRider = null;
        for (int i = 0; i < annuity.getRiders().size(); ++i) {
            found = false;
            clientRider = annuity.getRiders().get(i);
            for (IRider resultRider : results.getRiders()) {
                if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                found = true;
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
            }
            if (found || clientRider == null) continue;
            throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity payor from Client is not equal to DB value", "Mismatch was found");
        ExecutionUnitVerificationHelper.assertNotNull((IExecutionUnit)this, results.getPayors(), "Annuity payors from from DB was null.", "invalid value");
        ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, Integer.valueOf(annuity.getPayors().size()), Integer.valueOf(results.getPayors().size()), "Annuity payors size from Client is not equal to DB value", "Mismatch was found");
        IPayor clientPayor = null;
        for (int i = 0; i < annuity.getPayors().size(); ++i) {
            found = false;
            clientPayor = annuity.getPayors().get(i);
            for (IPayor resultPayor : results.getPayors()) {
                if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                found = true;
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
            }
            if (found || clientPayor == null) continue;
            throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
        }
    }

    private void verifyHolder(IAnnuityHolder annuityHolder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder Holdresult = this.getAnnuityBeansFactory().createAnnuityHolder();
        Holdresult.setId(annuityHolder.getId());
        Holdresult.setConfiguration(this.getConfiguration());
        Holdresult = this.getServerAdapter().findHolderById(Holdresult);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder, Holdresult, "Annuity Holder from Client is not equal to DB value", "Mismatch was found.");
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder.getContact(), Holdresult.getContact(), "Annuity Holder Contact from Client is not equal to DB value", "Mismatch was found.");
    }

    private void verifyContact(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact conresult = this.getAnnuityBeansFactory().createContact();
        conresult.setId(contact.getId());
        conresult.setConfiguration(this.getConfiguration());
        conresult = this.getServerAdapter().findContactById(conresult);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, conresult, "Contact from Client is not equal to DB value", "Mismatch was found.");
    }

    private void verifyPayor(IPayor payor) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPayor results = this.getAnnuityBeansFactory().createPayor();
        results.setId(payor.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPayorById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, payor, results, "Payor from Client is not equal to DB value", "Mismatch was found");
    }

    private IContact getContact(String sContactId) {
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            contact.setId("C" + sContactId);
        } else {
            contact.setId(sContactId);
        }
        contact.setEmail(sContactId + "@domain.com");
        contact.setPhone(sContactId + "-" + sContactId + "-" + sContactId);
        contact.setContactType(this.getRandomEnum(ContactType.class));
        IAddress address = BasicExecutionUnitLibrarry.getAddress(this.getAnnuityBeansFactory());
        address.setLine1(sContactId + " Main Street");
        address.setLine2("APT # " + sContactId);
        address.setCity("Austin");
        address.setState("Texas");
        address.setZipCode("78758");
        address.setCountry("USA");
        contact.setAddress(address);
        return contact;
    }

    private IAnnuityHolder getAnnuityHolder(String sHolderId) {
        IAnnuityHolder annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(sHolderId);
        annuityHolder.setDateOfBirth(new Date());
        annuityHolder.setFirstName(sHolderId + " FirstName");
        annuityHolder.setLastName(sHolderId + " LastName");
        annuityHolder.setGovernmentId(sHolderId + "-111-22-3333");
        annuityHolder.setLastUpdateDate(new Date());
        annuityHolder.setTimeOfBirth(new Date());
        annuityHolder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        return annuityHolder;
    }

    private IPayor getPayor(String sPayorId) {
        IPayor payor = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            payor.setId("P" + sPayorId);
        } else {
            payor.setId(sPayorId);
        }
        payor.setName(sPayorId + " DB Auto Populate");
        return payor;
    }

    private IRider getRider(String sRiderId) {
        IRider rider = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            rider.setId("R" + sRiderId);
        } else {
            rider.setId(sRiderId);
        }
        rider.setRule(sRiderId + ":" + rider.getRule());
        rider.setType(this.getRandomEnum(RiderType.class));
        return rider;
    }

    private IPayout getPayout(String sPayoutId) {
        IPayout payout = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            payout.setId("PT" + sPayoutId);
        } else {
            payout.setId(sPayoutId);
        }
        payout.setTaxableAmount(new BigDecimal(this.populateRandom.nextDouble() * 1000.0));
        int dateDeviation = this.populateRandom.nextInt(1000);
        Calendar endDate = payout.getEndDate();
        endDate.add(5, dateDeviation);
        payout.setEndDate(endDate);
        Calendar startDate = payout.getStartDate();
        startDate.add(5, -dateDeviation);
        payout.setStartDate(startDate);
        return payout;
    }

    private IAnnuity getAnnuity(String sAnnuityId) {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), this.getRandomEnum(AnnuityType.class));
        if (this.useCharPrefixID) {
            annuity.setId("A" + sAnnuityId);
        } else {
            annuity.setId(sAnnuityId);
        }
        annuity.setAccountNumber(sAnnuityId + "123456");
        annuity.setLastPaidAmt(new Double(this.populateRandom.nextDouble()));
        annuity.setAmount(new Double(this.populateRandom.nextDouble()));
        annuity.setLastUpdateDate(new Date());
        return annuity;
    }
}

