/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.Identifiable;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.BeneContactId;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class ReadBeneficiaryFromHolderEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = 3877652038279179804L;
    private String useId = null;
    private int maxId = 0;
    private int startId = 0;
    private static final String USE_ID = "useId";
    private static final String MAX_ID = "maxId";
    private static final String START_ID_KEY = "startId";
    AcmeLogger logger = null;

    public void execute() {
        String sHolderId = null;
        Identifiable beneficiaryHolder = null;
        this.setScenarioVariables();
        if (this.useId == null && this.maxId == 0) {
            this.logger.severe("Scenario parameter error: Either useId or maxId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            InvalidArgumentException e = new InvalidArgumentException("Scenario parameter error: Either useId or maxId must be set > 0 for scenario");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("After getting parameters, Begin execution");
        sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
        int count = 0;
        while (beneficiaryHolder == null && count < 3) {
            sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
            this.logger.fine("Looking up id: " + sHolderId);
            try {
                beneficiaryHolder = this.findAnnuityHolder(sHolderId);
            }
            catch (Exception e) {
                if (this.useId != null) {
                    this.logger.warning("failed to find Holder, Id = " + sHolderId + " Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                this.logger.warning("Exception while looking up Holder with, id: " + sHolderId + "Error: " + e);
                ++count;
            }
        }
        if (count >= 3) {
            this.logger.warning("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            EntityNotFoundException e = new EntityNotFoundException("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("Successful find of Holder, id = " + (String)beneficiaryHolder.getId() + " Call verify");
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)beneficiaryHolder.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.severe("Failed on verify find holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        List<IBeneficiary> beneficiaryListResults = null;
        try {
            this.logger.fine("Looking up beneficiaries for holder ID: " + (String)beneficiaryHolder.getId());
            beneficiaryHolder.setConfiguration(this.getConfiguration());
            beneficiaryListResults = this.getServerAdapter().findHolderBeneficiaries((IAnnuityHolder)beneficiaryHolder);
            this.logger.fine("Looked up beneficiaries for holder ID: " + (String)beneficiaryHolder.getId());
        }
        catch (Exception e) {
            this.logger.severe("Error Holder ID: " + (String)beneficiaryHolder.getId() + " failed finding beneficiaries. Exception: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (beneficiaryListResults != null) {
            this.logger.fine("HolderId: " + sHolderId + " has: " + beneficiaryListResults.size() + " beneficiaries");
            Iterator<IBeneficiary> it = beneficiaryListResults.iterator();
            while (it.hasNext()) {
                try {
                    IBeneficiary benef = it.next();
                    this.logger.fine("HolderId: " + benef.getAnnuityHolderId() + " Beneficiary ID: " + (String)benef.getId());
                    ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, (String)benef.getId(), sHolderId, "ERROR: requested beneficiary id: " + (String)benef.getId(), " does not contain holder id: " + sHolderId);
                    for (int i = 0; i < benef.getBeneContacts().size(); ++i) {
                        this.logger.fine("Beneficiary's contact number (" + ((BeneContactId)benef.getBeneContacts().get(i).getId()).getContactType().toString() + ") is: " + benef.getBeneContacts().get(i).getPhone());
                    }
                }
                catch (Exception e) {
                    this.logger.severe("validating holder ID: " + sHolderId + " Failed for beneficiary: ");
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
        } else {
            this.logger.warning("Holder ID: " + sHolderId + " has 0 beneficiaries");
            EntityNotFoundException e = new EntityNotFoundException("Holder ID: " + sHolderId + " has 0 beneficiaries");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
        }
        catch (Exception e) {
            this.logger.warning("useId parameter not in config file, use random");
        }
        try {
            this.maxId = this.getParameterValueInt(MAX_ID);
        }
        catch (Exception e) {
            this.logger.warning("maxId parameter not in config file, use default max");
        }
        try {
            this.startId = this.getParameterValueInt(START_ID_KEY);
        }
        catch (Exception e) {
            this.logger.warning("the attribute:startId is missing for scenario: " + this.getDescription() + " .Setting the default to 1");
            this.startId = 1;
        }
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }
}

