/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class CreateAnnuityHolderEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
            holder.setConfiguration(this.getConfiguration());
            this.logger.fine("ready to create holder: " + holder);
            IAnnuityHolder result = this.getServerAdapter().createAnnuityHolder(holder);
            this.logger.fine("created holder: " + result);
            if (this.enableVerify) {
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, holder, result, "AnnuityHolder Value from client did not match DB. ", "Mismatch was Found");
            }
            this.getStackMap().put("annuityHolderId", result.getId());
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

