/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3mdb;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3mdb.AnnuityEJB3MDBServiceProxy;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJB3MDBServiceLookup {
    static final long JMSREPLYTIMEOUT = 30000L;

    public static IAnnuityService getAnnuityEJB3MDBService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException, JMSException {
        try {
            String connFactoryJNDI = (String)configrable.getConfiguration().getParameterValue((Object)"ACMEAnnuityJMSConnectionFactoryJNDI");
            String destQueueJNDI = (String)configrable.getConfiguration().getParameterValue((Object)"AcmeAnnuityMgmtSvcEJB30MDBQueueJNDI");
            String consumerReceiveTimeoutStr = (String)configrable.getConfiguration().getParameterValue((Object)"consumerReceiveTimeout");
            long consumerReceiveTimeout = 30000L;
            if (connFactoryJNDI == null || connFactoryJNDI.trim().length() == 0) {
                connFactoryJNDI = "jms/ACMEAnnuityJMSConnectionFactory";
            }
            if (destQueueJNDI == null || destQueueJNDI.trim().length() == 0) {
                destQueueJNDI = "jms/AcmeAnnuityMgmtSvcEJB30MDBQueue";
            }
            if (consumerReceiveTimeoutStr == null || consumerReceiveTimeoutStr.trim().length() == 0) {
                consumerReceiveTimeout = 30000L;
            } else {
                try {
                    consumerReceiveTimeout = Long.parseLong(consumerReceiveTimeoutStr);
                }
                catch (Exception e) {
                    consumerReceiveTimeout = 30000L;
                }
            }
            Properties p = new Properties();
            p.put("java.naming.factory.initial", configrable.getConfiguration().getParameterValue((Object)"initialContextFactory"));
            String iiopAddress = (String)configrable.getConfiguration().getParameterValue((Object)"iiopAddress");
            p.put("java.naming.provider.url", iiopAddress);
            logger.fine("supplied iiop address is: " + iiopAddress);
            InitialContext ic = configrable.getConfiguration().getParameterValue((Object)"initialContextFactory") != null && configrable.getConfiguration().getParameterValue((Object)"iiopAddress") != null ? new InitialContext(p) : new InitialContext();
            logger.fine("obtained initial context: " + ic);
            ConnectionFactory qcf = (ConnectionFactory)ic.lookup(connFactoryJNDI);
            Destination queue = (Destination)ic.lookup(destQueueJNDI);
            return new AnnuityEJB3MDBServiceProxy(qcf, queue, consumerReceiveTimeout, logger);
        }
        catch (NamingException e) {
            String msg = "Failed to obtain initial context.  initialContextFactory:" + (String)configrable.getConfiguration().getParameterValue((Object)"initialContextFactory") + "iiopAddress: " + (String)configrable.getConfiguration().getParameterValue((Object)"iiopAddress") + " Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e);
            throw new NamingException(msg);
        }
    }
}

