package com.ibm.ws.servletContainerInitializer;

import java.util.HashMap;
import java.util.Set;

import javax.servlet.ServletContext;

public class SCIParentImpl {

    public void doOnStartup(String name, String className, Set<Class<?>> classesSet, ServletContext sc) {
        sc.setAttribute(name, "executed");
        System.out.println("onStartup called for " + className);
        if (classesSet!=null) {
            for (Class c: classesSet) {
                System.out.println("     *****Class passed to onStartup - "+c.getName());
                /*if (com.ibm.ws.servletContainerInitializer.AnnotatedServlet.class.equals(c)) {
                    com.ibm.ws.servletContainerInitializer.AnnotatedServlet.incrementInitValue();
                }*/
                synchronized (sc) {
                    HashMap<String, Set<Class<?>>> hm;
                    if (sc.getAttribute("classesSetHashMap")!=null) {
                        hm = (HashMap<String, Set<Class<?>>>) sc.getAttribute("classesSetHashMap");
                    } else {
                        hm = new HashMap<String, Set<Class<?>>>();
                    }
                    hm.put(className, classesSet);
                    sc.setAttribute("classesSetHashMap", hm);
                }
            }
        } else {
            System.out.println("     *****No classes passed to onStartup");
        }
    }
}
