/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.ws.rs.WebApplicationException;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.providers.TestResponseExceptionMapper;
import org.eclipse.microprofile.rest.client.tck.providers.TestResponseExceptionMapperOverridePriority;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ExceptionMapperTest
extends WiremockArquillianTest {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ExceptionMapperTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{TestResponseExceptionMapper.class, TestResponseExceptionMapperOverridePriority.class})).addClass(WiremockArquillianTest.class)).addClasses(new Class[]{SimpleGetApi.class});
    }

    @BeforeTest
    public void resetHandlers() {
        TestResponseExceptionMapper.reset();
        TestResponseExceptionMapperOverridePriority.reset();
    }

    @Test
    public void testWithOneRegisteredProvider() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withHeader("CustomHeader", new String[]{"true"}).withBody("body is ignored in this test")));
        SimpleGetApi simpleGetApi = (SimpleGetApi)((RestClientBuilder)RestClientBuilder.newBuilder().baseUrl(ExceptionMapperTest.getServerURL()).register(TestResponseExceptionMapper.class)).build(SimpleGetApi.class);
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown via the registered " + TestResponseExceptionMapper.class));
        }
        catch (WebApplicationException w) {
            Assert.assertEquals((String)"A 200 OK was received, but I'm throwing an exception", (String)w.getMessage(), (String)("The message should be sourced from " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isHandlesCalled(), (String)("The handles method should have been called on " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isThrowableCalled(), (String)("The toThrowable method should have been called on " + TestResponseExceptionMapper.class));
        }
    }

    @Test
    public void testWithTwoRegisteredProviders() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withHeader("CustomHeader", new String[]{"true"}).withBody("body is ignored in this test")));
        SimpleGetApi simpleGetApi = (SimpleGetApi)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().baseUrl(ExceptionMapperTest.getServerURL()).register(TestResponseExceptionMapper.class)).register(TestResponseExceptionMapperOverridePriority.class)).build(SimpleGetApi.class);
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown via the registered " + TestResponseExceptionMapper.class));
        }
        catch (WebApplicationException w) {
            Assert.assertTrue((boolean)TestResponseExceptionMapperOverridePriority.isHandlesCalled(), (String)("The handles method should have been called on " + TestResponseExceptionMapperOverridePriority.class));
            Assert.assertFalse((boolean)TestResponseExceptionMapperOverridePriority.isThrowableCalled(), (String)("The toThrowable method should not have been called on " + TestResponseExceptionMapperOverridePriority.class));
            Assert.assertEquals((String)"A 200 OK was received, but I'm throwing an exception", (String)w.getMessage(), (String)("The message should be sourced from " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isHandlesCalled(), (String)("The handles method should have been called on " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isThrowableCalled(), (String)("The toThrowable method should have been called on " + TestResponseExceptionMapper.class));
        }
    }
}

