/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ProductMatch;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;
import wlp.lib.extract.ZipLicenseProvider;

public class SelfExtractor
implements LicenseProvider {
    private static SelfExtractor instance;
    private static final boolean isWindows;
    protected final ZipFile jarFile;
    protected final String root;
    private final List productMatches;
    private final String archiveContentType;
    private final String providedFeatures;
    private final boolean productAddOn;
    private final boolean extractInstaller;
    private final LicenseProvider licenseProvider;
    private final String requiredFeatures;
    private static final String EXTERNAL_DEPS_FILE = "externaldependencies.xml";
    private boolean doExternalDepsDownload = true;
    private ExternalDependencies externalDeps = null;
    private final boolean licensePresent;
    private File userDirOverride = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") >= 0;
    }

    public File getUserDirOverride() {
        return this.userDirOverride;
    }

    public void setUserDirOverride(File userDirOverride) {
        this.userDirOverride = userDirOverride;
    }

    protected SelfExtractor(JarFile jar, LicenseProvider licenseProvider, Attributes attributes) {
        this.jarFile = jar;
        this.licensePresent = licenseProvider != null;
        this.licenseProvider = licenseProvider;
        String rootDir = attributes.getValue("Archive-Root");
        this.root = rootDir != null ? rootDir : "";
        String appliesTo = attributes.getValue("Applies-To");
        this.extractInstaller = Boolean.valueOf(attributes.getValue("Extract-Installer"));
        this.requiredFeatures = attributes.getValue("Require-Feature");
        this.productMatches = SelfExtractor.parseAppliesTo(appliesTo);
        this.productAddOn = !this.productMatches.isEmpty();
        this.archiveContentType = attributes.getValue("Archive-Content-Type");
        this.providedFeatures = attributes.getValue("Provide-Feature");
    }

    public static List parseAppliesTo(String appliesTo) {
        ArrayList<ProductMatch> matches = new ArrayList<ProductMatch>();
        if (appliesTo != null) {
            boolean quoted = false;
            int index = 0;
            ProductMatch match = new ProductMatch();
            int i = 0;
            while (i < appliesTo.length()) {
                char c = appliesTo.charAt(i);
                if (c == '\"') {
                    boolean bl = quoted = !quoted;
                }
                if (!quoted) {
                    if (c == ',') {
                        matches.add(match);
                        match = new ProductMatch();
                    } else if (c == ';') {
                        match.add(appliesTo.substring(index, i));
                        index = i + 1;
                    }
                }
                ++i;
            }
            match.add(appliesTo.substring(index));
            matches.add(match);
        }
        return matches;
    }

    public static final SelfExtractor getInstance() {
        return instance;
    }

    public static final ReturnCode buildInstance() {
        ReturnCode buildLicenseProviderReturnCode;
        if (instance != null) {
            return ReturnCode.OK;
        }
        File self = SelfExtractUtils.getSelf();
        if (self == null) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        JarFile jar = null;
        String laPrefix = null;
        String liPrefix = null;
        Attributes mainAttributes = null;
        boolean hasLicense = true;
        try {
            jar = new JarFile(self);
            Manifest man = jar.getManifest();
            mainAttributes = man.getMainAttributes();
            laPrefix = mainAttributes.getValue("License-Agreement");
            liPrefix = mainAttributes.getValue("License-Information");
            hasLicense = laPrefix != null && liPrefix != null;
        }
        catch (Exception e) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        if (hasLicense && (buildLicenseProviderReturnCode = ZipLicenseProvider.buildInstance(jar, laPrefix, liPrefix)) != ReturnCode.OK) {
            return buildLicenseProviderReturnCode;
        }
        boolean isIfix = false;
        String ifixExtractorNameString = null;
        String archiveContentType = mainAttributes.getValue("Archive-Content-Type");
        if ("ifix".equals(archiveContentType)) {
            isIfix = true;
            ifixExtractorNameString = mainAttributes.getValue("Archive-Extractor-Class");
            if (ifixExtractorNameString == null) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class"});
            }
        }
        if (isIfix) {
            String ifixExtractorName = ifixExtractorNameString;
            try {
                Class<?> ifixExtractorClass = Class.forName(ifixExtractorName);
                Class[] classArray = new Class[3];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.jar.JarFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("wlp.lib.extract.LicenseProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.util.jar.Attributes");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                Constructor<?> ifixExtractorConstructor = ifixExtractorClass.getConstructor(classArray);
                Object ifixExtractorObjectInstance = ifixExtractorConstructor.newInstance(jar, hasLicense ? ZipLicenseProvider.getInstance() : null, mainAttributes);
                if (!(ifixExtractorObjectInstance instanceof SelfExtractor)) {
                    return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString});
                }
                instance = (SelfExtractor)ifixExtractorObjectInstance;
            }
            catch (ClassNotFoundException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
            catch (SecurityException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
            catch (NoSuchMethodException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
            catch (IllegalArgumentException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
            catch (InstantiationException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
            catch (IllegalAccessException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
            catch (InvocationTargetException e) {
                return new ReturnCode(2, "invalidPatchWithFix", new Object[]{"Archive-Extractor-Class : " + ifixExtractorNameString + " : " + e.getMessage()});
            }
        }
        instance = new SelfExtractor(jar, hasLicense ? ZipLicenseProvider.getInstance() : null, mainAttributes);
        return ReturnCode.OK;
    }

    public InputStream getLicenseAgreement() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseAgreement();
    }

    public InputStream getLicenseInformation() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseInformation();
    }

    public String getProgramName() {
        return this.licenseProvider == null ? null : this.licenseProvider.getProgramName();
    }

    public String getLicenseName() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseName();
    }

    public boolean hasLicense() {
        return this.licensePresent;
    }

    public int getSize() {
        return this.jarFile.size();
    }

    public int getTotalDepsSize() {
        try {
            return this.getExternalDependencies().getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getRoot() {
        return this.productAddOn ? "" : this.root;
    }

    public ReturnCode validate(File outputDir) {
        File[] files;
        boolean dirExists = outputDir.exists();
        if (this.productAddOn) {
            ReturnCode result = SelfExtractor.validateProductMatches(outputDir, this.productMatches);
            if (result.getCode() == 0) {
                try {
                    Set missingFeatures = this.listMissingCoreFeatures(outputDir);
                    if (!missingFeatures.isEmpty()) {
                        result = new ReturnCode(1, "missingRequiredFeatures", new Object[]{this.jarFile.getName(), missingFeatures, outputDir});
                    }
                }
                catch (SelfExtractorFileException sefe) {
                    result = new ReturnCode(1, "fileProcessingException", new Object[]{sefe.getFileName(), sefe.getCause()});
                }
            }
            return result;
        }
        if (dirExists && (files = outputDir.listFiles()) != null && files.length > 0) {
            return new ReturnCode(4, "extractDirectoryExists", outputDir.getAbsolutePath());
        }
        return ReturnCode.OK;
    }

    public static ReturnCode validateProductMatches(File outputDir, List productMatches) {
        block22: {
            boolean dirExists = outputDir.exists();
            if (dirExists) {
                File f = new File(outputDir, "lib/versions");
                File[] files = f.listFiles();
                if (files == null || files.length == 0) {
                    return new ReturnCode(4, "invalidInstall", outputDir.getAbsolutePath());
                }
                int i = 0;
                while (i < files.length) {
                    block21: {
                        Properties props = new Properties();
                        InputStream is = null;
                        try {
                            try {
                                is = new FileInputStream(files[i]);
                                props.load(is);
                            }
                            catch (IOException iOException) {
                                if (is == null) break block21;
                                try {
                                    is.close();
                                }
                                catch (IOException iOException2) {}
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        Iterator matches = productMatches.iterator();
                        while (matches.hasNext()) {
                            ProductMatch match = (ProductMatch)matches.next();
                            int result = match.matches(props);
                            if (result == -1) continue;
                            if (result == -2) {
                                return new ReturnCode(4, "invalidVersion", new Object[]{props.getProperty("com.ibm.websphere.productVersion"), match.getVersion()});
                            }
                            if (result == -3) {
                                return new ReturnCode(4, "invalidEdition", new Object[]{props.getProperty("com.ibm.websphere.productEdition"), match.getEditions()});
                            }
                            if (result == -4) {
                                return new ReturnCode(4, "invalidInstallType", new Object[0]);
                            }
                            break block22;
                        }
                    }
                    ++i;
                }
            } else {
                return new ReturnCode(4, "invalidInstall", outputDir.getAbsolutePath());
            }
        }
        return ReturnCode.OK;
    }

    public ReturnCode extract(File wlpInstallDir, ExtractProgress ep) {
        ReturnCode rc;
        ArrayList<File> createdDirectoriesAndFiles = new ArrayList<File>();
        File outputDir = null;
        if (this.isUserSample()) {
            outputDir = this.userDirOverride != null ? this.userDirOverride : SelfExtractor.determineTargetUserDirectory(wlpInstallDir);
            SelfExtract.out("targetUserDirectory", new Object[]{outputDir.getAbsolutePath()});
        } else {
            outputDir = wlpInstallDir;
        }
        boolean dirExists = outputDir.exists();
        if (!dirExists && !SelfExtractUtils.trackedMkdirs(outputDir, createdDirectoriesAndFiles)) {
            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
            return new ReturnCode(4, "extractDirectoryError", outputDir.getAbsolutePath());
        }
        if (ep == null) {
            ep = new NullExtractProgress();
        }
        if (this.doExternalDepsDownload && this.hasExternalDepsFile()) {
            List depList = null;
            try {
                depList = this.getExternalDependencies().getDependencies();
            }
            catch (Exception e) {
                return new ReturnCode(2, "readDepsError", new Object[0]);
            }
            SelfExtract.out("downloadingBeginNotice", new Object[]{"--verbose"});
            byte[] buffer = new byte[4096];
            int i = 0;
            while (i < depList.size()) {
                ExternalDependency thisDep = (ExternalDependency)depList.get(i);
                URL sourceUrl = thisDep.getSourceUrl();
                String targetPath = thisDep.getTargetPath();
                File usrDir = outputDir;
                File targetFile = new File(usrDir, targetPath);
                File targetDir = targetFile.getParentFile();
                if (!targetFile.exists() || !this.productAddOn) {
                    if (!SelfExtractUtils.trackedMkdirs(targetDir, createdDirectoriesAndFiles) && !targetDir.exists()) {
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        return new ReturnCode(4, "extractDirectoryError", targetDir.getAbsolutePath());
                    }
                    ep.downloadingFile(sourceUrl, targetFile);
                    createdDirectoriesAndFiles.add(targetFile);
                    InputStream input = null;
                    FileOutputStream output = null;
                    try {
                        try {
                            URLConnection uc = sourceUrl.openConnection();
                            uc.setReadTimeout(30000);
                            input = uc.getInputStream();
                            output = new FileOutputStream(targetFile);
                            int n = -1;
                            while ((n = input.read(buffer)) != -1) {
                                ((OutputStream)output).write(buffer, 0, n);
                                ep.dataDownloaded(n);
                            }
                        }
                        catch (IOException ioe) {
                            SelfExtractUtils.tryToClose(output);
                            SelfExtractUtils.tryToClose(input);
                            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                            ReturnCode returnCode = new ReturnCode(4, "downloadFileError", new String[]{sourceUrl.toString(), targetFile.toString()});
                            SelfExtractUtils.tryToClose(output);
                            SelfExtractUtils.tryToClose(input);
                            return returnCode;
                        }
                    }
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(output);
                        SelfExtractUtils.tryToClose(input);
                        throw throwable;
                    }
                    SelfExtractUtils.tryToClose(output);
                    SelfExtractUtils.tryToClose(input);
                }
                ++i;
            }
        }
        byte[] buf = new byte[4096];
        ArrayList<String> extractedFiles = new ArrayList<String>();
        boolean continueInstall = true;
        int len = this.root.length();
        SelfExtract.out("extractDirectory", new Object[]{outputDir.getAbsolutePath()});
        Enumeration<? extends ZipEntry> en = this.jarFile.entries();
        while (continueInstall && en.hasMoreElements()) {
            File file;
            ZipEntry ze = en.nextElement();
            String name = ze.getName();
            if (ze.isDirectory() && (name.startsWith(this.root) || name.startsWith("META-INF/"))) {
                if (!this.extractInstaller && (name.startsWith("META-INF/") || name.startsWith("wlp/lib/extract/"))) {
                    ep.skippedFile();
                    continue;
                }
                if (name.startsWith("META-INF/")) {
                    file = new File(outputDir, "lib/extract");
                    if (!file.exists() && !SelfExtractUtils.trackedMkdirs(file, createdDirectoriesAndFiles)) {
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        return new ReturnCode(4, "extractDirectoryError", file.getAbsolutePath());
                    }
                    file = new File(file, name);
                } else {
                    file = new File(outputDir, name.substring(len));
                }
                if (!file.exists() && !SelfExtractUtils.trackedMkdirs(file, createdDirectoriesAndFiles)) {
                    SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                    return new ReturnCode(4, "extractDirectoryError", file.getAbsolutePath());
                }
                ep.skippedFile();
            } else if (name.startsWith(this.root) || name.startsWith("META-INF/")) {
                if (!this.extractInstaller && (name.startsWith("META-INF/") || name.startsWith("wlp/lib/extract/"))) {
                    ep.skippedFile();
                    continue;
                }
                if (name.startsWith("META-INF/")) {
                    file = new File(outputDir, "lib/extract");
                    file = new File(file, name);
                } else {
                    file = new File(outputDir, name.substring(len));
                }
                if (file.exists() && this.productAddOn) continue;
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !SelfExtractUtils.trackedMkdirs(parentFile, createdDirectoriesAndFiles)) {
                    SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                    return new ReturnCode(4, "extractDirectoryError", parentFile.getAbsolutePath());
                }
                ep.extractedFile(name);
                extractedFiles.add(name);
                createdDirectoriesAndFiles.add(file);
                BufferedOutputStream os = null;
                InputStream is = null;
                try {
                    try {
                        int read;
                        os = new BufferedOutputStream(new FileOutputStream(file));
                        is = this.jarFile.getInputStream(ze);
                        while ((read = is.read(buf)) != -1) {
                            ((OutputStream)os).write(buf, 0, read);
                        }
                    }
                    catch (IOException ioe) {
                        SelfExtractUtils.tryToClose(os);
                        SelfExtractUtils.tryToClose(is);
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        ReturnCode returnCode = new ReturnCode(4, "extractFileError", ioe.getMessage());
                        SelfExtractUtils.tryToClose(os);
                        SelfExtractUtils.tryToClose(is);
                        return returnCode;
                    }
                }
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(os);
                    SelfExtractUtils.tryToClose(is);
                    throw throwable;
                }
                SelfExtractUtils.tryToClose(os);
                SelfExtractUtils.tryToClose(is);
            } else {
                ep.skippedFile();
            }
            boolean bl = continueInstall = !ep.isCanceled();
        }
        if (continueInstall && (rc = this.fixScriptPermissions(ep, outputDir)) != null) {
            return rc;
        }
        if (this.productAddOn) {
            SelfExtractor.printNeededIFixes(outputDir, extractedFiles);
        }
        if (!continueInstall) {
            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
        }
        return ReturnCode.OK;
    }

    public ReturnCode fixScriptPermissions(ExtractProgress ep, File outputDir) {
        return this.fixScriptPermissions(ep, outputDir, null);
    }

    public ReturnCode fixScriptPermissions(ExtractProgress ep, File outputDir, ZipFile filter) {
        if (!isWindows) {
            File[] binFiles = new File(outputDir, "bin").listFiles();
            if (binFiles != null && filter != null) {
                ArrayList<File> filteredBinFiles = new ArrayList<File>();
                int i = 0;
                while (i < binFiles.length) {
                    File currBinFile = binFiles[i];
                    if (filter.getEntry("bin/" + currBinFile.getName()) != null) {
                        filteredBinFiles.add(currBinFile);
                    }
                    ++i;
                }
                binFiles = filteredBinFiles.size() == 0 ? (File[])null : filteredBinFiles.toArray(new File[filteredBinFiles.size()]);
            }
            if (binFiles != null) {
                ArrayList scripts = new ArrayList();
                this.collectScripts(binFiles, scripts);
                Exception e = SelfExtractUtils.makeExecutable(scripts, ep);
                if (e != null) {
                    return new ReturnCode(4, "chmodError", e.getMessage());
                }
            }
        }
        return null;
    }

    public static File determineTargetUserDirectory(File wlpInstallDir) {
        File defaultUserDir = new File(wlpInstallDir, "usr");
        File serverEnvFile = new File(wlpInstallDir, "etc/server.env");
        if (serverEnvFile.exists()) {
            Properties serverEnvProps;
            block9: {
                serverEnvProps = new Properties();
                FileInputStream serverEnvStream = null;
                try {
                    try {
                        serverEnvStream = new FileInputStream(serverEnvFile);
                        serverEnvProps.load(serverEnvStream);
                    }
                    catch (Exception exception) {
                        SelfExtractUtils.tryToClose(serverEnvStream);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(serverEnvStream);
                    throw throwable;
                }
                SelfExtractUtils.tryToClose(serverEnvStream);
            }
            String customUserDir = serverEnvProps.getProperty("WLP_USER_DIR");
            if (customUserDir != null && !"".equals(customUserDir)) {
                return new File(customUserDir);
            }
        } else {
            String envVarUserDir = System.getenv("WLP_USER_DIR");
            if (envVarUserDir != null && !"".equals(envVarUserDir)) {
                return new File(envVarUserDir);
            }
        }
        return defaultUserDir;
    }

    public boolean isUserSample() {
        return this.archiveContentType != null && this.archiveContentType.equalsIgnoreCase("sample");
    }

    public boolean isProductAddon() {
        return this.productAddOn;
    }

    public String getArchiveContentType() {
        return this.archiveContentType;
    }

    public String getProvidedFeatures() {
        return this.providedFeatures;
    }

    public boolean hasExternalDepsFile() {
        return this.jarFile.getEntry(EXTERNAL_DEPS_FILE) != null;
    }

    public void setDoExternalDepsDownload(boolean value) {
        this.doExternalDepsDownload = value;
    }

    private void buildExternalDependencies() throws Exception {
        ZipEntry depsEntry = null;
        ExternalDependencies newDeps = new ExternalDependencies();
        depsEntry = this.jarFile.getEntry(EXTERNAL_DEPS_FILE);
        if (depsEntry != null) {
            InputStream entryInputStream = null;
            try {
                entryInputStream = this.jarFile.getInputStream(depsEntry);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(entryInputStream);
                Element rootEle = doc.getDocumentElement();
                newDeps.setDescription(rootEle.getAttribute("description"));
                NodeList dependencies = rootEle.getElementsByTagName("dependency");
                int i = 0;
                while (i < dependencies.getLength()) {
                    Node node = dependencies.item(i);
                    Element ele = (Element)node;
                    URL sourceUrl = new URL(ele.getAttribute("url"));
                    String targetPath = ele.getAttribute("targetpath");
                    newDeps.add(sourceUrl, targetPath);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(entryInputStream);
                throw throwable;
            }
            SelfExtractUtils.tryToClose(entryInputStream);
        }
        this.externalDeps = newDeps;
    }

    public ExternalDependencies getExternalDependencies() throws Exception {
        if (this.externalDeps == null) {
            this.buildExternalDependencies();
        }
        return this.externalDeps;
    }

    public static void printNeededIFixes(File outputDir, List extractedFiles) {
        try {
            Runtime runtime = Runtime.getRuntime();
            String productInfo = new File(outputDir, isWindows ? "bin/productInfo.bat" : "bin/productInfo").getAbsolutePath();
            String[] runtimeCmd = new String[]{productInfo, "validate"};
            Process process = runtime.exec(runtimeCmd, null, new File(outputDir, "bin"));
            Thread stderrCopier = new Thread((Runnable)new OutputStreamCopier(process.getErrorStream(), System.err));
            stderrCopier.start();
            new OutputStreamCopier(process.getInputStream(), System.out).run();
            try {
                stderrCopier.join();
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.getCause();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private void collectScripts(File[] files, List scripts) {
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            File[] childFiles = file.listFiles();
            if (childFiles != null) {
                this.collectScripts(childFiles, scripts);
            } else if (file.getName().indexOf(46) == -1) {
                scripts.add(file.getPath());
            }
            ++i;
        }
    }

    private Set listMissingCoreFeatures(File outputDir) throws SelfExtractorFileException {
        HashSet<String> missingFeatures = new HashSet<String>();
        if (this.requiredFeatures != null && !"".equals(this.requiredFeatures)) {
            StringTokenizer tokenizer = new StringTokenizer(this.requiredFeatures, ",");
            while (tokenizer.hasMoreElements()) {
                missingFeatures.add(tokenizer.nextToken().trim());
            }
            FilenameFilter manifestFilter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    boolean result = false;
                    if (name.endsWith(".mf")) {
                        result = true;
                    }
                    return result;
                }
            };
            File featuresDir = new File(outputDir + "/lib/features");
            File[] manifestFiles = featuresDir.listFiles(manifestFilter);
            if (manifestFiles != null) {
                int i = 0;
                while (i < manifestFiles.length && !missingFeatures.isEmpty()) {
                    FileInputStream fis = null;
                    File currentManifestFile = null;
                    try {
                        try {
                            currentManifestFile = manifestFiles[i];
                            fis = new FileInputStream(currentManifestFile);
                            Manifest currentManifest = new Manifest(fis);
                            Attributes attrs = currentManifest.getMainAttributes();
                            String manifestSymbolicName = attrs.getValue("Subsystem-SymbolicName");
                            if (manifestSymbolicName.indexOf(";") >= 0) {
                                manifestSymbolicName = manifestSymbolicName.substring(0, manifestSymbolicName.indexOf(";"));
                            }
                            missingFeatures.remove(manifestSymbolicName);
                        }
                        catch (FileNotFoundException fnfe) {
                            throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), fnfe);
                        }
                        catch (IOException ioe) {
                            throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(fis);
                        throw throwable;
                    }
                    SelfExtractUtils.tryToClose(fis);
                    ++i;
                }
            }
        }
        return missingFeatures;
    }

    public void parseArguments(String[] args, boolean archiveHasLicense) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim().toLowerCase(Locale.ENGLISH);
            if (arg.startsWith("-")) {
                if (SelfExtractor.argIsOption(arg, "-viewlicenseagreement")) {
                    if (archiveHasLicense) {
                        this.showLicenseFile(this.getLicenseAgreement());
                    } else {
                        SelfExtract.out("archiveContainsNoLicense");
                    }
                    System.exit(0);
                } else if (SelfExtractor.argIsOption(arg, "-viewlicenseinfo") || SelfExtractor.argIsOption(arg, "-viewlicenseinformation")) {
                    if (archiveHasLicense) {
                        this.showLicenseFile(this.getLicenseInformation());
                    } else {
                        SelfExtract.out("archiveContainsNoLicense");
                    }
                    System.exit(0);
                } else if (SelfExtractor.argIsOption(arg, "-help")) {
                    SelfExtractor.displayCommandLineHelp(this);
                    System.exit(0);
                } else if (SelfExtractor.argIsOption(arg, "-acceptlicense")) {
                    SelfExtract.setAcceptLicense(true);
                } else if (SelfExtractor.argIsOption(arg, "-downloadDependencies")) {
                    SelfExtract.setDownloadDependencies(true);
                } else if (SelfExtractor.argIsOption(arg, "-verbose")) {
                    SelfExtract.setVerbose(true);
                } else {
                    System.out.println("\n" + SelfExtract.format("invalidOption", arg));
                    SelfExtractor.displayCommandLineHelp(this);
                    System.exit(0);
                }
            } else {
                SelfExtract.setTargetString(args[i]);
            }
            ++i;
        }
    }

    protected static boolean argIsOption(String arg, String option) {
        return arg.equalsIgnoreCase(option) || arg.equalsIgnoreCase(String.valueOf('-') + option);
    }

    private static void displayCommandLineHelp(SelfExtractor extractor) {
        String jarName = System.getProperty("sun.java.command", "wlp-liberty-developers-core.jar");
        String[] s = jarName.split(" ");
        jarName = s[0];
        System.out.println("\n" + SelfExtract.format("usage"));
        System.out.println("\njava -jar " + jarName + " [" + SelfExtract.format("options") + "] [" + SelfExtract.format("installLocation") + "]\n");
        System.out.println(SelfExtract.format("options"));
        System.out.println("    --acceptLicense");
        System.out.println("        " + SelfExtract.format("helpAcceptLicense"));
        System.out.println("    --verbose");
        System.out.println("        " + SelfExtract.format("helpVerbose"));
        System.out.println("    --viewLicenseAgreement");
        System.out.println("        " + SelfExtract.format("helpAgreement"));
        System.out.println("    --viewLicenseInfo");
        System.out.println("        " + SelfExtract.format("helpInformation"));
        if (extractor.isUserSample()) {
            System.out.println("    --downloadDependencies");
            System.out.println("        " + SelfExtract.format("helpDownloadDependencies"));
        }
    }

    public void showLicenseFile(InputStream licenseFile) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("wlp.lib.extract.SelfExtract");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Serializable e = clazz;
        if (licenseFile != null) {
            e = SelfExtractUtils.showLicenseFile(licenseFile);
        }
        if (e != null) {
            SelfExtract.err("licenseNotFound");
            System.exit(2);
        }
    }

    public void handleLicenseAcceptance(LicenseProvider licenseProvider, boolean acceptLicense) {
        SelfExtract.wordWrappedOut(SelfExtract.format("licenseStatement", new Object[]{licenseProvider.getProgramName(), licenseProvider.getLicenseName()}));
        System.out.println();
        if (acceptLicense) {
            SelfExtract.wordWrappedOut(SelfExtract.format("licenseAccepted", "--acceptLicense"));
            System.out.println();
        } else if (!SelfExtractor.obtainLicenseAgreement(licenseProvider)) {
            System.exit(0);
        }
    }

    private static boolean obtainLicenseAgreement(LicenseProvider licenseProvider) {
        SelfExtract.wordWrappedOut(SelfExtract.format("showAgreement", "--viewLicenseAgreement"));
        boolean view = SelfExtract.getResponse(SelfExtract.format("promptAgreement"), "", "xX");
        if (view) {
            SelfExtract.showLicenseFile(licenseProvider.getLicenseAgreement());
            System.out.println();
        }
        SelfExtract.wordWrappedOut(SelfExtract.format("showInformation", "--viewLicenseInfo"));
        view = SelfExtract.getResponse(SelfExtract.format("promptInfo"), "", "xX");
        if (view) {
            SelfExtract.showLicenseFile(licenseProvider.getLicenseInformation());
            System.out.println();
        }
        System.out.println();
        SelfExtract.wordWrappedOut(SelfExtract.format("licenseOptionDescription"));
        System.out.println();
        boolean accept = SelfExtract.getResponse(SelfExtract.format("licensePrompt", new Object[]{"[1]", "[2]"}), "1", "2");
        System.out.println();
        return accept;
    }

    public static class ExternalDependencies {
        private String description = "";
        private final List dependencies = new ArrayList();
        private int size = -1;

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void add(URL sourceUrl, String targetPath) {
            this.dependencies.add(new ExternalDependency(sourceUrl, targetPath));
        }

        public List getDependencies() {
            return this.dependencies;
        }

        public int getSize() {
            if (this.size < 0) {
                int total = 0;
                int i = 0;
                while (i < this.dependencies.size()) {
                    URL thisDepURL = ((ExternalDependency)this.dependencies.get(i)).getSourceUrl();
                    int thisDepSize = SelfExtractUtils.tryGetContentLengthOfURL(thisDepURL);
                    if (thisDepSize != -1) {
                        total += thisDepSize;
                    }
                    ++i;
                }
                this.size = total;
            }
            return this.size;
        }
    }

    public static class ExternalDependency {
        private final URL sourceUrl;
        private final String targetPath;

        public ExternalDependency(URL sourceUrl, String targetPath) {
            this.sourceUrl = sourceUrl;
            this.targetPath = targetPath;
        }

        public URL getSourceUrl() {
            return this.sourceUrl;
        }

        public String getTargetPath() {
            return this.targetPath;
        }
    }

    private static class NullExtractProgress
    implements ExtractProgress {
        private NullExtractProgress() {
        }

        public void extractedFile(String f) {
        }

        public void downloadingFile(URL sourceUrl, File targetFile) {
        }

        public void dataDownloaded(int numBytes) {
        }

        public void setFilesToExtract(int count) {
        }

        public void commandRun(List args) {
        }

        public void commandsToRun(int count) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void skippedFile() {
        }
    }

    private static final class SelfExtractorFileException
    extends Exception {
        private final String fileName;

        public SelfExtractorFileException(String fileName, Throwable exception) {
            super(exception);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

