/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.IFixUtils;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ProductMatch;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.ZipLicenseProvider;

public class SelfExtractor
implements LicenseProvider {
    private static final String SUBSYSTEM_SYMBOLIC_NAME = "Subsystem-SymbolicName";
    private static SelfExtractor instance;
    private final ZipFile jarFile;
    private final String root;
    private final List productMatches;
    private final String archiveContentType;
    private final String providedFeatures;
    private final boolean productAddOn;
    private final boolean extractInstaller;
    private final LicenseProvider licenseProvider;
    private final String requiredFeatures;
    private static final String EXTERNAL_DEPS_FILE = "externaldependencies.xml";
    private boolean doExternalDepsDownload = true;
    private ExternalDependencies externalDeps = null;
    private final boolean licensePresent;
    private File userDirOverride = null;

    public File getUserDirOverride() {
        return this.userDirOverride;
    }

    public void setUserDirOverride(File userDirOverride) {
        this.userDirOverride = userDirOverride;
    }

    private SelfExtractor(JarFile jar, LicenseProvider licenseProvider, Attributes attributes) {
        this.jarFile = jar;
        this.licensePresent = licenseProvider != null;
        this.licenseProvider = licenseProvider;
        String rootDir = attributes.getValue("Archive-Root");
        this.root = rootDir != null ? rootDir : "";
        String appliesTo = attributes.getValue("Applies-To");
        this.extractInstaller = Boolean.parseBoolean(attributes.getValue("Extract-Installer"));
        this.requiredFeatures = attributes.getValue("Require-Feature");
        this.productMatches = SelfExtractor.parseAppliesTo(appliesTo);
        this.productAddOn = !this.productMatches.isEmpty();
        this.archiveContentType = attributes.getValue("Archive-Content-Type");
        this.providedFeatures = attributes.getValue("Provide-Feature");
    }

    public static List parseAppliesTo(String appliesTo) {
        ArrayList<ProductMatch> matches = new ArrayList<ProductMatch>();
        if (appliesTo != null) {
            boolean quoted = false;
            int index = 0;
            ProductMatch match = new ProductMatch();
            for (int i = 0; i < appliesTo.length(); ++i) {
                char c = appliesTo.charAt(i);
                if (c == '\"') {
                    boolean bl = quoted = !quoted;
                }
                if (quoted) continue;
                if (c == ',') {
                    matches.add(match);
                    match = new ProductMatch();
                    continue;
                }
                if (c != ';') continue;
                match.add(appliesTo.substring(index, i));
                index = i + 1;
            }
            match.add(appliesTo.substring(index));
            matches.add(match);
        }
        return matches;
    }

    public static final SelfExtractor getInstance() {
        return instance;
    }

    public static final ReturnCode buildInstance() {
        ReturnCode buildLicenseProviderReturnCode;
        if (instance != null) {
            return ReturnCode.OK;
        }
        File self = SelfExtractUtils.getSelf();
        if (self == null) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        JarFile jar = null;
        String laPrefix = null;
        String liPrefix = null;
        Attributes mainAttributes = null;
        boolean hasLicense = true;
        try {
            jar = new JarFile(self);
            Manifest man = jar.getManifest();
            mainAttributes = man.getMainAttributes();
            laPrefix = mainAttributes.getValue("License-Agreement");
            liPrefix = mainAttributes.getValue("License-Information");
            hasLicense = laPrefix != null && liPrefix != null;
        }
        catch (Exception e) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        if (hasLicense && (buildLicenseProviderReturnCode = ZipLicenseProvider.buildInstance(jar, laPrefix, liPrefix)) != ReturnCode.OK) {
            return buildLicenseProviderReturnCode;
        }
        instance = new SelfExtractor(jar, hasLicense ? ZipLicenseProvider.getInstance() : null, mainAttributes);
        return ReturnCode.OK;
    }

    public InputStream getLicenseAgreement() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseAgreement();
    }

    public InputStream getLicenseInformation() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseInformation();
    }

    public String getProgramName() {
        return this.licenseProvider == null ? null : this.licenseProvider.getProgramName();
    }

    public String getLicenseName() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseName();
    }

    public boolean hasLicense() {
        return this.licensePresent;
    }

    public int getSize() {
        return this.jarFile.size();
    }

    public int getTotalDepsSize() {
        try {
            return this.getExternalDependencies().getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getRoot() {
        return this.productAddOn ? "" : this.root;
    }

    public ReturnCode validate(File outputDir) {
        File[] files;
        boolean dirExists = outputDir.exists();
        if (this.productAddOn) {
            ReturnCode result = SelfExtractor.validateProductMatches(outputDir, this.productMatches);
            if (result.getCode() == 0) {
                try {
                    Set missingFeatures = this.listMissingCoreFeatures(outputDir);
                    if (!missingFeatures.isEmpty()) {
                        result = new ReturnCode(1, "missingRequiredFeatures", new Object[]{this.jarFile.getName(), missingFeatures, outputDir});
                    }
                }
                catch (SelfExtractorFileException sefe) {
                    result = new ReturnCode(1, "fileProcessingException", new Object[]{sefe.getFileName(), sefe.getCause()});
                }
            }
            return result;
        }
        if (dirExists && (files = outputDir.listFiles()) != null && files.length > 0) {
            return new ReturnCode(4, "extractDirectoryExists", outputDir.getAbsolutePath());
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnCode validateProductMatches(File outputDir, List productMatches) {
        block21: {
            boolean dirExists = outputDir.exists();
            if (dirExists) {
                File f = new File(outputDir, "lib/versions");
                File[] files = f.listFiles();
                if (files == null || files.length == 0) {
                    return new ReturnCode(4, "invalidInstall", outputDir.getAbsolutePath());
                }
                for (int i = 0; i < files.length; ++i) {
                    Properties props = new Properties();
                    Reader reader = null;
                    try {
                        reader = new InputStreamReader((InputStream)new FileInputStream(files[i]), "UTF-8");
                        props.load(reader);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    Iterator matches = productMatches.iterator();
                    while (matches.hasNext()) {
                        ProductMatch match = (ProductMatch)matches.next();
                        int result = match.matches(props);
                        if (result == -1) continue;
                        if (result == -2) {
                            return new ReturnCode(4, "invalidVersion", new Object[]{props.getProperty("com.ibm.websphere.productVersion"), match.getVersion()});
                        }
                        if (result == -3) {
                            return new ReturnCode(4, "invalidEdition", new Object[]{props.getProperty("com.ibm.websphere.productEdition"), match.getEditions()});
                        }
                        if (result == -4) {
                            return new ReturnCode(4, "invalidInstallType", new Object[0]);
                        }
                        break block21;
                    }
                }
            } else {
                return new ReturnCode(4, "invalidInstall", outputDir.getAbsolutePath());
            }
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode extract(File wlpInstallDir, ExtractProgress ep) {
        File[] binFiles;
        String osName;
        ArrayList<File> createdDirectoriesAndFiles = new ArrayList<File>();
        File outputDir = null;
        if (this.isUserSample()) {
            outputDir = this.userDirOverride != null ? this.userDirOverride : SelfExtractor.determineTargetUserDirectory(wlpInstallDir);
            SelfExtract.out("targetUserDirectory", new Object[]{outputDir.getAbsolutePath()});
        } else {
            outputDir = wlpInstallDir;
        }
        boolean dirExists = outputDir.exists();
        if (!dirExists && !SelfExtractUtils.trackedMkdirs(outputDir, createdDirectoriesAndFiles)) {
            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
            return new ReturnCode(4, "extractDirectoryError", outputDir.getAbsolutePath());
        }
        if (ep == null) {
            ep = new NullExtractProgress();
        }
        if (this.doExternalDepsDownload && this.hasExternalDepsFile()) {
            List depList = null;
            try {
                depList = this.getExternalDependencies().getDependencies();
            }
            catch (Exception e) {
                return new ReturnCode(2, "readDepsError", new Object[0]);
            }
            SelfExtract.out("downloadingBeginNotice", new Object[]{"--verbose"});
            byte[] buffer = new byte[4096];
            for (int i = 0; i < depList.size(); ++i) {
                ExternalDependency thisDep = (ExternalDependency)depList.get(i);
                URL sourceUrl = thisDep.getSourceUrl();
                String targetPath = thisDep.getTargetPath();
                File usrDir = outputDir;
                File targetFile = new File(usrDir, targetPath);
                File targetDir = targetFile.getParentFile();
                if (targetFile.exists() && this.productAddOn) continue;
                if (!SelfExtractUtils.trackedMkdirs(targetDir, createdDirectoriesAndFiles) && !targetDir.exists()) {
                    SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                    return new ReturnCode(4, "extractDirectoryError", targetDir.getAbsolutePath());
                }
                ep.downloadingFile(sourceUrl, targetFile);
                createdDirectoriesAndFiles.add(targetFile);
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    URLConnection uc = sourceUrl.openConnection();
                    uc.setReadTimeout(30000);
                    input = uc.getInputStream();
                    output = new FileOutputStream(targetFile);
                    int n = -1;
                    while ((n = input.read(buffer)) != -1) {
                        ((OutputStream)output).write(buffer, 0, n);
                        ep.dataDownloaded(n);
                    }
                }
                catch (IOException ioe) {
                    ReturnCode returnCode;
                    try {
                        SelfExtractUtils.tryToClose(output);
                        SelfExtractUtils.tryToClose(input);
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        returnCode = new ReturnCode(4, "downloadFileError", new String[]{sourceUrl.toString(), targetFile.toString()});
                    }
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(output);
                        SelfExtractUtils.tryToClose(input);
                        throw throwable;
                    }
                    SelfExtractUtils.tryToClose(output);
                    SelfExtractUtils.tryToClose(input);
                    return returnCode;
                }
                SelfExtractUtils.tryToClose(output);
                SelfExtractUtils.tryToClose(input);
                continue;
            }
        }
        byte[] buf = new byte[4096];
        ArrayList<String> extractedFiles = new ArrayList<String>();
        boolean continueInstall = true;
        int len = this.root.length();
        SelfExtract.out("extractDirectory", new Object[]{outputDir.getAbsolutePath()});
        Enumeration<? extends ZipEntry> en = this.jarFile.entries();
        while (continueInstall && en.hasMoreElements()) {
            block34: {
                block35: {
                    File file;
                    String name;
                    ZipEntry ze;
                    block33: {
                        ze = en.nextElement();
                        name = ze.getName();
                        if (!ze.isDirectory() || !name.startsWith(this.root) && !name.startsWith("META-INF/")) break block33;
                        if (!this.extractInstaller && (name.startsWith("META-INF/") || name.startsWith("wlp/lib/extract/"))) {
                            ep.skippedFile();
                            continue;
                        }
                        if (name.startsWith("META-INF/")) {
                            file = new File(outputDir, "lib/extract");
                            if (!file.exists() && !SelfExtractUtils.trackedMkdirs(file, createdDirectoriesAndFiles)) {
                                SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                return new ReturnCode(4, "extractDirectoryError", file.getAbsolutePath());
                            }
                            file = new File(file, name);
                        } else {
                            file = new File(outputDir, name.substring(len));
                        }
                        if (!file.exists() && !SelfExtractUtils.trackedMkdirs(file, createdDirectoriesAndFiles)) {
                            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                            return new ReturnCode(4, "extractDirectoryError", file.getAbsolutePath());
                        }
                        ep.skippedFile();
                        break block34;
                    }
                    if (!name.startsWith(this.root) && !name.startsWith("META-INF/")) break block35;
                    if (!this.extractInstaller && (name.startsWith("META-INF/") || name.startsWith("wlp/lib/extract/"))) {
                        ep.skippedFile();
                        continue;
                    }
                    if (name.startsWith("META-INF/")) {
                        file = new File(outputDir, "lib/extract");
                        file = new File(file, name);
                    } else {
                        file = new File(outputDir, name.substring(len));
                    }
                    if (file.exists() && this.productAddOn) continue;
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists() && !SelfExtractUtils.trackedMkdirs(parentFile, createdDirectoriesAndFiles)) {
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        return new ReturnCode(4, "extractDirectoryError", parentFile.getAbsolutePath());
                    }
                    ep.extractedFile(name);
                    extractedFiles.add(name);
                    createdDirectoriesAndFiles.add(file);
                    BufferedOutputStream os = null;
                    InputStream is = null;
                    try {
                        int read;
                        os = new BufferedOutputStream(new FileOutputStream(file));
                        is = this.jarFile.getInputStream(ze);
                        while ((read = is.read(buf)) != -1) {
                            ((OutputStream)os).write(buf, 0, read);
                        }
                    }
                    catch (IOException ioe) {
                        ReturnCode returnCode;
                        try {
                            SelfExtractUtils.tryToClose(os);
                            SelfExtractUtils.tryToClose(is);
                            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                            returnCode = new ReturnCode(4, "extractFileError", ioe.getMessage());
                        }
                        catch (Throwable throwable) {
                            SelfExtractUtils.tryToClose(os);
                            SelfExtractUtils.tryToClose(is);
                            throw throwable;
                        }
                        SelfExtractUtils.tryToClose(os);
                        SelfExtractUtils.tryToClose(is);
                        return returnCode;
                    }
                    SelfExtractUtils.tryToClose(os);
                    SelfExtractUtils.tryToClose(is);
                    break block34;
                }
                ep.skippedFile();
            }
            continueInstall = !ep.isCanceled();
        }
        if (continueInstall && (osName = System.getProperty("os.name")) != null && osName.toLowerCase(Locale.ENGLISH).indexOf("win") == -1 && (binFiles = new File(outputDir, "bin").listFiles()) != null) {
            ArrayList scripts = new ArrayList();
            this.collectScripts(binFiles, scripts);
            Exception e = SelfExtractUtils.makeExecutable(scripts, ep);
            if (e != null) {
                return new ReturnCode(4, "chmodError", e.getMessage());
            }
        }
        if (this.productAddOn) {
            SelfExtractor.printNeededIFixes(outputDir, extractedFiles);
        }
        if (!continueInstall) {
            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static File determineTargetUserDirectory(File wlpInstallDir) {
        File defaultUserDir;
        block8: {
            block6: {
                defaultUserDir = new File(wlpInstallDir, "usr");
                File serverEnvFile = new File(wlpInstallDir, "etc/server.env");
                if (!serverEnvFile.exists()) break block6;
                Properties serverEnvProps = new Properties();
                FileInputStream serverEnvStream = null;
                try {
                    serverEnvStream = new FileInputStream(serverEnvFile);
                    serverEnvProps.load(serverEnvStream);
                }
                catch (Exception e) {
                    SelfExtractUtils.tryToClose(serverEnvStream);
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(serverEnvStream);
                        throw throwable;
                    }
                }
                SelfExtractUtils.tryToClose(serverEnvStream);
                String customUserDir = serverEnvProps.getProperty("WLP_USER_DIR");
                if (customUserDir != null && !"".equals(customUserDir)) {
                    return new File(customUserDir);
                }
                break block8;
            }
            String envVarUserDir = System.getenv("WLP_USER_DIR");
            if (envVarUserDir != null && !"".equals(envVarUserDir)) {
                return new File(envVarUserDir);
            }
        }
        return defaultUserDir;
    }

    public boolean isUserSample() {
        return this.archiveContentType != null && this.archiveContentType.equalsIgnoreCase("sample");
    }

    public boolean isProductAddon() {
        return this.productAddOn;
    }

    public String getArchiveContentType() {
        return this.archiveContentType;
    }

    public String getProvidedFeatures() {
        return this.providedFeatures;
    }

    public boolean hasExternalDepsFile() {
        return this.jarFile.getEntry(EXTERNAL_DEPS_FILE) != null;
    }

    public void setDoExternalDepsDownload(boolean value) {
        this.doExternalDepsDownload = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExternalDependencies() throws Exception {
        ZipEntry depsEntry = null;
        ExternalDependencies newDeps = new ExternalDependencies();
        depsEntry = this.jarFile.getEntry(EXTERNAL_DEPS_FILE);
        if (depsEntry != null) {
            InputStream entryInputStream = null;
            try {
                entryInputStream = this.jarFile.getInputStream(depsEntry);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(entryInputStream);
                Element rootEle = doc.getDocumentElement();
                newDeps.setDescription(rootEle.getAttribute("description"));
                NodeList dependencies = rootEle.getElementsByTagName("dependency");
                for (int i = 0; i < dependencies.getLength(); ++i) {
                    Node node = dependencies.item(i);
                    Element ele = (Element)node;
                    URL sourceUrl = new URL(ele.getAttribute("url"));
                    String targetPath = ele.getAttribute("targetpath");
                    newDeps.add(sourceUrl, targetPath);
                }
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(entryInputStream);
                throw throwable;
            }
            SelfExtractUtils.tryToClose(entryInputStream);
        }
        this.externalDeps = newDeps;
    }

    public ExternalDependencies getExternalDependencies() throws Exception {
        if (this.externalDeps == null) {
            this.buildExternalDependencies();
        }
        return this.externalDeps;
    }

    public static void printNeededIFixes(File outputDir, List extractedFiles) {
        try {
            List iFixesToReapply = IFixUtils.listIFixesThatMustBeReapplied(outputDir, extractedFiles);
            if (!iFixesToReapply.isEmpty()) {
                SelfExtract.out("addOnNeedsIFixes", new Object[]{outputDir.getAbsolutePath(), iFixesToReapply});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void collectScripts(File[] files, List scripts) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File[] childFiles = file.listFiles();
            if (childFiles != null) {
                this.collectScripts(childFiles, scripts);
                continue;
            }
            if (file.getName().indexOf(46) != -1) continue;
            scripts.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set listMissingCoreFeatures(File outputDir) throws SelfExtractorFileException {
        HashSet<String> missingFeatures = new HashSet<String>();
        boolean is850x = false;
        FileInputStream propertyStream = null;
        try {
            File wlpPropertyFile = new File(outputDir, "lib/versions/WebSphereApplicationServer.properties");
            Properties wlpProperties = new Properties();
            propertyStream = new FileInputStream(wlpPropertyFile);
            wlpProperties.load(propertyStream);
            String version = (String)wlpProperties.get("com.ibm.websphere.productVersion");
            is850x = version != null && version.startsWith("8.5.0");
        }
        catch (IOException e) {
            SelfExtractUtils.tryToClose(propertyStream);
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(propertyStream);
                throw throwable;
            }
        }
        SelfExtractUtils.tryToClose(propertyStream);
        if (this.requiredFeatures == null || "".equals(this.requiredFeatures)) return missingFeatures;
        StringTokenizer tokenizer = new StringTokenizer(this.requiredFeatures, ",");
        while (tokenizer.hasMoreElements()) {
            missingFeatures.add(tokenizer.nextToken().trim().toLowerCase());
        }
        FilenameFilter manifestFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                boolean result = false;
                if (name.endsWith(".mf")) {
                    result = true;
                }
                return result;
            }
        };
        File featuresDir = new File(outputDir + "/lib/features");
        File[] manifestFiles = featuresDir.listFiles(manifestFilter);
        if (manifestFiles == null) return missingFeatures;
        for (int i = 0; i < manifestFiles.length && !missingFeatures.isEmpty(); ++i) {
            FileInputStream fis = null;
            File currentManifestFile = null;
            String manifestSymbolicName = null;
            try {
                currentManifestFile = manifestFiles[i];
                fis = new FileInputStream(currentManifestFile);
                try {
                    Manifest currentManifest = new Manifest(fis);
                    Attributes attrs = currentManifest.getMainAttributes();
                    manifestSymbolicName = attrs.getValue(SUBSYSTEM_SYMBOLIC_NAME);
                }
                catch (IOException ioe) {
                    SelfExtractUtils.tryToClose(fis);
                    BufferedReader reader = null;
                    fis = new FileInputStream(currentManifestFile);
                    try {
                        reader = new BufferedReader(new InputStreamReader(fis));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (!line.startsWith(SUBSYSTEM_SYMBOLIC_NAME)) continue;
                            StringBuilder symbolicNameBuilder = new StringBuilder(line.split(":")[1].trim());
                            while ((line = reader.readLine()) != null && line.startsWith(" ")) {
                                symbolicNameBuilder.append(line.trim());
                            }
                            manifestSymbolicName = symbolicNameBuilder.toString();
                        }
                    }
                    catch (IOException e) {
                        try {
                            throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), e);
                        }
                        catch (Throwable throwable) {
                            SelfExtractUtils.tryToClose(reader);
                            throw throwable;
                        }
                    }
                    SelfExtractUtils.tryToClose(reader);
                    if (manifestSymbolicName == null || manifestSymbolicName.length() == 0) {
                        throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), ioe);
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                try {
                    throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), fnfe);
                }
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(fis);
                    throw throwable;
                }
            }
            SelfExtractUtils.tryToClose(fis);
            if (manifestSymbolicName.contains(";")) {
                manifestSymbolicName = manifestSymbolicName.substring(0, manifestSymbolicName.indexOf(";"));
            }
            manifestSymbolicName = manifestSymbolicName.toLowerCase();
            if (is850x) {
                missingFeatures.remove("com.ibm.websphere.appserver." + manifestSymbolicName);
                continue;
            }
            missingFeatures.remove(manifestSymbolicName);
        }
        return missingFeatures;
    }

    private static final class SelfExtractorFileException
    extends Exception {
        private final String fileName;

        public SelfExtractorFileException(String fileName, Throwable exception) {
            super(exception);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public static class ExternalDependency {
        private final URL sourceUrl;
        private final String targetPath;

        public ExternalDependency(URL sourceUrl, String targetPath) {
            this.sourceUrl = sourceUrl;
            this.targetPath = targetPath;
        }

        public URL getSourceUrl() {
            return this.sourceUrl;
        }

        public String getTargetPath() {
            return this.targetPath;
        }
    }

    public static class ExternalDependencies {
        private String description = "";
        private final List dependencies = new ArrayList();
        private int size = -1;

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void add(URL sourceUrl, String targetPath) {
            this.dependencies.add(new ExternalDependency(sourceUrl, targetPath));
        }

        public List getDependencies() {
            return this.dependencies;
        }

        public int getSize() {
            if (this.size < 0) {
                int total = 0;
                for (int i = 0; i < this.dependencies.size(); ++i) {
                    URL thisDepURL = ((ExternalDependency)this.dependencies.get(i)).getSourceUrl();
                    int thisDepSize = SelfExtractUtils.tryGetContentLengthOfURL(thisDepURL);
                    if (thisDepSize == -1) continue;
                    total += thisDepSize;
                }
                this.size = total;
            }
            return this.size;
        }
    }

    private static class NullExtractProgress
    implements ExtractProgress {
        private NullExtractProgress() {
        }

        public void extractedFile(String f) {
        }

        public void downloadingFile(URL sourceUrl, File targetFile) {
        }

        public void dataDownloaded(int numBytes) {
        }

        public void setFilesToExtract(int count) {
        }

        public void commandRun(List args) {
        }

        public void commandsToRun(int count) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void skippedFile() {
        }
    }
}

