/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wiremock.org.xmlunit.util.Linqy;

public final class IterableNodeList
implements Iterable<Node> {
    private final NodeList nl;
    private final int length;

    public IterableNodeList(NodeList nl) {
        this.nl = nl;
        this.length = nl.getLength();
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeListIterator();
    }

    public static List<Node> asList(NodeList l) {
        return Linqy.asList(new IterableNodeList(l));
    }

    private class NodeListIterator
    implements Iterator<Node> {
        private int current = 0;

        private NodeListIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return IterableNodeList.this.nl.item(this.current++);
        }

        @Override
        public boolean hasNext() {
            return this.current < IterableNodeList.this.length;
        }
    }
}

