/*******************************************************************************
 * Copyright (c) 2015 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.wsspi.persistence.internal.eclipselink.sql.delegate;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

import com.ibm.websphere.ras.annotation.Trivial;

/**
 * An abstract PreparedStatement implementation that allows for easier extension.
 */
@Trivial
public abstract class DelegatingPreparedStatement implements PreparedStatement {
     protected final PreparedStatement _ps;

     public DelegatingPreparedStatement(PreparedStatement ps) {
          _ps = ps;
     }

     public void addBatch() throws SQLException {
          _ps.addBatch();
     }

     public void addBatch(String sql) throws SQLException {
          _ps.addBatch(sql);
     }

     public void cancel() throws SQLException {
          _ps.cancel();
     }

     public void clearBatch() throws SQLException {
          _ps.clearBatch();
     }

     public void clearParameters() throws SQLException {
          _ps.clearParameters();
     }

     public void clearWarnings() throws SQLException {
          _ps.clearWarnings();
     }

     public void close() throws SQLException {
          _ps.close();
     }

     public void closeOnCompletion() throws SQLException {
     }

     public boolean execute() throws SQLException {
          return _ps.execute();
     }

     public boolean execute(String sql) throws SQLException {
          return _ps.execute(sql);
     }

     public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
          return _ps.execute(sql, autoGeneratedKeys);
     }

     public boolean execute(String sql, int[] columnIndexes) throws SQLException {
          return _ps.execute(sql, columnIndexes);
     }

     public boolean execute(String sql, String[] columnNames) throws SQLException {
          return _ps.execute(sql, columnNames);
     }

     public int[] executeBatch() throws SQLException {
          return _ps.executeBatch();
     }

     public ResultSet executeQuery() throws SQLException {
          return _ps.executeQuery();
     }

     public ResultSet executeQuery(String sql) throws SQLException {
          return _ps.executeQuery(sql);
     }

     public int executeUpdate() throws SQLException {
          return _ps.executeUpdate();
     }

     public int executeUpdate(String sql) throws SQLException {
          return _ps.executeUpdate(sql);
     }

     public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
          return _ps.executeUpdate(sql, autoGeneratedKeys);
     }

     public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
          return _ps.executeUpdate(sql, columnIndexes);
     }

     public int executeUpdate(String sql, String[] columnNames) throws SQLException {
          return _ps.executeUpdate(sql, columnNames);
     }

     public Connection getConnection() throws SQLException {
          return _ps.getConnection();
     }

     public int getFetchDirection() throws SQLException {
          return _ps.getFetchDirection();
     }

     public int getFetchSize() throws SQLException {
          return _ps.getFetchSize();
     }

     public ResultSet getGeneratedKeys() throws SQLException {
          return _ps.getGeneratedKeys();
     }

     public int getMaxFieldSize() throws SQLException {
          return _ps.getMaxFieldSize();
     }

     public int getMaxRows() throws SQLException {
          return _ps.getMaxRows();
     }

     public ResultSetMetaData getMetaData() throws SQLException {
          return _ps.getMetaData();
     }

     public boolean getMoreResults() throws SQLException {
          return _ps.getMoreResults();
     }

     public boolean getMoreResults(int current) throws SQLException {
          return _ps.getMoreResults(current);
     }

     public ParameterMetaData getParameterMetaData() throws SQLException {
          return _ps.getParameterMetaData();
     }

     public int getQueryTimeout() throws SQLException {
          return _ps.getQueryTimeout();
     }

     public ResultSet getResultSet() throws SQLException {
          return _ps.getResultSet();
     }

     public int getResultSetConcurrency() throws SQLException {
          return _ps.getResultSetConcurrency();
     }

     public int getResultSetHoldability() throws SQLException {
          return _ps.getResultSetHoldability();
     }

     public int getResultSetType() throws SQLException {
          return _ps.getResultSetType();
     }

     public int getUpdateCount() throws SQLException {
          return _ps.getUpdateCount();
     }

     public SQLWarning getWarnings() throws SQLException {
          return _ps.getWarnings();
     }

     public boolean isClosed() throws SQLException {
          return _ps.isClosed();
     }

     public boolean isCloseOnCompletion() throws SQLException {
          return false;
     }

     public boolean isPoolable() throws SQLException {
          return _ps.isPoolable();
     }

     public boolean isWrapperFor(Class<?> iface) throws SQLException {
          return _ps.isWrapperFor(iface);
     }

     public void setArray(int parameterIndex, Array theArray) throws SQLException {
          _ps.setArray(parameterIndex, theArray);
     }

     public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
          _ps.setAsciiStream(parameterIndex, x);
     }

     public void setAsciiStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
          _ps.setAsciiStream(parameterIndex, theInputStream, length);
     }

     public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
          _ps.setAsciiStream(parameterIndex, x, length);
     }

     public void setBigDecimal(int parameterIndex, BigDecimal theBigDecimal) throws SQLException {
          _ps.setBigDecimal(parameterIndex, theBigDecimal);
     }

     public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
          _ps.setBinaryStream(parameterIndex, x);
     }

     public void setBinaryStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
          _ps.setBinaryStream(parameterIndex, theInputStream, length);
     }

     public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
          _ps.setBinaryStream(parameterIndex, x, length);
     }

     public void setBlob(int parameterIndex, Blob theBlob) throws SQLException {
          _ps.setBlob(parameterIndex, theBlob);
     }

     public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
          _ps.setBlob(parameterIndex, inputStream);
     }

     public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
          _ps.setBlob(parameterIndex, inputStream, length);
     }

     public void setBoolean(int parameterIndex, boolean theBoolean) throws SQLException {
          _ps.setBoolean(parameterIndex, theBoolean);
     }

     public void setByte(int parameterIndex, byte theByte) throws SQLException {
          _ps.setByte(parameterIndex, theByte);
     }

     public void setBytes(int parameterIndex, byte[] theBytes) throws SQLException {
          _ps.setBytes(parameterIndex, theBytes);
     }

     public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
          _ps.setCharacterStream(parameterIndex, reader);
     }

     public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
          _ps.setCharacterStream(parameterIndex, reader, length);
     }

     public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
          _ps.setCharacterStream(parameterIndex, reader, length);
     }

     public void setClob(int parameterIndex, Clob theClob) throws SQLException {
          _ps.setClob(parameterIndex, theClob);
     }

     public void setClob(int parameterIndex, Reader reader) throws SQLException {
          _ps.setClob(parameterIndex, reader);
     }

     public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
          _ps.setClob(parameterIndex, reader, length);
     }

     public void setCursorName(String name) throws SQLException {
          _ps.setCursorName(name);
     }

     public void setDate(int parameterIndex, Date theDate) throws SQLException {
          _ps.setDate(parameterIndex, theDate);
     }

     public void setDate(int parameterIndex, Date theDate, Calendar cal) throws SQLException {
          _ps.setDate(parameterIndex, theDate, cal);
     }

     public void setDouble(int parameterIndex, double theDouble) throws SQLException {
          _ps.setDouble(parameterIndex, theDouble);
     }

     public void setEscapeProcessing(boolean enable) throws SQLException {
          _ps.setEscapeProcessing(enable);
     }

     public void setFetchDirection(int direction) throws SQLException {
          _ps.setFetchDirection(direction);
     }

     public void setFetchSize(int rows) throws SQLException {
          _ps.setFetchSize(rows);
     }

     public void setFloat(int parameterIndex, float theFloat) throws SQLException {
          _ps.setFloat(parameterIndex, theFloat);
     }

     public void setInt(int parameterIndex, int theInt) throws SQLException {
          _ps.setInt(parameterIndex, theInt);
     }

     public void setLong(int parameterIndex, long theLong) throws SQLException {
          _ps.setLong(parameterIndex, theLong);
     }

     public void setMaxFieldSize(int max) throws SQLException {
          _ps.setMaxFieldSize(max);
     }

     public void setMaxRows(int max) throws SQLException {
          _ps.setMaxRows(max);
     }

     public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
          _ps.setNCharacterStream(parameterIndex, value);
     }

     public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
          _ps.setNCharacterStream(parameterIndex, value, length);
     }

     public void setNClob(int parameterIndex, NClob value) throws SQLException {
          _ps.setNClob(parameterIndex, value);
     }

     public void setNClob(int parameterIndex, Reader reader) throws SQLException {
          _ps.setNClob(parameterIndex, reader);
     }

     public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
          _ps.setNClob(parameterIndex, reader, length);
     }

     public void setNString(int parameterIndex, String value) throws SQLException {
          _ps.setNString(parameterIndex, value);
     }

     public void setNull(int parameterIndex, int sqlType) throws SQLException {
          _ps.setNull(parameterIndex, sqlType);
     }

     public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
          _ps.setNull(paramIndex, sqlType, typeName);
     }

     public void setObject(int parameterIndex, Object theObject) throws SQLException {
          _ps.setObject(parameterIndex, theObject);
     }

     public void setObject(int parameterIndex, Object theObject, int targetSqlType) throws SQLException {
          _ps.setObject(parameterIndex, theObject, targetSqlType);
     }

     public void setObject(int parameterIndex, Object theObject, int targetSqlType, int scale) throws SQLException {
          _ps.setObject(parameterIndex, theObject, targetSqlType, scale);
     }

     public void setPoolable(boolean poolable) throws SQLException {
          _ps.setPoolable(poolable);
     }

     public void setQueryTimeout(int seconds) throws SQLException {
          _ps.setQueryTimeout(seconds);
     }

     public void setRef(int parameterIndex, Ref theRef) throws SQLException {
          _ps.setRef(parameterIndex, theRef);
     }

     public void setRowId(int parameterIndex, RowId x) throws SQLException {
          _ps.setRowId(parameterIndex, x);
     }

     public void setShort(int parameterIndex, short theShort) throws SQLException {
          _ps.setShort(parameterIndex, theShort);
     }

     public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
          _ps.setSQLXML(parameterIndex, xmlObject);
     }

     public void setString(int parameterIndex, String theString) throws SQLException {
          _ps.setString(parameterIndex, theString);
     }

     public void setTime(int parameterIndex, Time theTime) throws SQLException {
          _ps.setTime(parameterIndex, theTime);
     }

     public void setTime(int parameterIndex, Time theTime, Calendar cal) throws SQLException {
          _ps.setTime(parameterIndex, theTime, cal);
     }

     public void setTimestamp(int parameterIndex, Timestamp theTimestamp) throws SQLException {
          _ps.setTimestamp(parameterIndex, theTimestamp);
     }

     public void setTimestamp(int parameterIndex, Timestamp theTimestamp, Calendar cal) throws SQLException {
          _ps.setTimestamp(parameterIndex, theTimestamp, cal);
     }

     public void setUnicodeStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
          _ps.setUnicodeStream(parameterIndex, theInputStream, length);
     }

     public void setURL(int parameterIndex, URL theURL) throws SQLException {
          _ps.setURL(parameterIndex, theURL);
     }

     public <T> T unwrap(Class<T> iface) throws SQLException {
          return _ps.unwrap(iface);
     }

}
