/*******************************************************************************
 * Copyright (c) 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.ws.jpa.fvt.callback.tests.ejb;

import java.util.HashMap;

import javax.annotation.PostConstruct;
import javax.servlet.annotation.WebServlet;

import org.junit.Test;

import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.ano.CallbackPackageEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.ano.CallbackPrivateEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.ano.CallbackProtectedEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.ano.CallbackPublicEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.ano.CallbackPackageMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.ano.CallbackPrivateMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.ano.CallbackProtectedMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.ano.CallbackPublicMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.xml.XMLCallbackPackageMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.xml.XMLCallbackPrivateMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.xml.XMLCallbackProtectedMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.mappedsuperclass.xml.XMLCallbackPublicMSCEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.xml.XMLCallbackPackageEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.xml.XMLCallbackPrivateEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.xml.XMLCallbackProtectedEntity;
import com.ibm.ws.jpa.fvt.callback.entities.entitydeclared.xml.XMLCallbackPublicEntity;
import com.ibm.ws.jpa.fvt.callback.testlogic.CallbackRuntimeExceptionTestLogic;
import com.ibm.ws.testtooling.testinfo.JPAPersistenceContext;
import com.ibm.ws.testtooling.testinfo.JPAPersistenceContext.PersistenceContextType;
import com.ibm.ws.testtooling.testinfo.JPAPersistenceContext.PersistenceInjectionType;
import com.ibm.ws.testtooling.vehicle.web.EJBTestVehicleServlet;

import componenttest.annotation.ExpectedFFDC;

@SuppressWarnings("serial")
@WebServlet(urlPatterns = "/TestCallbackException_EJB_SFEX_Servlet")
public class TestCallbackException_EJB_SFEX_Servlet extends EJBTestVehicleServlet {

    @PostConstruct
    private void initFAT() {
        testClassName = CallbackRuntimeExceptionTestLogic.class.getName();
        ejbJNDIName = "ejb/CallbackSFExEJB";

        jpaPctxMap.put("test-jpa-resource-cmex",
                       new JPAPersistenceContext("test-jpa-resource-cmex", PersistenceContextType.CONTAINER_MANAGED_ES, PersistenceInjectionType.JNDI, "java:comp/env/jpa/Callback_CMEX"));
    }

    /*
     * Test Callback Function when a RuntimeException is thrown by the callback method.
     * Verify when appropriate that the transaction is still active and is marked for rollback.
     *
     * Combination Patterns:
     * Callback Method Protection Type: Package, Private, Protected, Public
     * Entity Declaration: Annotation, XML-ORM
     * Persistence Context Type: AM-JTA, AM-RL, CM-TS
     */

    // Package Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_PackageProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_PackageProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackPackageEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_PackageProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_PackageProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackPackageEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    // Private Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_PrivateProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_PrivateProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackPrivateEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_PrivateProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_PrivateProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackPrivateEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    // Protected Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_ProtectedProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_ProtectedProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackProtectedEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_ProtectedProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_ProtectedProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackProtectedEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    // Public Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_PublicProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_PublicProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackPublicEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_PublicProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_PublicProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackPublicEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    /*
     * Test Basic Callback Function. Verify that a callback method on an entity where callback methods are defined
     * on a MappedSuperclass are called when appropriate in an its lifecycle.
     *
     * Combination Patterns:
     * Callback Method Protection Type: Package, Private, Protected, Public
     * Entity Declaration: Annotation, XML-ORM
     * Persistence Context Type: AM-JTA, AM-RL, CM-TS
     */

    // Package Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_PackageProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_PackageProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackPackageMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_PackageProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_PackageProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackPackageMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    // Private Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_PrivateProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_PrivateProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackPrivateMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_PrivateProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_PrivateProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackPrivateMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    // Protected Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_ProtectedProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_ProtectedProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackProtectedMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_ProtectedProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_ProtectedProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackProtectedMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    // Public Protection

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_PublicProtection_001_Ano_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_PublicProtection_001_Ano_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", CallbackPublicMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }

    @Test
    @ExpectedFFDC("javax.transaction.RollbackException")
    public void jpa10_Callback_RuntimeException_EntityDeclared_MSC_PublicProtection_001_XML_CMEX_EJB_SF() throws Exception {
        final String testName = "jpa10_Callback_RuntimeException_EntityDeclared_MSC_PublicProtection_001_XML_CMEX_EJB_SF";
        final String testMethod = "testCallbackRuntimeException001";
        final String testResource = "test-jpa-resource-cmex";

        HashMap<String, java.io.Serializable> properties = new HashMap<String, java.io.Serializable>();
        properties.put("EntityName", XMLCallbackPublicMSCEntity.class.getSimpleName());

        executeDDL("JPA10_CALLBACK_DELETE_${dbvendor}.ddl");
        executeTest(testName, testMethod, testResource, properties);
    }
}
