/*******************************************************************************
 * Copyright (c) 2020 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package test.app.prereq;

import static org.osgi.service.component.annotations.ConfigurationPolicy.REQUIRE;

import java.util.Map;
import java.util.Optional;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

import com.ibm.wsspi.application.lifecycle.ApplicationPrereq;

/**
 * Obviously, a widget can't work without a WidgetEnabler.
 */

@Component(configurationPolicy = REQUIRE, immediate = true)
public class Widget implements ApplicationPrereq {
    final String prereqId;

    @Activate
    public Widget(Map<String, Object> props, @Reference WidgetEnabler enabler) {
        this.prereqId = Optional.of(props).map(p -> (String) p.get("application.prereq.id")).orElseThrow(() -> new Error("application prereq id property not found on Widget"));
        System.out.println("### created Widget[" + prereqId + "]");
    }

    @Deactivate
    public void deactivate() {
        System.out.println("### deactivated Widget[" + prereqId + "]");
    }
}