/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.websphere.channelfw;

import java.io.Serializable;
import java.util.Map;

/**
 * This class represents the data associated with a channel factory.
 * <p>
 * Each Channel has a ChannelFactory associated with it. This ChannelFactory contains
 * important information for ensuring the coherency of the Chain (protocol stack) as well
 * as storing configuration data for resources that may be scoped to a ChannelFactory
 * level.
 * 
 * @ibm-api
 */
public interface ChannelFactoryData extends Serializable {
    /**
     * Returns the interface into this channel. Return the interface class that this channel
     * presents to adjacent channels on its application side.
     * 
     * @return Class<?>
     */
    Class<?> getApplicationInterface();

    /**
     * Return the list of device interface classes supported. These
     * interfaces represent the type of objects that can be passed from
     * an adjacent channel to this channel on its device side.
     * 
     * @return Class<?>[]
     */
    Class<?>[] getDeviceInterface();

    /**
     * Get the common properties that are to be shared by all channel instances
     * generated by this factory.
     * 
     * @return Map<Object,Object> common properties
     */
    Map<Object, Object> getProperties();

    /**
     * Returns the class of the ChannelFactory associated with this data
     * 
     * @return Class<?>
     */
    Class<?> getFactory();

}
