/*******************************************************************************
 * Copyright (c) 2007, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.ejbcontainer.jitdeploy;

/**
 * <code>EJBWrapperType</code> defines the various EJB Wrapper types
 * supported by JITDeploy. This is a required parameter on {@link JITDeploy#generateEJBWrapper generateEJBWrapper}. <p>
 * 
 * <code>EJBWrapperType</code> is a java enumeration type used for compile
 * time checking of valid values. The values are the objects themselves, and
 * there is a single instance for each value, so == checking should be performed
 * rather than equals() comparisons. <p>
 * 
 * <DL>
 * <DT>The supported EJB Wrapper types are:
 * <DD>{@link #REMOTE} <DD>{@link #REMOTE_HOME} <DD>{@link #LOCAL} <DD>{@link #LOCAL_HOME} <DD>{@link #SERVICE_ENDPOINT} <DD>{@link #BUSINESS_LOCAL} <DD>{@link #BUSINESS_REMOTE}
 * <DD>{@link #LOCAL_BEAN} <DD>{@link #MANAGED_BEAN} </DL> <p>
 * 
 * <code>EJBWrapperType</code> is similar to {@link com.ibm.websphere.csi.MethodInterface} and {@link com.ibm.ejs.container.WrapperInterface},
 * but only contains those wrapper types that are generated by
 * JITDeploy. Also, this enumeration does not distinguish between
 * Business Remote wrappers that implement java.rmi.Remote and those
 * that do not. <p>
 * 
 * @see com.ibm.ejs.container.WrapperInterface
 * @see com.ibm.websphere.csi.MethodInterface
 */
public enum EJBWrapperType
{
    REMOTE, // EJB 2.x Remote Component Interface
    REMOTE_HOME, // EJB 2.x Remote Home Interface
    LOCAL, // EJB 2.x Local Component Interface
    LOCAL_HOME, // EJB 2.x Local Home Interface
    SERVICE_ENDPOINT, // WebService Endpoint Interface             LI3294-35
    BUSINESS_LOCAL, // EJB 3.0 Business Local Interface
    BUSINESS_REMOTE, // EJB 3.0 Business Remote Interface
    LOCAL_BEAN, // EJB 3.1 No-Interface View (LocalBean)     F743-1756
    MANAGED_BEAN, // JavaEE 1.6 @ManagedBean                F743-34301.1
    MDB_PROXY, // MDB proxy
    MDB_NO_METHOD_INTERFACE_PROXY, //MDB 3.2 no method interface proxy

}
