/*******************************************************************************
 * Copyright (c) 2007, 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.ejbcontainer.remote.server.shared;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * Remote Home interface for Container Managed Transaction Session beans.
 **/
public interface TxAttrEJBHome extends EJBHome {
    /**
     * Default create method with no parameters.
     * <p>
     *
     * @return TxAttrEJB The StatelessBean EJB object.
     * @exception javax.ejb.CreateException
     *                StatelessBean EJB object was not created.
     *                java.rmi.RemoteException - remote exception occurred.
     */
    public TxAttrEJB create() throws CreateException, RemoteException;
}