/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.manager.ManagerServlet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.http.fileupload.DiskFileUpload;
import org.apache.tomcat.util.http.fileupload.FileItem;

public final class HTMLManagerServlet
extends ManagerServlet {
    private static final String APPS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"5\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-left\"><small>{1}</small></td>\n <td class=\"header-left\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n</tr>\n";
    private static final String APPS_ROW_DETAILS_SECTION = "<tr>\n <td class=\"row-left\" bgcolor=\"{5}\"><small><a href=\"{0}\">{0}</a></small></td>\n <td class=\"row-left\" bgcolor=\"{5}\"><small>{1}</small></td>\n <td class=\"row-center\" bgcolor=\"{5}\"><small>{2}</small></td>\n <td class=\"row-center\" bgcolor=\"{5}\"><small><a href=\"{3}\">{4}</a></small></td>\n";
    private static final String MANAGER_APP_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{8}\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;{7}&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String STARTED_DEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{8}\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;<a href=\"{2}\" onclick=\"return(confirm('''Are you sure?'''))\">{3}</a>&nbsp;\n  &nbsp;<a href=\"{4}\" onclick=\"return(confirm('''Are you sure?'''))\">{5}</a>&nbsp;\n  &nbsp;<a href=\"{6}\" onclick=\"return(confirm('''Are you sure?'''))\">{7}</a>&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String STOPPED_DEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{8}\">\n  <small>\n  &nbsp;<a href=\"{0}\" onclick=\"return(confirm('''Are you sure?'''))\">{1}</a>&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;<a href=\"{6}\" onclick=\"return(confirm('''Are you sure?  This will delete the application.'''))\">{7}</a>&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String STARTED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{8}\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;<a href=\"{2}\" onclick=\"return(confirm('''Are you sure?'''))\">{3}</a>&nbsp;\n  &nbsp;<a href=\"{4}\" onclick=\"return(confirm('''Are you sure?'''))\">{5}</a>&nbsp;\n  &nbsp;{7}&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String STOPPED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{8}\">\n  <small>\n  &nbsp;<a href=\"{0}\" onclick=\"return(confirm('''Are you sure?'''))\">{1}</a>&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;{7}&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String DEPLOY_SECTION = "</table>\n<br>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"get\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployPath\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{4}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployConfig\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{5}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{6}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n";
    private static final String UPLOAD_SECTION = "<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{0}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form action=\"{1}\" method=\"post\" enctype=\"multipart/form-data\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{2}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"file\" name=\"deployWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{3}\">\n </td>\n</tr>\n</table>\n</form>\n</table>\n<br>\n\n";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        String path = request.getParameter("path");
        String deployPath = request.getParameter("deployPath");
        String deployConfig = request.getParameter("deployConfig");
        String deployWar = request.getParameter("deployWar");
        response.setContentType("text/html; charset=utf-8");
        String message = "";
        if (command != null && !command.equals("/")) {
            if (command.equals("/deploy")) {
                message = this.deployInternal(deployConfig, deployPath, deployWar);
            } else if (!command.equals("/list")) {
                message = command.equals("/reload") ? this.reload(path) : (command.equals("/undeploy") ? this.undeploy(path) : (command.equals("/sessions") ? this.sessions(path) : (command.equals("/start") ? this.start(path) : (command.equals("/stop") ? this.stop(path) : sm.getString("managerServlet.unknownCommand", command)))));
            }
        }
        this.list(request, response, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String message;
        block17: {
            String command = request.getPathInfo();
            if (command == null || !command.equals("/upload")) {
                this.doGet(request, response);
                return;
            }
            response.setContentType("text/html; charset=utf-8");
            message = "";
            DiskFileUpload upload = new DiskFileUpload();
            File tempdir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
            upload.setSizeMax(-1L);
            upload.setRepositoryPath(tempdir.getCanonicalPath());
            String basename = null;
            String war = null;
            FileItem warUpload = null;
            try {
                List items = upload.parseRequest(request);
                for (FileItem item : items) {
                    if (item.isFormField()) continue;
                    if (item.getFieldName().equals("deployWar") && warUpload == null) {
                        warUpload = item;
                        continue;
                    }
                    item.delete();
                }
                if (warUpload == null) {
                    message = sm.getString("htmlManagerServlet.deployUploadNoFile");
                    break block17;
                }
                war = warUpload.getName();
                if (!war.toLowerCase().endsWith(".war")) {
                    message = sm.getString("htmlManagerServlet.deployUploadNotWar", war);
                    break block17;
                }
                if (war.lastIndexOf(92) >= 0) {
                    war = war.substring(war.lastIndexOf(92) + 1);
                }
                if (war.lastIndexOf(47) >= 0) {
                    war = war.substring(war.lastIndexOf(47) + 1);
                }
                basename = war.substring(0, war.toLowerCase().indexOf(".war"));
                File file = new File(this.getAppBase(), war);
                if (file.exists()) {
                    message = sm.getString("htmlManagerServlet.deployUploadWarExists", war);
                    break block17;
                }
                String path = null;
                path = basename.equals("ROOT") ? "" : "/" + basename.replace('#', '/');
                if (this.isServiced(path)) break block17;
                this.addServiced(path);
                try {
                    warUpload.write(file);
                    this.check(path);
                }
                finally {
                    this.removeServiced(path);
                }
            }
            catch (Exception e) {
                message = sm.getString("htmlManagerServlet.deployUploadFail", e.getMessage());
                this.log(message, e);
            }
            finally {
                if (warUpload != null) {
                    warUpload.delete();
                }
                warUpload = null;
            }
        }
        this.list(request, response, message);
    }

    protected String deployInternal(String config, String path, String war) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.deploy(printWriter, config, path, war, false);
        return stringWriter.toString();
    }

    public void list(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        PrintWriter writer = response.getWriter();
        writer.print("<html>\n<head>\n<style>\nH1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}  table {\n    width: 100%;\n  }\n  td.page-title {\n    text-align: center;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: white;\n    color: black;\n  }\n  td.title {\n    text-align: left;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-style:italic;\n    font-weight: bold;\n    background: #D2A41C;\n  }\n  td.header-left {\n    text-align: left;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  td.header-center {\n    text-align: center;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  td.row-left {\n    text-align: left;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n  }\n  td.row-center {\n    text-align: center;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n  }\n  td.row-right {\n    text-align: right;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n  }\n  TH {\n    text-align: center;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  TD {\n    text-align: center;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n  }\n</style>\n");
        Object[] args = new Object[]{request.getContextPath(), sm.getString("htmlManagerServlet.title")};
        writer.print(MessageFormat.format("<title>{0}</title>\n</head>\n\n<body bgcolor=\"#FFFFFF\">\n\n<table cellspacing=\"4\" width=\"100%\" border=\"0\">\n <tr>\n  <td colspan=\"2\">\n   <a href=\"http://www.apache.org/\">\n    <img border=\"0\" alt=\"The Apache Software Foundation\" align=\"left\"\n         src=\"{0}/images/asf-logo.gif\">\n   </a>\n   <a href=\"http://tomcat.apache.org/\">\n    <img border=\"0\" alt=\"The Tomcat Servlet/JSP Container\"\n         align=\"right\" src=\"{0}/images/tomcat.gif\">\n   </a>\n  </td>\n </tr>\n</table>\n<hr size=\"1\" noshade=\"noshade\">\n<table cellspacing=\"4\" width=\"100%\" border=\"0\">\n <tr>\n  <td class=\"page-title\" bordercolor=\"#000000\" align=\"left\" nowrap>\n   <font size=\"+2\">{1}</font>\n  </td>\n </tr>\n</table>\n<br>\n\n", args));
        args = new Object[3];
        args[0] = sm.getString("htmlManagerServlet.messageLabel");
        args[1] = message == null || message.length() == 0 ? "OK" : RequestUtil.filter(message);
        writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n <tr>\n  <td class=\"row-left\" width=\"10%\"><small><strong>{0}</strong></small>&nbsp;</td>\n  <td class=\"row-left\"><pre>{1}</pre></td>\n </tr>\n</table>\n<br>\n\n", args));
        args = new Object[]{sm.getString("htmlManagerServlet.manager"), response.encodeURL(request.getContextPath() + "/html/list"), sm.getString("htmlManagerServlet.list"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlManagerServlet.helpHtmlManagerFile")), sm.getString("htmlManagerServlet.helpHtmlManager"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlManagerServlet.helpManagerFile")), sm.getString("htmlManagerServlet.helpManager"), response.encodeURL(request.getContextPath() + "/status"), sm.getString("statusServlet.title")};
        writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"4\" class=\"title\">{0}</td>\n</tr>\n <tr>\n  <td class=\"row-left\"><a href=\"{1}\">{2}</a></td>\n  <td class=\"row-center\"><a href=\"{3}\">{4}</a></td>\n  <td class=\"row-center\"><a href=\"{5}\">{6}</a></td>\n  <td class=\"row-right\"><a href=\"{7}\">{8}</a></td>\n </tr>\n</table>\n<br>\n\n", args));
        args = new Object[]{sm.getString("htmlManagerServlet.appsTitle"), sm.getString("htmlManagerServlet.appsPath"), sm.getString("htmlManagerServlet.appsName"), sm.getString("htmlManagerServlet.appsAvailable"), sm.getString("htmlManagerServlet.appsSessions"), sm.getString("htmlManagerServlet.appsTasks")};
        writer.print(MessageFormat.format(APPS_HEADER_SECTION, args));
        Container[] children = this.host.findChildren();
        String[] contextPaths = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            contextPaths[i] = children[i].getName();
        }
        TreeMap<String, String> sortedContextPathsMap = new TreeMap<String, String>();
        for (int i = 0; i < contextPaths.length; ++i) {
            String displayPath = contextPaths[i];
            sortedContextPathsMap.put(displayPath, contextPaths[i]);
        }
        String appsStart = sm.getString("htmlManagerServlet.appsStart");
        String appsStop = sm.getString("htmlManagerServlet.appsStop");
        String appsReload = sm.getString("htmlManagerServlet.appsReload");
        String appsUndeploy = sm.getString("htmlManagerServlet.appsUndeploy");
        Iterator iterator = sortedContextPathsMap.entrySet().iterator();
        boolean isHighlighted = true;
        boolean isDeployed = true;
        String highlightColor = null;
        while (iterator.hasNext()) {
            isHighlighted = !isHighlighted;
            highlightColor = isHighlighted ? "#C3F3C3" : "#FFFFFF";
            Map.Entry entry = iterator.next();
            String displayPath = (String)entry.getKey();
            String contextPath = (String)entry.getKey();
            Context context = (Context)this.host.findChild(contextPath);
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context == null) continue;
            try {
                isDeployed = this.isDeployed(contextPath);
            }
            catch (Exception e) {
                isDeployed = false;
            }
            args = new Object[6];
            args[0] = displayPath;
            args[1] = context.getDisplayName();
            if (args[1] == null) {
                args[1] = "&nbsp;";
            }
            args[2] = new Boolean(context.getAvailable());
            args[3] = response.encodeURL(request.getContextPath() + "/html/sessions?path=" + displayPath);
            args[4] = context.getManager() != null ? new Integer(context.getManager().getActiveSessions()) : new Integer(0);
            args[5] = highlightColor;
            writer.print(MessageFormat.format(APPS_ROW_DETAILS_SECTION, args));
            args = new Object[]{response.encodeURL(request.getContextPath() + "/html/start?path=" + displayPath), appsStart, response.encodeURL(request.getContextPath() + "/html/stop?path=" + displayPath), appsStop, response.encodeURL(request.getContextPath() + "/html/reload?path=" + displayPath), appsReload, response.encodeURL(request.getContextPath() + "/html/undeploy?path=" + displayPath), appsUndeploy, highlightColor};
            if (context.getPath().equals(this.context.getPath())) {
                writer.print(MessageFormat.format(MANAGER_APP_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (context.getAvailable() && isDeployed) {
                writer.print(MessageFormat.format(STARTED_DEPLOYED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (context.getAvailable() && !isDeployed) {
                writer.print(MessageFormat.format(STARTED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (!context.getAvailable() && isDeployed) {
                writer.print(MessageFormat.format(STOPPED_DEPLOYED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            writer.print(MessageFormat.format(STOPPED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION, args));
        }
        args = new Object[]{sm.getString("htmlManagerServlet.deployTitle"), sm.getString("htmlManagerServlet.deployServer"), response.encodeURL(request.getContextPath() + "/html/deploy"), sm.getString("htmlManagerServlet.deployPath"), sm.getString("htmlManagerServlet.deployConfig"), sm.getString("htmlManagerServlet.deployWar"), sm.getString("htmlManagerServlet.deployButton")};
        writer.print(MessageFormat.format(DEPLOY_SECTION, args));
        args = new Object[]{sm.getString("htmlManagerServlet.deployUpload"), response.encodeURL(request.getContextPath() + "/html/upload"), sm.getString("htmlManagerServlet.deployUploadFile"), sm.getString("htmlManagerServlet.deployButton")};
        writer.print(MessageFormat.format(UPLOAD_SECTION, args));
        args = new Object[]{sm.getString("htmlManagerServlet.serverTitle"), sm.getString("htmlManagerServlet.serverVersion"), sm.getString("htmlManagerServlet.serverJVMVersion"), sm.getString("htmlManagerServlet.serverJVMVendor"), sm.getString("htmlManagerServlet.serverOSName"), sm.getString("htmlManagerServlet.serverOSVersion"), sm.getString("htmlManagerServlet.serverOSArch")};
        writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n <td class=\"header-center\"><small>{6}</small></td>\n</tr>\n", args));
        args = new Object[]{ServerInfo.getServerInfo(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        writer.print(MessageFormat.format("<tr>\n <td class=\"row-center\"><small>{0}</small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n <td class=\"row-center\"><small>{2}</small></td>\n <td class=\"row-center\"><small>{3}</small></td>\n <td class=\"row-center\"><small>{4}</small></td>\n <td class=\"row-center\"><small>{5}</small></td>\n</tr>\n</table>\n<br>\n\n", args));
        writer.print("<hr size=\"1\" noshade=\"noshade\">\n<center><font size=\"-1\" color=\"#525D76\">\n <em>Copyright &copy; 1999-2005, Apache Software Foundation</em></font></center>\n\n</body>\n</html>");
        writer.flush();
        writer.close();
    }

    protected String reload(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.reload(printWriter, path);
        return stringWriter.toString();
    }

    protected String undeploy(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.undeploy(printWriter, path);
        return stringWriter.toString();
    }

    public String sessions(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sessions(printWriter, path);
        return stringWriter.toString();
    }

    public String start(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, path);
        return stringWriter.toString();
    }

    protected String stop(String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, path);
        return stringWriter.toString();
    }
}

