/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.util.HibernateStatisticsStopWatch;
import org.rhq.enterprise.server.util.LookupUtil;

public class HibernatePerformanceMonitor {
    private static final Log log = LogFactory.getLog(HibernatePerformanceMonitor.class);
    private ConcurrentMap<Long, HibernateStatisticsStopWatch> watches;
    private static HibernatePerformanceMonitor singleton = new HibernatePerformanceMonitor();
    private AtomicLong idGenerator = new AtomicLong(0L);

    private HibernatePerformanceMonitor() {
        this.watches = new ConcurrentHashMap<Long, HibernateStatisticsStopWatch>();
    }

    public static HibernatePerformanceMonitor get() {
        return singleton;
    }

    public void zeroStats() {
        if (log.isDebugEnabled()) {
            EntityManager entityManager = LookupUtil.getEntityManager();
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            Statistics stats = PersistenceUtility.getStatisticsService((EntityManager)entityManager, (MBeanServer)platformMBeanServer);
            stats.clear();
        }
    }

    public long start() {
        if (log.isDebugEnabled()) {
            EntityManager entityManager = LookupUtil.getEntityManager();
            HibernateStatisticsStopWatch watch = new HibernateStatisticsStopWatch(entityManager);
            long id = this.idGenerator.incrementAndGet();
            this.watches.put(id, watch);
            watch.start();
            return id;
        }
        return 0L;
    }

    public void stop(long id, String logPrefix) {
        if (log.isDebugEnabled()) {
            HibernateStatisticsStopWatch watch = (HibernateStatisticsStopWatch)this.watches.remove(id);
            if (watch == null) {
                return;
            }
            watch.stop();
            String cause = "";
            if (watch.getQueryExecutions() != 0L) {
                if ((double)watch.getConnects() / (double)(watch.getEntityLoads() + watch.getQueryExecutions()) >= 5.0) {
                    cause = "(N+1 issue?) ";
                }
                if ((double)watch.getTransations() / (double)watch.getQueryExecutions() >= 5.0) {
                    cause = "(xaction nesting?) ";
                } else if (watch.getTransations() > 10L) {
                    cause = "(too many xactions?";
                }
            }
            if (watch.getTime() > 3000L) {
                cause = "(slowness?) ";
            }
            String callingContext = " for " + (logPrefix == null ? "(unknown)" : logPrefix);
            log.debug((Object)(watch.toString() + cause + callingContext));
            if (logPrefix.contains("URL")) {
                String[] queries = watch.getStats().getQueries();
                for (int i = 0; i < queries.length; ++i) {
                    String query = queries[i];
                    QueryStatistics queryStats = watch.getStats().getQueryStatistics(query);
                    log.debug((Object)("queryString[" + i + "]=" + queries[i]));
                    log.debug((Object)("queryStats[" + i + "=" + queryStats));
                }
            }
        }
    }
}

