/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;

public class NioBlockingSelector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int write(ByteBuffer buf, NioChannel socket, long writeTimeout) throws IOException {
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        int written = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        if (socket.getBufHandler().getWriteBuffer() != buf) {
            socket.getBufHandler().getWriteBuffer().put(buf);
            buf = socket.getBufHandler().getWriteBuffer();
        }
        try {
            while (!timedout && buf.hasRemaining()) {
                if (keycount > 0) {
                    int cnt = socket.write(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    written += cnt;
                    if (cnt > 0) {
                        time = System.currentTimeMillis();
                        continue;
                    }
                }
                if (key == null) {
                    throw new IOException("Key no longer registered");
                }
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)key.attachment();
                try {
                    if (att.getLatch() == null || att.getLatch().getCount() == 0L) {
                        att.startLatch(1);
                    }
                    if (att.interestOps() == 0) {
                        socket.getPoller().add(socket, 4);
                    }
                    att.getLatch().await(writeTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignore) {
                    Thread.interrupted();
                }
                if (att.getLatch() != null && att.getLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetLatch();
                }
                if (writeTimeout <= 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= writeTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
            Object var13_11 = null;
            if (!timedout) return written;
            if (key == null) return written;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (!timedout || key == null) throw throwable;
            NioBlockingSelector.cancelKey(socket, key);
            throw throwable;
        }
        NioBlockingSelector.cancelKey(socket, key);
        return written;
    }

    private static void cancelKey(NioChannel socket, final SelectionKey key) {
        socket.getPoller().addEvent(new Runnable(){

            public void run() {
                key.cancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int read(ByteBuffer buf, NioChannel socket, long readTimeout) throws IOException {
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        int read = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!timedout && read == 0) {
                if (keycount > 0) {
                    int cnt = socket.read(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    read += cnt;
                    if (cnt > 0) break;
                }
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)key.attachment();
                try {
                    if (att.getLatch() == null || att.getLatch().getCount() == 0L) {
                        att.startLatch(1);
                    }
                    if (att.interestOps() == 0) {
                        socket.getPoller().add(socket, 1);
                    }
                    att.getLatch().await(readTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignore) {
                    Thread.interrupted();
                }
                if (att.getLatch() != null && att.getLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetLatch();
                }
                if (readTimeout <= 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= readTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
            Object var13_11 = null;
            if (!timedout) return read;
            if (key == null) return read;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (!timedout || key == null) throw throwable;
            NioBlockingSelector.cancelKey(socket, key);
            throw throwable;
        }
        NioBlockingSelector.cancelKey(socket, key);
        return read;
    }
}

