/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.security;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.jboss.test.security.PolicyPlugin;
import org.jboss.test.visitor.PropertiesVisitorImpl;
import org.jboss.test.visitor.TypeHierarchyTraversal;
import org.jboss.test.visitor.TypeVisitor;

public class NothingPolicyPlugin
extends PolicyPlugin {
    private HashSet<Permission> classPermissions = new HashSet();
    private static final URL codeSourceLocation;

    public NothingPolicyPlugin(Class clazz) {
        PropertiesVisitorImpl visitor = new PropertiesVisitorImpl();
        TypeHierarchyTraversal.visit((Class)clazz, (TypeVisitor)visitor);
        HashMap typeProperties = visitor.getTypeProperties();
        Iterator iter = typeProperties.values().iterator();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (iter.hasNext()) {
            Properties props = (Properties)iter.next();
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.matches("test.Permission.[0-9]+")) continue;
                String value = props.getProperty(name);
                String[] info = value.split(", ");
                try {
                    Constructor<?> ctor;
                    Object[] args;
                    Class[] sig;
                    Permission p;
                    Class<?> pc = loader.loadClass(info[0]);
                    if (info.length == 1) {
                        p = (Permission)pc.newInstance();
                    } else if (info.length == 2) {
                        sig = new Class[]{String.class};
                        args = new Object[]{info[1]};
                        ctor = pc.getConstructor(sig);
                        p = (Permission)ctor.newInstance(args);
                    } else {
                        sig = new Class[]{String.class, String.class};
                        args = new Object[]{info[1], info[2]};
                        ctor = pc.getConstructor(sig);
                        p = (Permission)ctor.newInstance(args);
                    }
                    this.classPermissions.add(p);
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        URL url = codesource.getLocation();
        if (url != null) {
            if (url.equals(codeSourceLocation)) {
                return this.allPermissions();
            }
            File file = new File(url.toString());
            String name = file.getName();
            if (name.indexOf("tests") != -1 || name.indexOf("test-classes") != -1 || name.indexOf("-test.jar") != -1) {
                PermissionCollection pc = this.noPermissions();
                for (Permission p : this.classPermissions) {
                    pc.add(p);
                }
                return pc;
            }
        }
        return this.allPermissions();
    }

    static {
        CodeSource cs;
        URL temp = null;
        ProtectionDomain pd = NothingPolicyPlugin.class.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            temp = cs.getLocation();
        }
        codeSourceLocation = temp;
    }
}

