/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;

public class MasterServerPluginContainerConfiguration {
    private File pluginDirectory;
    private File dataDirectory;
    private File tmpDirectory;
    private String rootClassLoaderRegex;

    public MasterServerPluginContainerConfiguration(File pluginDirectory, File dataDirectory, File tmpDirectory, String rootClassLoaderRegex) {
        if (pluginDirectory == null) {
            throw new IllegalArgumentException("pluginDirectory == null");
        }
        this.pluginDirectory = pluginDirectory;
        if (dataDirectory == null) {
            throw new IllegalArgumentException("dataDirectory == null");
        }
        this.dataDirectory = dataDirectory;
        if (tmpDirectory == null) {
            tmpDirectory = new File(System.getProperty("java.io.tmpdir", "."));
        }
        this.tmpDirectory = tmpDirectory;
        this.rootClassLoaderRegex = rootClassLoaderRegex;
    }

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public File getTemporaryDirectory() {
        return this.tmpDirectory;
    }

    public String getRootServerPluginClassLoaderRegex() {
        return this.rootClassLoaderRegex;
    }

    public String toString() {
        File pdir = this.getPluginDirectory();
        File tdir = this.getTemporaryDirectory();
        File ddir = this.getDataDirectory();
        String regex = this.getRootServerPluginClassLoaderRegex();
        StringBuilder str = new StringBuilder(MasterServerPluginContainerConfiguration.class + ": ");
        str.append("plugin-dir=[" + (pdir != null ? pdir.getAbsolutePath() : "<null>"));
        str.append("], tmp-dir=[" + (tdir != null ? tdir.getAbsolutePath() : "<null>"));
        str.append("], data-dir=[" + (ddir != null ? ddir.getAbsolutePath() : "<null>"));
        str.append("], root-cl-regex=[" + (regex != null ? regex : "<null>"));
        str.append("]");
        return str.toString();
    }
}

