/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public class WrapperSimpleApp
implements WrapperListener,
Runnable {
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private Method m_mainMethod;
    private String[] m_appArgs;
    private boolean m_mainStarted;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_startComplete;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$WrapperManager;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$WrapperSimpleApp;

    protected WrapperSimpleApp(String[] args) {
        Class<?> mainClass;
        Class wmClass = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperSimpleApp.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        m_outInfo = new WrapperPrintStream(System.out, "WrapperSimpleApp: ");
        m_outError = new WrapperPrintStream(System.out, "WrapperSimpleApp: ");
        m_outDebug = new WrapperPrintStream(System.out, "WrapperSimpleApp Debug: ");
        if (args.length < 1) {
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        try {
            mainClass = Class.forName(args[0]);
        }
        catch (ClassNotFoundException e) {
            m_outError.println("Unable to locate the class " + args[0] + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        catch (LinkageError e) {
            m_outError.println("Unable to locate the class " + args[0] + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        try {
            this.m_mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = WrapperSimpleApp.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException e) {
            m_outError.println("Unable to locate a public static main method in class " + args[0] + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        catch (SecurityException e) {
            m_outError.println("Unable to locate a public static main method in class " + args[0] + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        int modifiers = this.m_mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            m_outError.println("The main method in class " + args[0] + " must be declared public and static.");
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        String[] appArgs = new String[args.length - 1];
        System.arraycopy(args, 1, appArgs, 0, appArgs.length);
        WrapperManager.start(this, appArgs);
    }

    public void run() {
        Throwable t;
        block16: {
            WrapperSimpleApp wrapperSimpleApp = this;
            synchronized (wrapperSimpleApp) {
                this.m_mainStarted = true;
                this.notifyAll();
            }
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("invoking main method");
                }
                this.m_mainMethod.invoke(null, new Object[]{this.m_appArgs});
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("main method completed");
                }
                WrapperSimpleApp wrapperSimpleApp2 = this;
                synchronized (wrapperSimpleApp2) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block16;
                t = e;
            }
        }
        m_outInfo.println();
        m_outError.println("Encountered an error running main:");
        t.printStackTrace(m_outError);
        WrapperSimpleApp wrapperSimpleApp = this;
        synchronized (wrapperSimpleApp) {
            if (this.m_startComplete) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    public Integer start(String[] args) {
        int maxLoops;
        boolean waitForStartMain = WrapperSystemPropertyUtil.getBooleanProperty((class$org$tanukisoftware$wrapper$WrapperSimpleApp == null ? (class$org$tanukisoftware$wrapper$WrapperSimpleApp = WrapperSimpleApp.class$("org.tanukisoftware.wrapper.WrapperSimpleApp")) : class$org$tanukisoftware$wrapper$WrapperSimpleApp).getName() + ".waitForStartMain", false);
        int maxStartMainWait = WrapperSystemPropertyUtil.getIntProperty((class$org$tanukisoftware$wrapper$WrapperSimpleApp == null ? (class$org$tanukisoftware$wrapper$WrapperSimpleApp = WrapperSimpleApp.class$("org.tanukisoftware.wrapper.WrapperSimpleApp")) : class$org$tanukisoftware$wrapper$WrapperSimpleApp).getName() + ".maxStartMainWait", 2);
        maxStartMainWait = Math.max(1, maxStartMainWait);
        if (waitForStartMain) {
            maxLoops = Integer.MAX_VALUE;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) Will wait indefinitely for the main method to complete.");
            }
        } else {
            maxLoops = maxStartMainWait;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) Will wait up to " + maxLoops + " seconds for the main method to complete.");
            }
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperSimpleAppMain");
        WrapperSimpleApp wrapperSimpleApp = this;
        synchronized (wrapperSimpleApp) {
            this.m_appArgs = args;
            mainThread.start();
            while (!this.m_mainStarted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            int loops = 0;
            while (loops < maxLoops && !this.m_mainComplete) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.m_mainComplete) {
                    WrapperManager.signalStarting(5000);
                }
                ++loops;
            }
            this.m_startComplete = true;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) end.  Main Completed=" + this.m_mainComplete + ", exitCode=" + this.m_mainExitCode);
            }
            Integer n = this.m_mainExitCode;
            return n;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println("stop(" + exitCode + ")");
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            m_outInfo.println("User logged out.  Ignored.");
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("controlEvent(" + event + ") Stopping");
            }
            WrapperManager.stop(0);
        }
    }

    protected void showUsage() {
        System.out.println();
        System.out.println("WrapperSimpleApp Usage:");
        System.out.println("  java org.tanukisoftware.wrapper.WrapperSimpleApp {app_class} [app_arguments]");
        System.out.println();
        System.out.println("Where:");
        System.out.println("  app_class:      The fully qualified class name of the application to run.");
        System.out.println("  app_arguments:  The arguments that would normally be passed to the");
        System.out.println("                  application.");
    }

    public static void main(String[] args) {
        new WrapperSimpleApp(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

