/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaSecurityUtils;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaSecurityUtils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaSecurityUtils;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.text.MessageFormat;
import java.util.logging.Level;

public class UpdateMetadataKeyInfo
extends AuthenticatedCommand {
    private static final String NULL_ALIAS = "null";
    private String realm;
    private String entityID;
    private boolean sign;
    private String spSigningAlias;
    private String idpSigningAlias;
    private String attrqSigningAlias;
    private String attraSigningAlias;
    private String authnaSigningAlias;
    private String pepSigningAlias;
    private String pdpSigningAlias;
    private String spEncryptionAlias;
    private String idpEncryptionAlias;
    private String attrqEncryptionAlias;
    private String attraEncryptionAlias;
    private String authnaEncryptionAlias;
    private String pepEncryptionAlias;
    private String pdpEncryptionAlias;
    private boolean isWebBase;

    public void handleRequest(RequestContext rc) throws CLIException {
        block5: {
            super.handleRequest(rc);
            this.ldapLogin();
            this.superAdminUserValidation();
            this.realm = this.getStringOptionValue("realm", "/");
            this.entityID = this.getStringOptionValue("entityid");
            this.spSigningAlias = this.getStringOptionValue("spscertalias");
            this.idpSigningAlias = this.getStringOptionValue("idpscertalias");
            this.spEncryptionAlias = this.getStringOptionValue("specertalias");
            this.idpEncryptionAlias = this.getStringOptionValue("idpecertalias");
            this.validateOptions();
            this.normalizeOptions();
            String webURL = this.getCommandManager().getWebEnabledURL();
            this.isWebBase = webURL != null && webURL.trim().length() > 0;
            String spec = FederationManager.getIDFFSubCommandSpecification(rc);
            String[] params = new String[]{this.realm, this.entityID, this.spSigningAlias, this.idpSigningAlias, this.spEncryptionAlias, this.idpEncryptionAlias, spec};
            this.writeLog(0, Level.INFO, "ATTEMPT_UPDATE_ENTITY_KEYINFO", params);
            try {
                if (spec.equals("saml2")) {
                    this.handleSAML2Request(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_UPDATE_ENTITY_KEYINFO", params);
                    break block5;
                }
                if (spec.equals("idff")) {
                    this.handleIDFFRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_UPDATE_ENTITY_KEYINFO", params);
                    break block5;
                }
                if (spec.equals("wsfed")) {
                    this.handleWSFedRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_UPDATE_ENTITY_KEYINFO", params);
                    break block5;
                }
                throw new CLIException(this.getResourceString("unsupported-specification"), 127);
            }
            catch (CLIException e) {
                String[] args = new String[]{this.realm, this.entityID, this.spSigningAlias, this.idpSigningAlias, this.spEncryptionAlias, this.idpEncryptionAlias, spec, e.getMessage()};
                this.writeLog(1, Level.INFO, "FAILED_UPDATE_ENTITY_KEYINFO", args);
                throw e;
            }
        }
    }

    private void validateOptions() throws CLIException {
        if (this.idpSigningAlias == null && this.spSigningAlias == null && this.idpEncryptionAlias == null && this.spEncryptionAlias == null) {
            throw new CLIException(this.getResourceString("update-meta-keyinfo-exception-alias-null"), 127);
        }
    }

    private void normalizeOptions() {
        if (this.idpSigningAlias == null) {
            this.idpSigningAlias = "";
        }
        if (this.idpEncryptionAlias == null) {
            this.idpEncryptionAlias = "";
        }
        if (this.spSigningAlias == null) {
            this.spSigningAlias = "";
        }
        if (this.spEncryptionAlias == null) {
            this.spEncryptionAlias = "";
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(this.realm, this.entityID);
            if (descriptor == null) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("update-meta-keyinfo-exception-entity-not-exist"), objs2), 127);
            }
            if (!this.spSigningAlias.equals("")) {
                if (this.spSigningAlias.equals(NULL_ALIAS)) {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)true, (boolean)false, null, (int)0);
                } else {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.spSigningAlias, (boolean)true, (boolean)false, null, (int)0);
                }
            }
            if (!this.idpSigningAlias.equals("")) {
                if (this.idpSigningAlias.equals(NULL_ALIAS)) {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)true, (boolean)true, null, (int)0);
                } else {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.idpSigningAlias, (boolean)true, (boolean)true, null, (int)0);
                }
            }
            if (!this.spEncryptionAlias.equals("")) {
                if (this.spEncryptionAlias.equals(NULL_ALIAS)) {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)false, (boolean)false, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                } else {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.spEncryptionAlias, (boolean)false, (boolean)false, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                }
            }
            if (!this.idpEncryptionAlias.equals("")) {
                if (this.idpEncryptionAlias.equals(NULL_ALIAS)) {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)false, (boolean)true, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                } else {
                    SAML2MetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.idpEncryptionAlias, (boolean)false, (boolean)true, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                }
            }
            Object[] objs = new Object[]{this.entityID};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("update-keyinfo-succeeded"), objs));
        }
        catch (SAML2Exception e) {
            SAML2MetaUtils.debug.error("UpdateMetaKey.handleSAML2Request", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(this.realm, this.entityID);
            if (descriptor == null) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("update-meta-keyinfo-exception-entity-not-exist"), objs2), 127);
            }
            if (!this.spSigningAlias.equals("")) {
                if (this.spSigningAlias.equals(NULL_ALIAS)) {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)true, (boolean)false, null, (int)0);
                } else {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.spSigningAlias, (boolean)true, (boolean)false, null, (int)0);
                }
            }
            if (!this.idpSigningAlias.equals("")) {
                if (this.idpSigningAlias.equals(NULL_ALIAS)) {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)true, (boolean)true, null, (int)0);
                } else {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.idpSigningAlias, (boolean)true, (boolean)true, null, (int)0);
                }
            }
            if (!this.spEncryptionAlias.equals("")) {
                if (this.spEncryptionAlias.equals(NULL_ALIAS)) {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)false, (boolean)false, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                } else {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.spEncryptionAlias, (boolean)false, (boolean)false, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                }
            }
            if (!this.idpEncryptionAlias.equals("")) {
                if (this.idpEncryptionAlias.equals(NULL_ALIAS)) {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)false, (boolean)true, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                } else {
                    IDFFMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.idpEncryptionAlias, (boolean)false, (boolean)true, (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (int)128);
                }
            }
            Object[] objs = new Object[]{this.entityID};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("update-keyinfo-succeeded"), objs));
        }
        catch (IDFFMetaException e) {
            IDFFMetaUtils.debug.error("UpdateMetaKey.handleIDFFRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        try {
            FederationElement descriptor = WSFederationMetaManager.getEntityDescriptor((String)this.realm, (String)this.entityID);
            if (descriptor == null) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("update-meta-keyinfo-exception-entity-not-exist"), objs2), 127);
            }
            if (!this.spSigningAlias.equals("")) {
                if (this.spSigningAlias.equals(NULL_ALIAS)) {
                    WSFederationMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)false);
                } else {
                    WSFederationMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.spSigningAlias, (boolean)false);
                }
            }
            if (!this.idpSigningAlias.equals("")) {
                if (this.idpSigningAlias.equals(NULL_ALIAS)) {
                    WSFederationMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, null, (boolean)true);
                } else {
                    WSFederationMetaSecurityUtils.updateProviderKeyInfo((String)this.realm, (String)this.entityID, (String)this.idpSigningAlias, (boolean)true);
                }
            }
            if (!this.spEncryptionAlias.equals("")) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("update-meta-keyinfo-exception-invalid-option"), objs2), 127);
            }
            if (!this.idpEncryptionAlias.equals("")) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("update-meta-keyinfo-exception-invalid-option"), objs2), 127);
            }
            Object[] objs = new Object[]{this.entityID};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("update-keyinfo-succeeded"), objs));
        }
        catch (WSFederationMetaException e) {
            WSFederationMetaUtils.debug.error("UpdateMetaKey.handleIDFFRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

