/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.ConsumerSiteAttributeMapper;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultSiteAttributeMapper
implements ConsumerSiteAttributeMapper {
    public List getAttributes(Object token, HttpServletRequest request, HttpServletResponse response, String targetURL) throws SAMLException {
        Map localValueMap;
        Map attrMap;
        block17: {
            attrMap = (Map)SAMLServiceManager.getAttribute((String)"iplanet-am-saml-attr-map");
            if (attrMap == null || attrMap.isEmpty()) {
                return null;
            }
            HashSet localAttrNames = new HashSet();
            localAttrNames.addAll(attrMap.values());
            localValueMap = null;
            try {
                DataStoreProvider dsProvider = DataStoreProviderManager.getInstance().getDataStoreProvider("saml");
                localValueMap = dsProvider.getAttributes(SessionManager.getProvider().getPrincipalName(token), localAttrNames);
            }
            catch (Exception ex) {
                if (!SAMLUtils.debug.warningEnabled()) break block17;
                SAMLUtils.debug.warning("DefaultSiteAttributeMapper.getAttributes:", (Throwable)ex);
            }
        }
        ArrayList<Attribute> samlAttrs = null;
        for (String samlAttrName : attrMap.keySet()) {
            String[] localAttrValues;
            String attrNamespace;
            String localAttrName;
            block18: {
                localAttrName = (String)attrMap.get(samlAttrName);
                attrNamespace = null;
                StringTokenizer tokenizer = new StringTokenizer(samlAttrName, "|");
                int tokenCount = tokenizer.countTokens();
                if (tokenCount == 1) {
                    attrNamespace = "urn:oasis:names:tc:SAML:1.0:assertion";
                } else if (tokenCount == 2) {
                    attrNamespace = tokenizer.nextToken();
                    samlAttrName = tokenizer.nextToken();
                } else {
                    if (!SAMLUtils.debug.messageEnabled()) continue;
                    SAMLUtils.debug.message("DefaultSiteAttributeMapper.getAttribute: invalid saml attribute in attribute  map. saml attribute = " + samlAttrName + ", the " + " syntax is namespace|attrName.");
                    continue;
                }
                localAttrValues = null;
                if (localValueMap != null && !localValueMap.isEmpty()) {
                    Set values = (Set)localValueMap.get(localAttrName);
                    if (values == null || values.isEmpty()) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("DefaultSiteAttributeMapper.getAttribute: user profile does not have value for " + localAttrName + " but is going to check ssotoken:");
                        }
                    } else {
                        localAttrValues = values.toArray(new String[values.size()]);
                    }
                }
                if (localAttrValues == null) {
                    try {
                        localAttrValues = SessionManager.getProvider().getProperty(token, localAttrName);
                    }
                    catch (SessionException ex) {
                        if (!SAMLUtils.debug.messageEnabled()) break block18;
                        SAMLUtils.debug.message("DefaultSiteAttributeMapper.getAttribute:", (Throwable)ex);
                    }
                }
            }
            if (localAttrValues == null || localAttrValues.length == 0) {
                if (!SAMLUtils.debug.messageEnabled()) continue;
                SAMLUtils.debug.message("DefaultSiteAttributeMapper.getAttribute: user does not have " + localAttrName);
                continue;
            }
            Attribute samlAttr = this.getSAMLAttribute(samlAttrName, attrNamespace, localAttrValues);
            if (samlAttr == null) continue;
            if (samlAttrs == null) {
                samlAttrs = new ArrayList<Attribute>();
            }
            samlAttrs.add(samlAttr);
            if (!SAMLUtils.debug.messageEnabled()) continue;
            SAMLUtils.debug.message("DefaultSiteAttributeMapper.getAttribute: add atttribute = " + samlAttrName + ", attrNamespace = " + attrNamespace + ", values = " + localAttrValues);
        }
        return samlAttrs;
    }

    protected Attribute getSAMLAttribute(String name, String attrNamespace, String[] values) throws SAMLException {
        if (values == null || values.length == 0) {
            return null;
        }
        Attribute attribute = new Attribute(name, attrNamespace, values[0]);
        for (int i = 1; i < values.length; ++i) {
            attribute.addAttributeValue(values[i]);
        }
        return attribute;
    }

    static boolean isDynamicalOrIgnoredProfile(String realm) {
        try {
            OrganizationConfigManager orgConfigMgr = AuthD.getAuth().getOrgConfigManager(realm);
            ServiceConfig svcConfig = orgConfigMgr.getServiceConfig("iPlanetAMAuthService");
            Map attrs = svcConfig.getAttributes();
            String tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-dynamic-profile-creation");
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("DefaultSiteAttributeMapper.isDynamicalOrIgnoredProfile: attr = " + tmp);
            }
            return tmp != null && (tmp.equalsIgnoreCase("createAlias") || tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("ignore"));
        }
        catch (Exception e) {
            SAMLUtils.debug.error("DefaultSiteAttributeMapper.isDynamicalOrIgnoredProfile: unable to get attribute", (Throwable)e);
            return false;
        }
    }
}

