/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaSecurityUtils;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import java.util.List;
import java.util.Map;

public class CreateIDFFMetaDataTemplate {
    private CreateIDFFMetaDataTemplate() {
    }

    public static String createStandardMetaTemplate(String entityId, Map mapParams, String url) throws IDFFMetaException {
        String affiAlias;
        String spAlias;
        if (url == null) {
            String protocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
            String host = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
            String port = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
            String deploymentURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
            url = protocol + "://" + host + ":" + port + deploymentURI;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<EntityDescriptor\n").append("    xmlns=\"urn:liberty:metadata:2003-08\"\n").append("    providerID=\"" + entityId + "\">\n");
        String idpAlias = (String)mapParams.get("idp");
        if (idpAlias != null) {
            String realm = IDFFMetaUtils.getRealmByMetaAlias((String)idpAlias);
            CreateIDFFMetaDataTemplate.addIDFFIdentityProviderTemplate(buff, mapParams, url);
        }
        if ((spAlias = (String)mapParams.get("sp")) != null) {
            String realm = IDFFMetaUtils.getRealmByMetaAlias((String)spAlias);
            CreateIDFFMetaDataTemplate.addIDFFServiceProviderTemplate(buff, mapParams, url);
        }
        if ((affiAlias = (String)mapParams.get("affiliation")) != null) {
            String realm = IDFFMetaUtils.getRealmByMetaAlias((String)affiAlias);
            CreateIDFFMetaDataTemplate.addAffiliationTemplate(buff, entityId, affiAlias, url, mapParams);
        }
        buff.append("</EntityDescriptor>\n");
        return buff.toString();
    }

    private static void addIDFFIdentityProviderTemplate(StringBuffer buff, Map mapParams, String url) throws IDFFMetaException {
        String idpEX509Cert;
        String idpAlias = (String)mapParams.get("idp");
        String idpSCertAlias = (String)mapParams.get("idpscert");
        String idpECertAlias = (String)mapParams.get("idpecert");
        String maStr = CreateIDFFMetaDataTemplate.buildMetaAliasInURI(idpAlias);
        buff.append("    <IDPDescriptor\n").append("        protocolSupportEnumeration=").append("\"urn:liberty:iff:2003-08 urn:liberty:iff:2002-12\">\n");
        String idpSX509Cert = IDFFMetaSecurityUtils.buildX509Certificate((String)idpSCertAlias);
        if (idpSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n").append("            <KeyInfo xmlns=\"").append("http://www.w3.org/2000/09/xmldsig#").append("\">\n").append("                <X509Data>\n").append("                    <X509Certificate>\n").append(idpSX509Cert).append("                    </X509Certificate>\n").append("                </X509Data>\n").append("            </KeyInfo>\n").append("        </KeyDescriptor>\n");
        }
        if ((idpEX509Cert = IDFFMetaSecurityUtils.buildX509Certificate((String)idpECertAlias)) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n").append("            <EncryptionMethod>http://www.w3.org/2001/04/xmlenc#aes128-cbc</EncryptionMethod>\n").append("            <KeySize>128</KeySize>\n").append("            <KeyInfo xmlns=\"").append("http://www.w3.org/2000/09/xmldsig#").append("\">\n").append("                <X509Data>\n").append("                    <X509Certificate>\n").append(idpEX509Cert).append("                    </X509Certificate>\n").append("                </X509Data>\n").append("            </KeyInfo>\n").append("        </KeyDescriptor>\n");
        }
        buff.append("        <SoapEndpoint>").append(url).append("/SOAPReceiver").append(maStr).append("</SoapEndpoint>\n").append("        <SingleLogoutServiceURL>").append(url).append("/ProcessLogout").append(maStr).append("</SingleLogoutServiceURL>\n").append("        <SingleLogoutServiceReturnURL>").append(url).append("/ReturnLogout").append(maStr).append("</SingleLogoutServiceReturnURL>\n").append("        <FederationTerminationServiceURL>").append(url).append("/ProcessTermination").append(maStr).append("</FederationTerminationServiceURL>\n").append("        <FederationTerminationServiceReturnURL>").append(url).append("/ReturnTermination").append(maStr).append("</FederationTerminationServiceReturnURL>\n").append("        <FederationTerminationNotificationProtocolProfile>http://projectliberty.org/profiles/fedterm-sp-http</FederationTerminationNotificationProtocolProfile>\n").append("        <FederationTerminationNotificationProtocolProfile>http://projectliberty.org/profiles/fedterm-sp-soap</FederationTerminationNotificationProtocolProfile>\n").append("        <SingleLogoutProtocolProfile>http://projectliberty.org/profiles/slo-sp-http</SingleLogoutProtocolProfile>\n").append("        <SingleLogoutProtocolProfile>http://projectliberty.org/profiles/slo-sp-soap</SingleLogoutProtocolProfile>\n").append("        <RegisterNameIdentifierProtocolProfile>http://projectliberty.org/profiles/rni-sp-http</RegisterNameIdentifierProtocolProfile>\n").append("        <RegisterNameIdentifierProtocolProfile>http://projectliberty.org/profiles/rni-sp-soap</RegisterNameIdentifierProtocolProfile>\n").append("        <RegisterNameIdentifierServiceURL>").append(url).append("/ProcessRegistration").append(maStr).append("</RegisterNameIdentifierServiceURL>\n").append("        <RegisterNameIdentifierServiceReturnURL>").append(url).append("/ReturnRegistration").append(maStr).append("</RegisterNameIdentifierServiceReturnURL>\n").append("        <SingleSignOnServiceURL>").append(url).append("/SingleSignOnService").append(maStr).append("</SingleSignOnServiceURL>\n").append("        <SingleSignOnProtocolProfile>http://projectliberty.org/profiles/brws-art</SingleSignOnProtocolProfile>\n").append("        <SingleSignOnProtocolProfile>http://projectliberty.org/profiles/brws-post</SingleSignOnProtocolProfile>\n").append("        <SingleSignOnProtocolProfile>http://projectliberty.org/profiles/lecp</SingleSignOnProtocolProfile>\n").append("    </IDPDescriptor>\n");
    }

    private static void addIDFFServiceProviderTemplate(StringBuffer buff, Map mapParams, String url) throws IDFFMetaException {
        String spEX509Cert;
        String spAlias = (String)mapParams.get("sp");
        String spSCertAlias = (String)mapParams.get("spscert");
        String spECertAlias = (String)mapParams.get("specert");
        String maStr = CreateIDFFMetaDataTemplate.buildMetaAliasInURI(spAlias);
        buff.append("    <SPDescriptor\n").append("        protocolSupportEnumeration=\n").append("            \"urn:liberty:iff:2003-08 urn:liberty:iff:2002-12\">\n");
        String spSX509Cert = IDFFMetaSecurityUtils.buildX509Certificate((String)spSCertAlias);
        if (spSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n").append("            <KeyInfo xmlns=\"").append("http://www.w3.org/2000/09/xmldsig#").append("\">\n").append("                <X509Data>\n").append("                    <X509Certificate>\n").append(spSX509Cert).append("                    </X509Certificate>\n").append("                </X509Data>\n").append("            </KeyInfo>\n").append("        </KeyDescriptor>\n");
        }
        if ((spEX509Cert = IDFFMetaSecurityUtils.buildX509Certificate((String)spECertAlias)) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n").append("            <EncryptionMethod>http://www.w3.org/2001/04/xmlenc#aes128-cbc</EncryptionMethod>\n").append("            <KeySize>128</KeySize>\n").append("            <KeyInfo xmlns=\"").append("http://www.w3.org/2000/09/xmldsig#").append("\">\n").append("                <X509Data>\n").append("                    <X509Certificate>\n").append(spEX509Cert).append("                    </X509Certificate>\n").append("                </X509Data>\n").append("            </KeyInfo>\n").append("        </KeyDescriptor>\n");
        }
        buff.append("        <SoapEndpoint>").append(url).append("/SOAPReceiver").append(maStr).append("</SoapEndpoint>\n").append("        <SingleLogoutServiceURL>").append(url).append("/ProcessLogout").append(maStr).append("</SingleLogoutServiceURL>\n").append("        <SingleLogoutServiceReturnURL>").append(url).append("/ReturnLogout").append(maStr).append("</SingleLogoutServiceReturnURL>\n").append("        <FederationTerminationServiceURL>").append(url).append("/ProcessTermination").append(maStr).append("</FederationTerminationServiceURL>\n").append("        <FederationTerminationServiceReturnURL>").append(url).append("/ReturnTermination").append(maStr).append("</FederationTerminationServiceReturnURL>\n").append("        <FederationTerminationNotificationProtocolProfile>http://projectliberty.org/profiles/fedterm-idp-http</FederationTerminationNotificationProtocolProfile>\n").append("        <FederationTerminationNotificationProtocolProfile>http://projectliberty.org/profiles/fedterm-idp-soap</FederationTerminationNotificationProtocolProfile>\n").append("        <SingleLogoutProtocolProfile>http://projectliberty.org/profiles/slo-idp-http</SingleLogoutProtocolProfile>\n").append("        <SingleLogoutProtocolProfile>http://projectliberty.org/profiles/slo-idp-soap</SingleLogoutProtocolProfile>\n").append("        <RegisterNameIdentifierProtocolProfile>http://projectliberty.org/profiles/rni-idp-http</RegisterNameIdentifierProtocolProfile>\n").append("        <RegisterNameIdentifierProtocolProfile>http://projectliberty.org/profiles/rni-idp-soap</RegisterNameIdentifierProtocolProfile>\n").append("        <RegisterNameIdentifierServiceURL>").append(url).append("/ProcessRegistration").append(maStr).append("</RegisterNameIdentifierServiceURL>\n").append("        <RegisterNameIdentifierServiceReturnURL>").append(url).append("/ReturnRegistration").append(maStr).append("</RegisterNameIdentifierServiceReturnURL>\n").append("        <AssertionConsumerServiceURL id=\"1\" isDefault=\"true\">").append(url).append("/AssertionConsumerService").append(maStr).append("</AssertionConsumerServiceURL>\n").append("        <AuthnRequestsSigned>false</AuthnRequestsSigned>\n").append("    </SPDescriptor>\n");
    }

    public static String createExtendedMetaTemplate(String entityId, Map mapParams) {
        String affiAlias;
        String spAlias;
        StringBuffer buff = new StringBuffer();
        buff.append("<EntityConfig xmlns=\"urn:sun:fm:ID-FF:entityconfig\"\n").append("    hosted=\"1\"\n").append("    entityID=\"").append(entityId).append("\">\n\n");
        String idpAlias = (String)mapParams.get("idp");
        if (idpAlias != null) {
            String realm = IDFFMetaUtils.getRealmByMetaAlias((String)idpAlias);
            CreateIDFFMetaDataTemplate.buildIDFFIDPConfigTemplate(mapParams, buff);
        }
        if ((spAlias = (String)mapParams.get("sp")) != null) {
            String realm = IDFFMetaUtils.getRealmByMetaAlias((String)spAlias);
            CreateIDFFMetaDataTemplate.buildIDFFSPConfigTemplate(mapParams, buff);
        }
        if ((affiAlias = (String)mapParams.get("affiliation")) != null) {
            String realm = IDFFMetaUtils.getRealmByMetaAlias((String)affiAlias);
            CreateIDFFMetaDataTemplate.buildAffiliationConfigTemplate(buff, affiAlias, mapParams);
        }
        buff.append("</EntityConfig>\n");
        return buff.toString();
    }

    private static void buildIDFFIDPConfigTemplate(Map mapParams, StringBuffer buff) {
        String idpAlias = (String)mapParams.get("idp");
        String idpSCertAlias = (String)mapParams.get("idpscert");
        String idpECertAlias = (String)mapParams.get("idpecert");
        if (idpSCertAlias == null) {
            idpSCertAlias = "";
        }
        if (idpECertAlias == null) {
            idpECertAlias = "";
        }
        buff.append("    <IDPDescriptorConfig metaAlias=\"").append(idpAlias).append("\">\n").append("        <Attribute name=\"").append("providerStatus").append("\">\n").append("            <Value>active</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("providerDescription").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("signingCertAlias").append("\">\n").append("            <Value>").append(idpSCertAlias).append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("encryptionCertAlias").append("\">\n").append("            <Value>").append(idpECertAlias).append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("enableNameIDEncryption").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("generateBootstrapping").append("\">\n").append("            <Value>true</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("respondsWith").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("userProviderClass").append("\">\n").append("            <Value>com.sun.identity.federation.accountmgmt.DefaultFSUserProvider</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("nameIDImplementationClass").append("\">\n").append("            <Value>com.sun.identity.federation.services.util.FSNameIdentifierImpl</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("authType").append("\">\n").append("            <Value>local</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("registrationDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("terminationDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("logoutDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("listOfCOTsPageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("errorPageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("providerHomePageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("assertionInterval").append("\">\n").append("            <Value>60</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("cleanupInterval").append("\">\n").append("            <Value>180</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("artifactTimeout").append("\">\n").append("            <Value>120</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("assertionLimit").append("\">\n").append("            <Value>0</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("assertionIssuer").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("attributePlugin").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("idpAttributeMap").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("defaultAuthnContext").append("\">\n").append("            <Value>").append("http://www.projectliberty.org/schemas/authctx/classes/Password").append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("idpAuthnContextMapping").append("\">\n").append("            <Value>context=").append("http://www.projectliberty.org/schemas/authctx/classes/Password").append("|key=module|value=DataStore|level=0</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("enableAutoFederation").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("autoFederationAttribute").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("attributeMapperClass").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("       <Attribute name=\"").append("cotlist").append("\">\n").append("       </Attribute>\n").append("    </IDPDescriptorConfig>\n");
    }

    private static void buildIDFFSPConfigTemplate(Map mapParams, StringBuffer buff) {
        String spAlias = (String)mapParams.get("sp");
        String spSCertAlias = (String)mapParams.get("spscert");
        String spECertAlias = (String)mapParams.get("specert");
        if (spSCertAlias == null) {
            spSCertAlias = "";
        }
        if (spECertAlias == null) {
            spECertAlias = "";
        }
        buff.append("    <SPDescriptorConfig metaAlias=\"").append(spAlias).append("\">\n").append("        <Attribute name=\"").append("providerStatus").append("\">\n").append("            <Value>active</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("providerDescription").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("signingCertAlias").append("\">\n").append("            <Value>").append(spSCertAlias).append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("encryptionCertAlias").append("\">\n").append("            <Value>").append(spECertAlias).append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("enableIDPProxy").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("idpProxyList").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("idpProxyCount").append("\">\n").append("            <Value>-1</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("useIntroductionForIDPProxy").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("enableAffiliation").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("enableNameIDEncryption").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("supportedSSOProfile").append("\">\n").append("            <Value>http://projectliberty.org/profiles/brws-art</Value>\n").append("            <Value>http://projectliberty.org/profiles/brws-post</Value>\n").append("            <Value>http://projectliberty.org/profiles/wml-post</Value>\n").append("            <Value>http://projectliberty.org/profiles/lecp</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("nameIDPolicy").append("\">\n").append("            <Value>federated</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("forceAuthn").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("isPassive").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("respondsWith").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("userProviderClass").append("\">\n").append("            <Value>com.sun.identity.federation.accountmgmt.DefaultFSUserProvider</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("nameIDImplementationClass").append("\">\n").append("            <Value>com.sun.identity.federation.services.util.FSNameIdentifierImpl</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("authType").append("\">\n").append("            <Value>remote</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("registrationDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("terminationDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("logoutDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("federationDoneURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("doFederatePageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("listOfCOTsPageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("errorPageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("ssoFailureRedirectURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("providerHomePageURL").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("defaultAuthnContext").append("\">\n").append("            <Value>").append("http://www.projectliberty.org/schemas/authctx/classes/Password").append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("spAuthnContextMapping").append("\">\n").append("            <Value>context=").append("http://www.projectliberty.org/schemas/authctx/classes/Password").append("|level=0</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("enableAutoFederation").append("\">\n").append("            <Value>false</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("autoFederationAttribute").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("attributeMapperClass").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("spAttributeMap").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("federationSPAdapter").append("\">\n").append("            <Value>com.sun.identity.federation.plugins.FSDefaultSPAdapter</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("federationSPAdapterEnv").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("cotlist").append("\">\n").append("        </Attribute>\n").append("    </SPDescriptorConfig>\n");
    }

    private static String buildMetaAliasInURI(String alias) {
        return "/metaAlias" + alias;
    }

    private static void addAffiliationTemplate(StringBuffer buff, String entityID, String affiAlias, String url, Map mapParams) throws IDFFMetaException {
        String affiECertAlias;
        String affiEX509Cert;
        String maStr = CreateIDFFMetaDataTemplate.buildMetaAliasInURI(affiAlias);
        String affiOwnerID = (String)mapParams.get("affiOwnerID");
        buff.append("    <AffiliationDescriptor\n").append("        affiliationID=\"").append(entityID).append("\" \n").append("        affiliationOwnerID=\"").append(affiOwnerID).append("\">\n");
        List affiMembers = (List)mapParams.get("affimembers");
        for (String affiMember : affiMembers) {
            buff.append("        <AffiliateMember>" + affiMember + "</AffiliateMember>\n");
        }
        String affiSCertAlias = (String)mapParams.get("affiscert");
        String affiSX509Cert = IDFFMetaSecurityUtils.buildX509Certificate((String)affiSCertAlias);
        if (affiSX509Cert != null) {
            buff.append("        <KeyDescriptor use=\"signing\">\n").append("            <KeyInfo xmlns=\"").append("http://www.w3.org/2000/09/xmldsig#").append("\">\n").append("                <X509Data>\n").append("                    <X509Certificate>\n").append(affiSX509Cert).append("                    </X509Certificate>\n").append("                </X509Data>\n").append("            </KeyInfo>\n").append("        </KeyDescriptor>\n");
        }
        if ((affiEX509Cert = IDFFMetaSecurityUtils.buildX509Certificate((String)(affiECertAlias = (String)mapParams.get("affiecert")))) != null) {
            buff.append("        <KeyDescriptor use=\"encryption\">\n").append("            <EncryptionMethod>http://www.w3.org/2001/04/xmlenc#aes128-cbc</EncryptionMethod>\n").append("            <KeySize>128</KeySize>\n").append("            <KeyInfo xmlns=\"").append("http://www.w3.org/2000/09/xmldsig#").append("\">\n").append("                <X509Data>\n").append("                    <X509Certificate>\n").append(affiEX509Cert).append("                    </X509Certificate>\n").append("                </X509Data>\n").append("            </KeyInfo>\n").append("        </KeyDescriptor>\n");
        }
        buff.append("    </AffiliationDescriptor>\n");
    }

    private static void buildAffiliationConfigTemplate(StringBuffer buff, String affiAlias, Map mapParams) {
        String affiECertAlias = (String)mapParams.get("affiecert");
        String affiSCertAlias = (String)mapParams.get("affiscert");
        if (affiECertAlias == null) {
            affiECertAlias = "";
        }
        if (affiSCertAlias == null) {
            affiSCertAlias = "";
        }
        buff.append("    <AffiliationDescriptorConfig metaAlias=\"").append(affiAlias).append("\">\n").append("        <Attribute name=\"").append("providerDescription").append("\">\n").append("            <Value></Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("signingCertAlias").append("\">\n").append("            <Value>").append(affiSCertAlias).append("</Value>\n").append("        </Attribute>\n").append("        <Attribute name=\"").append("encryptionCertAlias").append("\">\n").append("            <Value>").append(affiECertAlias).append("</Value>\n").append("        </Attribute>\n").append("    </AffiliationDescriptorConfig>\n");
    }
}

