/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;

public class ClientLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Principal loginPrincipal;
    private Object loginCredential;
    private Map<String, ?> sharedState;
    private boolean useFirstPass;
    private boolean restoreLoginIdentity;
    private SecurityContext cachedSecurityContext;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        PicketBoxLogger.LOGGER.debugModuleOption("jboss.security.security_domain", options.get("jboss.security.security_domain"));
        String flag = (String)options.get("multi-threaded");
        if (Boolean.valueOf(flag).booleanValue()) {
            PicketBoxLogger.LOGGER.debugModuleOption("multi-threaded", flag);
        }
        if (flag != null && flag.length() > 0 && "false".equalsIgnoreCase(flag)) {
            SecurityAssociationActions.setClient();
        }
        flag = (String)options.get("restore-login-identity");
        this.restoreLoginIdentity = Boolean.valueOf(flag);
        PicketBoxLogger.LOGGER.debugModuleOption("restory-login-identity", flag);
        String passwordStacking = (String)options.get("password-stacking");
        this.useFirstPass = passwordStacking != null;
        PicketBoxLogger.LOGGER.debugModuleOption("password-stacking", passwordStacking);
        this.cachedSecurityContext = SecurityAssociationActions.getSecurityContext();
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        if (this.useFirstPass) {
            try {
                Object name = this.sharedState.get("javax.security.auth.login.name");
                if (!(name instanceof Principal)) {
                    String username = name != null ? name.toString() : "";
                    this.loginPrincipal = new SimplePrincipal(username);
                } else {
                    this.loginPrincipal = (Principal)name;
                }
                this.loginCredential = this.sharedState.get("javax.security.auth.login.password");
                return true;
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugIgnoredException(e);
            }
        }
        if (this.callbackHandler == null) {
            throw PicketBoxMessages.MESSAGES.noCallbackHandlerAvailable();
        }
        PasswordCallback pc = new PasswordCallback(PicketBoxMessages.MESSAGES.enterPasswordMessage(), false);
        NameCallback nc = new NameCallback(PicketBoxMessages.MESSAGES.enterUsernameMessage(), "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            char[] password = null;
            this.callbackHandler.handle(callbacks);
            String username = nc.getName();
            this.loginPrincipal = new SimplePrincipal(username);
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
                pc.clearPassword();
            }
            this.loginCredential = password;
            PicketBoxLogger.LOGGER.traceObtainedAuthInfoFromHandler(this.loginPrincipal, this.loginCredential != null ? this.loginCredential.getClass() : null);
        }
        catch (IOException ioe) {
            LoginException ex = new LoginException(ioe.getLocalizedMessage());
            ex.initCause(ioe);
            throw ex;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException ex = new LoginException(uce.getLocalizedMessage());
            ex.initCause(uce);
            throw ex;
        }
        PicketBoxLogger.LOGGER.traceEndLogin(true);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginCommit(true);
        SecurityAssociationActions.setPrincipalInfo(this.loginPrincipal, this.loginCredential, this.subject);
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.loginPrincipal)) {
            principals.add(this.loginPrincipal);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginAbort();
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
        } else {
            SecurityAssociationActions.clear();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogout();
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
        } else {
            SecurityAssociationActions.clear();
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.loginPrincipal);
        return true;
    }
}

