/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.Crypt;
import com.sun.identity.security.ISSecurityPermission;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.security.Permission;

public class AdminUtils {
    private static String adminDN = null;
    private static byte[] adminPassword = null;
    private static Debug debug;

    public static void initialize() {
        block5: {
            debug = Debug.getInstance((String)"amSDK");
            try {
                DSConfigMgr dscMgr = DSConfigMgr.getDSConfigMgr();
                ServerInstance svrInstance = dscMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
                if (svrInstance != null) {
                    adminDN = svrInstance.getAuthID();
                    String adminPW = (String)AccessController.doPrivileged(new ServerInstanceAction(svrInstance));
                    adminPassword = AdminUtils.xor(adminPW.getBytes());
                } else {
                    debug.error("AdminUtils.initialize: server instance not found");
                }
            }
            catch (LDAPServiceException e) {
                if (SystemProperties.isServerMode()) {
                    debug.error("AdminUtils.initialize: Initialize admin info ", (Throwable)e);
                }
                if (!debug.messageEnabled()) break block5;
                debug.message("AdminUtilsinitialize: Could not initialize admin info message:" + e.getMessage());
            }
        }
    }

    public static String getAdminDN() {
        if (Crypt.checkCaller()) {
            ISSecurityPermission isp = new ISSecurityPermission("access", "adminpassword");
            try {
                if (Crypt.securityManager != null) {
                    Crypt.securityManager.checkPermission((Permission)isp);
                }
            }
            catch (SecurityException e) {
                debug.error("Security Alert: Unauthorized access to Administative password utility: Returning NULL", (Throwable)e);
                return null;
            }
        }
        return adminDN;
    }

    public static byte[] getAdminPassword() {
        if (Crypt.checkCaller()) {
            ISSecurityPermission isp = new ISSecurityPermission("access", "adminpassword");
            try {
                if (Crypt.securityManager != null) {
                    Crypt.securityManager.checkPermission((Permission)isp);
                }
            }
            catch (SecurityException e) {
                debug.error("Security Alert: Unauthorized access to Administative password utility: Returning NULL", (Throwable)e);
                return null;
            }
        }
        return AdminUtils.xor(adminPassword);
    }

    private static byte[] xor(byte[] password) {
        if (password != null) {
            int len = password.length;
            byte[] retPassword = new byte[len];
            for (int i = 0; i < len; ++i) {
                retPassword[i] = (byte)(password[i] ^ 1);
            }
            return retPassword;
        }
        return null;
    }

    static {
        AdminUtils.initialize();
    }
}

