/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Set;

public class UpdateDNSAlias {
    static Debug debug = Debug.getInstance((String)"amMultiInstall");

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println(" Usage: UpdateDNSAlias <add | delete> <orgdn> <dnsalias> <userdn> <passwd>");
            System.exit(1);
        }
        String opt = args[0];
        String orgDn = args[1];
        String dnsAlias = args[2];
        if (opt == null || orgDn == null || dnsAlias == null) {
            debug.error("One or more parameters are null");
            System.exit(1);
        }
        try {
            String bindDN = args[3];
            String password = args[4];
            SSOTokenManager ssom = SSOTokenManager.getInstance();
            SSOToken token = ssom.createSSOToken(new AuthPrincipal(bindDN), password);
            AMStoreConnection asc = new AMStoreConnection(token);
            AMOrganization org = asc.getOrganization(orgDn);
            Set values = org.getAttribute("sunOrganizationAlias");
            HashMap<String, Set> map = new HashMap<String, Set>();
            if (opt.equalsIgnoreCase("add")) {
                if (!values.contains(dnsAlias)) {
                    values.add(dnsAlias);
                }
                map.put("sunOrganizationAlias", values);
                org.setAttributes(map);
                org.store();
            } else if (opt.equalsIgnoreCase("delete")) {
                values.remove(dnsAlias);
                map.put("sunOrganizationAlias", values);
                org.setAttributes(map);
                org.store();
            } else {
                debug.error("Unknown option in AMGenerateServerID");
                System.exit(1);
            }
        }
        catch (Exception e) {
            debug.error("Exception occured:", (Throwable)e);
        }
        System.exit(0);
    }
}

