/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.dpro.session.share.SessionRequest;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SessionRequestParser {
    private SessionRequest sessionRequest = null;
    Document document;
    static Debug debug = Debug.getInstance((String)"amSession");

    public SessionRequestParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public SessionRequestParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument((String)xmlString, (Debug)debug);
    }

    public SessionRequest parseXML() {
        NodeList nodelist;
        String data;
        if (this.document == null) {
            return null;
        }
        this.sessionRequest = new SessionRequest();
        Element elem = this.document.getDocumentElement();
        String temp = elem.getAttribute("vers");
        if (temp != null) {
            this.sessionRequest.setRequestVersion(temp);
        }
        if ((temp = elem.getAttribute("reqid")) != null) {
            this.sessionRequest.setRequestID(temp);
        }
        if ((data = elem.getAttribute("requester")) != null && data.length() > 0) {
            try {
                this.sessionRequest.setRequester(new String(Base64.decode((String)data), "UTF-8"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal requester attribute value=" + data);
            }
        }
        if ((nodelist = elem.getElementsByTagName("GetSession")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(0);
            this.parseGetSessionAttributes((Element)nodelist.item(0));
        }
        if ((nodelist = elem.getElementsByTagName("GetValidSessions")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(1);
        }
        if ((nodelist = elem.getElementsByTagName("DestroySession")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(2);
        }
        if ((nodelist = elem.getElementsByTagName("Logout")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(3);
        }
        if ((nodelist = elem.getElementsByTagName("AddSessionListener")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(4);
        }
        if ((nodelist = elem.getElementsByTagName("AddSessionListenerOnAllSessions")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(5);
        }
        if ((nodelist = elem.getElementsByTagName("SetProperty")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(6);
        }
        if ((nodelist = elem.getElementsByTagName("SessionID")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setSessionID(SessionRequestParser.parseCDATA((Element)nodelist.item(0)));
        }
        if ((nodelist = elem.getElementsByTagName("DestroySessionID")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setDestroySessionID(SessionRequestParser.parseCDATA((Element)nodelist.item(0)));
        }
        if ((nodelist = elem.getElementsByTagName("URL")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setNotificationURL(SessionRequestParser.parseCDATA((Element)nodelist.item(0)));
        }
        if ((nodelist = elem.getElementsByTagName("Property")) != null && nodelist.getLength() != 0) {
            this.parsePropertyAttributes((Element)nodelist.item(0));
        }
        if ((nodelist = elem.getElementsByTagName("Pattern")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setPattern(SessionRequestParser.parseCDATA((Element)nodelist.item(0)));
        }
        if ((nodelist = elem.getElementsByTagName("GetSessionCount")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setMethodID(7);
        }
        if ((nodelist = elem.getElementsByTagName("UUID")) != null && nodelist.getLength() != 0) {
            this.sessionRequest.setUUID(SessionRequestParser.parseCDATA((Element)nodelist.item(0)));
        }
        return this.sessionRequest;
    }

    private void parsePropertyAttributes(Element property) {
        if (property == null) {
            return;
        }
        String temp = property.getAttribute("name");
        if (temp != null) {
            this.sessionRequest.setPropertyName(temp);
        }
        if ((temp = property.getAttribute("value")) != null) {
            this.sessionRequest.setPropertyValue(temp);
        }
    }

    static String parseCDATA(Element elem) {
        if (elem == null) {
            return null;
        }
        Node text = elem.getFirstChild();
        if (text != null) {
            return text.getNodeValue();
        }
        return null;
    }

    private void parseGetSessionAttributes(Element elem) {
        if (elem == null) {
            return;
        }
        String temp = elem.getAttribute("reset");
        if (temp != null) {
            if (temp.equals("true")) {
                this.sessionRequest.setResetFlag(true);
            } else {
                this.sessionRequest.setResetFlag(false);
            }
        }
    }
}

