/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class ApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ApprovalCallback theInstance = null;
    public static boolean trustAllServerCerts = false;
    public static boolean checkSubjectAltName = false;
    public static boolean resolveIPAddress = false;
    public static HashSet sslTrustHosts = new HashSet();
    private static Class[] argTypes = new Class[0];
    private static Object[] params = new Object[0];
    private static final String NEW_METHOD_NAME = "iterator";
    private static final String OLD_METHOD_NAME = "elements";
    private static Method method = null;
    private static Debug debug = Debug.getInstance((String)"amJSS");

    private static Method getMethod() throws NoSuchMethodException {
        if (method == null) {
            String methodName = NEW_METHOD_NAME;
            Method[] methods = GeneralNames.class.getDeclaredMethods();
            for (int m = 0; m < methods.length; ++m) {
                if (!methods[m].getName().equals(OLD_METHOD_NAME)) continue;
                methodName = OLD_METHOD_NAME;
                break;
            }
            method = GeneralNames.class.getMethod(methodName, argTypes);
        }
        return method;
    }

    private ApprovalCallback() {
    }

    public ApprovalCallback(String host) {
        if (host != null) {
            this.reqHost = host.toLowerCase();
        }
    }

    public static ApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        Enumeration errors = status.getReasons();
        if (trustAllServerCerts) {
            return true;
        }
        if (this.reqHost == null && !errors.hasMoreElements()) {
            return true;
        }
        boolean approve = true;
        while (approve && errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            if (debug.messageEnabled()) {
                debug.message("ApprovalCallback: reason " + reason);
            }
            if (reason != -12276) {
                approve = false;
                continue;
            }
            String cn = null;
            try {
                String subjectDN = cert.getSubjectDN().getName();
                cn = new X500Name(subjectDN).getCommonName();
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("ApprovalCallback:", (Throwable)ex);
                }
                approve = false;
            }
            if (cn == null) {
                return false;
            }
            if (!sslTrustHosts.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("ApprovalCallback: server cert CN : " + cn);
                }
                if (sslTrustHosts.contains(cn.toLowerCase())) {
                    return true;
                }
            }
            if (resolveIPAddress) {
                try {
                    approve = InetAddress.getByName(cn).getHostAddress().equals(InetAddress.getByName(this.reqHost).getHostAddress());
                }
                catch (UnknownHostException ex) {
                    if (debug.messageEnabled()) {
                        debug.message("ApprovalCallback:", (Throwable)ex);
                    }
                    approve = false;
                }
            } else {
                approve = false;
            }
            if (approve || !checkSubjectAltName) continue;
            try {
                X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
                X509CertInfo cinfo = new X509CertInfo(certImpl.getTBSCertificate());
                CertificateExtensions exts = (CertificateExtensions)cinfo.get("extensions");
                SubjectAlternativeNameExtension altNameExt = (SubjectAlternativeNameExtension)exts.get("SubjectAlternativeName");
                if (altNameExt == null) continue;
                GeneralNames names = (GeneralNames)altNameExt.get("subject_name");
                Method meth = ApprovalCallback.getMethod();
                Object generalname = null;
                if (meth.getName().equals(OLD_METHOD_NAME)) {
                    Enumeration e = (Enumeration)meth.invoke((Object)names, params);
                    while (!approve && e.hasMoreElements()) {
                        approve = this.compareHosts((GeneralName)e.nextElement());
                    }
                    continue;
                }
                Iterator i = (Iterator)meth.invoke((Object)names, params);
                while (!approve && i.hasNext()) {
                    approve = this.compareHosts((GeneralName)i.next());
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return approve;
    }

    private boolean compareHosts(GeneralName generalName) {
        block3: {
            try {
                if (generalName.getType() == 2) {
                    String name = generalName.toString();
                    name = name.substring(name.indexOf(58) + 1).trim();
                    return InetAddress.getByName(name).equals(InetAddress.getByName(this.reqHost));
                }
            }
            catch (UnknownHostException e) {
                if (!debug.messageEnabled()) break block3;
                debug.message(e.toString());
            }
        }
        return false;
    }

    private static void getSSLTrustHosts(String hostlist) {
        if (debug.messageEnabled()) {
            debug.message("ApprovalCallback  SSLTrustHostList = " + hostlist);
        }
        StringTokenizer st = new StringTokenizer(hostlist, ",");
        sslTrustHosts.clear();
        while (st.hasMoreTokens()) {
            sslTrustHosts.add(st.nextToken().trim().toLowerCase());
        }
    }

    static {
        String tmp = SystemProperties.get("com.iplanet.am.jssproxy.trustAllServerCerts");
        trustAllServerCerts = tmp != null && tmp.equalsIgnoreCase("true");
        tmp = SystemProperties.get("com.iplanet.am.jssproxy.checkSubjectAltName");
        checkSubjectAltName = tmp != null && tmp.equalsIgnoreCase("true");
        tmp = SystemProperties.get("com.iplanet.am.jssproxy.resolveIPAddress");
        resolveIPAddress = tmp != null && tmp.equalsIgnoreCase("true");
        tmp = SystemProperties.get("com.iplanet.am.jssproxy.SSLTrustHostList", null);
        if (tmp != null) {
            ApprovalCallback.getSSLTrustHosts(tmp);
        }
        if (debug.messageEnabled()) {
            debug.message("ApprovalCallback trustAllServerCerts = " + trustAllServerCerts);
            debug.message("ApprovalCallback checkSubjectAltName = " + checkSubjectAltName);
            debug.message("ApprovalCallback resolveIPAddress = " + resolveIPAddress);
            debug.message("ApprovalCallback  SSLTrustHostList = " + sslTrustHosts.toString());
        }
    }
}

