/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.JSSProxy;
import com.iplanet.services.comm.https.ReaderWriter;
import com.iplanet.services.comm.https.ReaderWriterClear;
import com.iplanet.services.comm.https.ReaderWriterLock;
import com.sun.identity.shared.debug.Debug;
import java.net.Socket;

public class RWGroupJSSProxy
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean = false;
    private boolean dst_to_src_clean = false;
    private static Debug debug = Debug.getInstance((String)"amJSS");

    public RWGroupJSSProxy(Socket fromSocket, Socket toSocket) {
        this.fromClient = fromSocket;
        this.toServer = toSocket;
        this.src_to_dst = new ReaderWriterClear(this, this.fromClient, this.toServer);
        this.dst_to_src = new ReaderWriterClear(this, this.toServer, this.fromClient);
        JSSProxy.threadPool.run(this.src_to_dst);
        JSSProxy.threadPool.run(this.dst_to_src);
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fromClient != null) {
            try {
                this.fromClient.close();
            }
            catch (Exception e) {
            }
            finally {
                this.fromClient = null;
            }
        }
        if (this.toServer != null) {
            try {
                this.toServer.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.toServer = null;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }
}

