/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSetParser;
import java.util.Vector;

public class NotificationSet {
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String BEGIN_CDATA = "<![CDATA[";
    static final String END_CDATA = "]]>";
    private String notificationSetVersion;
    private String serviceID;
    private String notificationSetID;
    private Vector notificationVector = new Vector();
    private static int notificationCount = 0;

    public NotificationSet(String service) {
        this.serviceID = service;
        this.notificationSetVersion = "1.0";
        this.notificationSetID = Integer.toString(notificationCount++);
    }

    NotificationSet() {
    }

    public static NotificationSet parseXML(String xml) {
        NotificationSetParser parser = new NotificationSetParser(xml);
        return parser.parseXML();
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public Vector getNotifications() {
        return this.notificationVector;
    }

    public void addNotification(Notification notification) {
        this.notificationVector.addElement(notification);
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer(300);
        xml.append("<?xml version=").append(QUOTE).append("1.0").append(QUOTE).append(" encoding=").append(QUOTE).append("UTF-8").append(QUOTE).append(" standalone=").append(QUOTE).append("yes").append(QUOTE).append("?>").append(NL);
        xml.append("<NotificationSet vers=").append(QUOTE).append(this.notificationSetVersion).append(QUOTE).append(" svcid=").append(QUOTE).append(this.serviceID).append(QUOTE).append(" notid=").append(QUOTE).append(this.notificationSetID).append(QUOTE).append(">").append(NL);
        int numNotifications = this.notificationVector.size();
        for (int i = 0; i < numNotifications; ++i) {
            Notification notif = (Notification)this.notificationVector.elementAt(i);
            xml.append("<Notification");
            if (notif.getDtdID() != null) {
                xml.append(" dtdid=").append(QUOTE).append(notif.getDtdID()).append(QUOTE);
            }
            xml.append(">");
            xml.append(BEGIN_CDATA).append(notif.getContent()).append(END_CDATA);
            xml.append("</Notification>").append(NL);
        }
        xml.append("</NotificationSet>");
        return xml.toString();
    }

    void setNotificationSetVersion(String ver) {
        this.notificationSetVersion = ver;
    }

    void setServiceID(String id) {
        this.serviceID = id;
    }

    void setNotificationSetID(String id) {
        this.notificationSetID = id;
    }
}

