/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.ums.SortKey;
import java.io.Serializable;
import java.util.Hashtable;

public class SearchControl
implements Serializable {
    private static final long serialVersionUID = -8755868973524858945L;
    static final String KeyVlvRange = "vlvRange";
    static final String KeyVlvJumpTo = "vlvJumpTo";
    static final String KeyTimeOut = "timeOut";
    static final String KeySortKeys = "sortKeys";
    static final String KeyMaxResults = "maxResults";
    static final String KeySearchScope = "searchScope";
    static final int DEFAULT_MAX_RESULTS = 0;
    static final int DEFAULT_TIMEOUT = 0;
    private static boolean getAllAttributesEnabled = false;
    public static final int SCOPE_ONE = 1;
    public static final int SCOPE_SUB = 2;
    public static final int SCOPE_BASE = 0;
    private Hashtable m_hashTable = new Hashtable();

    public void setSortKeys(String[] attributeNames) {
        if (attributeNames == null) {
            return;
        }
        SortKey[] sortKeys = new SortKey[attributeNames.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            sortKeys[i] = new SortKey();
            sortKeys[i].attributeName = attributeNames[i];
            sortKeys[i].reverse = false;
        }
        this.set(KeySortKeys, sortKeys);
    }

    public void setSortKeys(SortKey[] sortKeys) {
        this.set(KeySortKeys, sortKeys);
    }

    public SortKey[] getSortKeys() {
        return (SortKey[])this.get(KeySortKeys);
    }

    public void setVLVRange(int startIndex, int beforeCount, int afterCount) {
        int[] range = new int[]{startIndex, beforeCount, afterCount};
        this.set(KeyVlvRange, range);
    }

    public void setVLVRange(String jumpTo, int beforeCount, int afterCount) {
        int[] range = new int[]{0, beforeCount, afterCount};
        this.set(KeyVlvJumpTo, jumpTo);
        this.set(KeyVlvRange, range);
    }

    public int[] getVLVRange() {
        return (int[])this.get(KeyVlvRange);
    }

    public String getVLVJumpTo() {
        return (String)this.get(KeyVlvJumpTo);
    }

    public void setTimeOut(int timeOut) {
        this.set(KeyTimeOut, new Integer(timeOut));
    }

    public int getTimeOut() {
        Integer i = (Integer)this.get(KeyTimeOut);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void setMaxResults(int maxNumber) {
        this.set(KeyMaxResults, new Integer(maxNumber));
    }

    public int getMaxResults() {
        Integer i = (Integer)this.get(KeyMaxResults);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void setSearchScope(int scope) {
        this.set(KeySearchScope, new Integer(scope));
    }

    public int getSearchScope() {
        Integer scope = (Integer)this.get(KeySearchScope);
        if (scope != null) {
            return scope;
        }
        return 2;
    }

    public int getSearchScope(int defaultScope) {
        Integer scope = (Integer)this.get(KeySearchScope);
        if (scope != null) {
            return scope;
        }
        return defaultScope;
    }

    protected void set(String name, Object o) {
        this.m_hashTable.put(name, o);
    }

    protected Object get(String name) {
        return this.m_hashTable.get(name);
    }

    protected boolean contains(String name) {
        return this.m_hashTable.containsKey(name);
    }

    public void setAllReturnAttributes(boolean getAllAttributes) {
        getAllAttributesEnabled = getAllAttributes;
    }

    public boolean isGetAllReturnAttributesEnabled() {
        return getAllAttributesEnabled;
    }
}

