/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.AMSecurityPropertiesException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessageImpl;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthContext
implements Serializable {
    private Locale clientLocale = null;
    private String server_proto = SystemProperties.get("com.iplanet.am.server.protocol");
    private String server_host = SystemProperties.get("com.iplanet.am.server.host");
    private String server_port = SystemProperties.get("com.iplanet.am.server.port");
    private String server_uri = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
    private static final String amAuthContext = "amAuthContext";
    private static final String JSS_PASSWORD_UTIL = "com.sun.identity.authentication.util.JSSPasswordUtil";
    private static final String JSSE_PASSWORD_CALLBACK = "com.sun.identity.security.keystore.AMCallbackHandler";
    static String protHandlerPkg = System.getProperty("java.protocol.handler.pkgs", "com.sun.identity.protocol");
    static boolean usingJSSEHandler = protHandlerPkg.equals("com.sun.identity.protocol");
    protected static Debug authDebug = Debug.getInstance((String)"amAuthContext");
    protected static ResourceBundle bundle = com.iplanet.am.util.Locale.getInstallResourceBundle("amAuthContext");
    Status loginStatus = Status.IN_PROGRESS;
    String organizationName = "";
    Document receivedDocument;
    AuthLoginException loginException = null;
    String hostName = null;
    private boolean forceAuth = false;
    private boolean localSessionChecked = false;
    String nickName = null;
    private URL authURL = null;
    private URL authServiceURL = null;
    private SSOToken ssoToken = null;
    private String ssoTokenID = null;
    private static SSOToken appSSOToken = null;
    AuthContextLocal acLocal = null;
    public boolean localFlag = false;
    public static String localAuthServiceID;
    static boolean useOldStyleRemoteAuthentication;
    static boolean useNewStyleRemoteAuthentication;
    private HashMap cookieTable = new HashMap();

    public AuthContext(String orgName) throws AuthLoginException {
        this.organizationName = orgName;
    }

    public AuthContext(String orgName, URL url) throws AuthLoginException {
        this.organizationName = orgName;
        this.authURL = url;
    }

    public AuthContext(String orgName, String nickName) throws AuthLoginException {
        this.organizationName = orgName;
        this.nickName = nickName;
    }

    public AuthContext(String orgName, String nickName, URL url) throws AuthLoginException {
        this.organizationName = orgName;
        this.nickName = nickName;
        this.authURL = url;
    }

    public AuthContext(SSOToken ssoToken) throws AuthLoginException {
        this.ssoToken = ssoToken;
    }

    public AuthContext(SSOToken ssoToken, boolean forceAuth) throws AuthLoginException {
        this.ssoToken = ssoToken;
        this.forceAuth = forceAuth;
    }

    public void login() throws AuthLoginException {
        this.login(null, null, null, false, null);
    }

    public void login(IndexType type, String indexName) throws AuthLoginException {
        this.login(type, indexName, null, false, null);
    }

    public void login(IndexType type, String indexName, boolean pCookieMode) throws AuthLoginException {
        this.login(type, indexName, null, pCookieMode, null);
    }

    public void login(IndexType type, String indexName, String locale) throws AuthLoginException {
        this.login(type, indexName, null, false, null, locale);
    }

    public SSOToken login(IndexType type, String indexName, Callback[] userInfo) throws AuthLoginException {
        this.login(type, indexName, null, false, null);
        SSOToken ssoToken = null;
        Callback[] callbacks = null;
        while (this.hasMoreRequirements()) {
            callbacks = this.getRequirements();
            if (callbacks == null) continue;
            try {
                this.submitRequirements(userInfo);
            }
            catch (Exception e) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("Error: submitRequirements with userInfo : " + e.getMessage());
                }
                throw new AuthLoginException(e);
            }
        }
        try {
            if (this.getStatus() == Status.SUCCESS) {
                ssoToken = this.getSSOToken();
            }
        }
        catch (Exception e) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Error: getSSOToken : " + e.getMessage());
            }
            throw new AuthLoginException(e);
        }
        return ssoToken;
    }

    public void login(IndexType indexType, String indexName, String[] params) throws AuthLoginException {
        this.login(indexType, indexName, params, false, null);
    }

    public void login(IndexType indexType, String indexName, String[] params, Map envMap) throws AuthLoginException {
        this.login(indexType, indexName, params, false, envMap);
    }

    private void login(IndexType indexType, String indexName, String[] params, boolean pCookie, Map envMap) throws AuthLoginException {
        if (this.clientLocale == null) {
            this.login(indexType, indexName, params, false, envMap, null);
        } else {
            String localeStr = this.clientLocale.toString();
            this.login(indexType, indexName, params, false, envMap, localeStr);
        }
    }

    private void login(IndexType indexType, String indexName, String[] params, boolean pCookie, Map envMap, String locale) throws AuthLoginException {
        if (this.ssoToken != null) {
            try {
                this.organizationName = this.ssoToken.getProperty("Organization");
                this.ssoTokenID = ((Object)this.ssoToken.getTokenID()).toString();
                this.authURL = Session.getSession(new SessionID(this.ssoTokenID)).getSessionServiceURL();
            }
            catch (Exception e) {
                throw new AuthLoginException(e);
            }
        }
        if (this.authURL != null) {
            this.authServiceURL = AuthContext.getAuthServiceURL(this.authURL.getProtocol(), this.authURL.getHost(), Integer.toString(this.authURL.getPort()), this.authURL.getPath());
        }
        AuthLoginException authException = null;
        try {
            if (this.authServiceURL == null) {
                this.authServiceURL = AuthContext.getAuthServiceURL(this.server_proto, this.server_host, this.server_port, this.server_uri);
            }
            if (this.authServiceURL != null) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("AuthContext.login : runLogin against " + this.authServiceURL);
                }
                this.runLogin(indexType, indexName, params, pCookie, envMap, locale);
                return;
            }
        }
        catch (AuthLoginException e) {
            authException = e;
            authDebug.error("Failed to login to " + this.authServiceURL);
        }
        catch (Exception e) {
            authDebug.error("Failed to login to " + this.authServiceURL + ": " + e.getMessage(), (Throwable)e);
        }
        if (this.authURL == null) {
            Vector serviceURLs = null;
            try {
                serviceURLs = WebtopNaming.getServiceAllURLs("auth");
            }
            catch (Exception e) {
                throw new AuthLoginException(amAuthContext, "loginError", new Object[]{e.getMessage()});
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Org Name : " + this.organizationName);
                authDebug.message("ssoTokenID: " + this.ssoTokenID);
                authDebug.message("serviceURLs: " + serviceURLs);
            }
            if (serviceURLs != null) {
                serviceURLs.remove(this.authServiceURL);
                Enumeration e = serviceURLs.elements();
                while (e.hasMoreElements()) {
                    this.authServiceURL = (URL)e.nextElement();
                    try {
                        this.runLogin(indexType, indexName, params, pCookie, envMap, locale);
                        return;
                    }
                    catch (AuthLoginException ex) {
                        authException = ex;
                        authDebug.error("Failed to login in failover with " + this.authServiceURL + ": " + ex.getMessage());
                    }
                }
            }
        }
        authDebug.error("Authentication failed.");
        if (authException != null) {
            throw authException;
        }
        throw new AuthLoginException(amAuthContext, "loginError", null);
    }

    private void runLogin(IndexType indexType, String indexName, String[] params, boolean pCookie, Map envMap, String locale) throws AuthLoginException {
        if (!this.localFlag) {
            this.setLocalFlag(this.authServiceURL);
        }
        if (appSSOToken == null) {
            if (indexType != IndexType.MODULE_INSTANCE || !indexName.equals("Application")) {
                block23: {
                    try {
                        appSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    }
                    catch (AMSecurityPropertiesException propExp) {
                        if (!authDebug.messageEnabled()) break block23;
                        authDebug.message("AuthContext.runLogin: Runtime Exception" + propExp.getMessage());
                        authDebug.message("AuthContext.runLogin: Not able to get appSSOToken, continuing without appSSOToken");
                    }
                }
                if (appSSOToken == null) {
                    authDebug.message("Null App SSO Token");
                }
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Obtained App Token= " + appSSOToken);
            }
        }
        if (this.localFlag) {
            try {
                if (this.ssoTokenID == null) {
                    this.acLocal = AuthUtils.getAuthContext(this.organizationName);
                } else {
                    if (authDebug.messageEnabled()) {
                        authDebug.message("AuthContext.runLogin: ForceAuth = " + this.forceAuth);
                    }
                    this.acLocal = AuthUtils.getAuthContext(this.organizationName, this.ssoTokenID, false, null, null, null, this.forceAuth);
                }
                this.acLocal.login(indexType, indexName, pCookie, envMap, locale);
            }
            catch (AuthException e) {
                throw new AuthLoginException((Throwable)((Object)e));
            }
            if (this.acLocal.getStatus().equals(Status.SUCCESS)) {
                this.onSuccessLocal();
            }
            return;
        }
        if (useOldStyleRemoteAuthentication) {
            this.runRemoteOldAuthContext();
            if (this.loginException != null) {
                throw this.loginException;
            }
        }
        this.runRemoteLogin(indexType, indexName, params, pCookie, envMap, locale);
        if (authDebug.messageEnabled()) {
            authDebug.message("useNewStyleRemoteAuthentication : " + useNewStyleRemoteAuthentication);
            authDebug.message("useOldStyleRemoteAuthentication : " + useOldStyleRemoteAuthentication);
            authDebug.message("receivedDocument : " + this.receivedDocument);
            authDebug.message("loginException : " + this.loginException);
        }
        if (!(useNewStyleRemoteAuthentication || useOldStyleRemoteAuthentication || this.receivedDocument != null && !this.getAuthenticationHandle(this.receivedDocument).equals("null") || this.loginException == null)) {
            if (authDebug.messageEnabled()) {
                authDebug.message("AuthContext: trying 6.3 style remote AuthN and setting the flag to use 6.3 style");
            }
            useOldStyleRemoteAuthentication = true;
            this.loginException = null;
            this.runRemoteOldAuthContext();
            if (this.loginException != null) {
                throw this.loginException;
            }
            this.runRemoteLogin(indexType, indexName, params, pCookie, envMap, locale);
        } else if (!useNewStyleRemoteAuthentication) {
            useNewStyleRemoteAuthentication = true;
        }
        if (this.loginException != null) {
            throw this.loginException;
        }
    }

    private void runRemoteLogin(IndexType indexType, String indexName, String[] params, boolean pCookie, Map envMap, String locale) throws AuthLoginException {
        try {
            String xmlString = null;
            StringBuffer request = new StringBuffer(100);
            Object[] authHandles = new String[]{this.getAuthHandle()};
            if (this.ssoTokenID != null && authHandles[0].equals("0")) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("AuthContext.runRemoteLogin: Found SSOTokenID " + this.ssoTokenID);
                }
                authHandles[0] = this.ssoTokenID;
            }
            request.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", authHandles));
            if (appSSOToken != null) {
                request.append("<AppSSOToken>");
                request.append(((Object)appSSOToken.getTokenID()).toString()).append("</AppSSOToken>");
            }
            request.append("<Login");
            if (!useOldStyleRemoteAuthentication) {
                request.append(" ").append("orgName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.organizationName)).append("\"");
                if (this.hostName != null) {
                    request.append(" ").append("hostName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.hostName)).append("\"");
                }
                if (locale != null && locale.length() > 0) {
                    request.append(" ").append("Locale").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)locale)).append("\"");
                }
                if (this.forceAuth) {
                    request.append(" ").append("forceAuth").append("=").append("\"").append("true").append("\"");
                }
            }
            request.append(">");
            if (indexType != null) {
                request.append("<IndexTypeNamePair").append(" ").append("indexType").append("=").append("\"");
                if (indexType == IndexType.USER) {
                    request.append("user");
                } else if (indexType == IndexType.ROLE) {
                    request.append("role");
                } else if (indexType == IndexType.SERVICE) {
                    request.append("service");
                } else if (indexType == IndexType.MODULE_INSTANCE) {
                    request.append("moduleInstance");
                } else if (indexType == IndexType.LEVEL) {
                    request.append("authLevel");
                } else if (indexType == IndexType.COMPOSITE_ADVICE) {
                    request.append("compositeAdvice");
                } else if (indexType == IndexType.RESOURCE) {
                    request.append("resource");
                }
                request.append("\"").append(">").append("<IndexName>").append(indexName).append("</IndexName>").append("</IndexTypeNamePair>");
            }
            if (locale != null && locale.length() > 0) {
                request.append("<Locale>");
                request.append(locale);
                request.append("</Locale>");
            }
            if (params != null) {
                StringBuffer paramString = new StringBuffer();
                for (int i = 0; i < params.length; ++i) {
                    if (i != 0) {
                        paramString.append("|");
                    }
                    paramString.append(params[i]);
                }
                request.append("<Params>").append(paramString.toString()).append("</Params>");
            }
            if (envMap != null && !envMap.isEmpty()) {
                StringBuffer envString = new StringBuffer();
                for (String keyName : envMap.keySet()) {
                    Set values = (Set)envMap.get(keyName);
                    if (values == null || values.isEmpty()) continue;
                    envString.append("<EnvValue>").append(AuthClientUtils.escapePipe(keyName));
                    Iterator iter = values.iterator();
                    while (iter.hasNext()) {
                        envString.append("|").append(AuthClientUtils.escapePipe(XMLUtils.escapeSpecialCharacters((String)((String)iter.next()))));
                    }
                    envString.append("</EnvValue>");
                }
                request.append("<Environment>").append(envString.toString()).append("</Environment>");
            }
            request.append("</Login>").append("</Request></AuthContext>");
            xmlString = request.toString();
            this.receivedDocument = this.processRequest(xmlString);
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException le) {
            this.loginStatus = Status.FAILED;
            this.loginException = le;
        }
    }

    private void runRemoteOldAuthContext() throws AuthLoginException {
        try {
            StringBuffer request = new StringBuffer(100);
            String[] objs = new String[]{"0"};
            if (this.ssoTokenID != null) {
                objs[0] = this.ssoTokenID;
            }
            request.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objs)).append("<NewAuthContext").append(" ").append("orgName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.organizationName)).append("\"").append(">").append("</NewAuthContext>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(request.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException le) {
            this.loginStatus = Status.FAILED;
            this.loginException = le;
        }
    }

    public Subject getSubject() {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.SUCCESS)) {
                return null;
            }
            return this.acLocal.getSubject();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            return null;
        }
        return AuthContext.getSubject(this.receivedDocument);
    }

    public Map getCookieTable() {
        return this.cookieTable;
    }

    public boolean hasMoreRequirements() {
        if (this.localFlag) {
            return this.acLocal.hasMoreRequirements(false);
        }
        return this.loginStatus.equals(Status.IN_PROGRESS) && AuthContext.getCallbacks(this.receivedDocument, false) != null;
    }

    public boolean hasMoreRequirements(boolean noFilter) {
        if (this.localFlag) {
            return this.acLocal.hasMoreRequirements(noFilter);
        }
        return this.loginStatus.equals(Status.IN_PROGRESS) && AuthContext.getCallbacks(this.receivedDocument, noFilter) != null;
    }

    public Callback[] getRequirements() {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.IN_PROGRESS)) {
                return null;
            }
            return this.acLocal.getRequirements(false);
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return null;
        }
        return AuthContext.getCallbacks(this.receivedDocument, false);
    }

    public Callback[] getRequirements(boolean noFilter) {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.IN_PROGRESS)) {
                return null;
            }
            return this.acLocal.getRequirements(noFilter);
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return null;
        }
        return AuthContext.getCallbacks(this.receivedDocument, noFilter);
    }

    public void submitRequirements(Callback[] info) {
        if (authDebug.messageEnabled()) {
            authDebug.message("submitRequirements with Callbacks : " + info);
        }
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.IN_PROGRESS)) {
                return;
            }
            this.acLocal.submitRequirements(info);
            if (this.acLocal.getStatus().equals(Status.SUCCESS)) {
                this.onSuccessLocal();
            }
            return;
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return;
        }
        try {
            StringBuffer xml = new StringBuffer(100);
            Object[] authHandles = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            xml.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", authHandles));
            if (appSSOToken != null) {
                xml.append("<AppSSOToken>");
                xml.append(((Object)appSSOToken.getTokenID()).toString()).append("</AppSSOToken>");
            }
            xml.append("<SubmitRequirements>").append(AuthXMLUtils.getXMLForCallbacks(info)).append("</SubmitRequirements>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(xml.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException le) {
            this.loginStatus = Status.FAILED;
            this.loginException = le;
        }
    }

    public void logout() throws AuthLoginException {
        if (this.localFlag) {
            this.acLocal.logout();
            return;
        }
        try {
            StringBuffer xml = new StringBuffer(100);
            Object[] authHandles = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            xml.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", authHandles));
            if (appSSOToken != null) {
                xml.append("<AppSSOToken>");
                xml.append(((Object)appSSOToken.getTokenID()).toString()).append("</AppSSOToken>");
            }
            xml.append("<Logout>").append("</Logout>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(xml.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException le) {
            this.loginStatus = Status.FAILED;
            this.loginException = le;
        }
    }

    public AuthLoginException getLoginException() {
        if (this.localFlag) {
            return this.acLocal.getLoginException();
        }
        return this.loginException;
    }

    public SSOToken getSSOToken() throws Exception {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.SUCCESS)) {
                throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
            }
            return this.acLocal.getSSOToken();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
        }
        Node loginStatusNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (loginStatusNode == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        String ssoTokenID = XMLUtils.getNodeAttributeValue((Node)loginStatusNode, (String)"ssoToken");
        try {
            return new SSOProviderImpl().createSSOToken(ssoTokenID, true);
        }
        catch (SSOException ssoe) {
            throw new L10NMessageImpl(amAuthContext, "createSSOTokenError", null);
        }
    }

    public Status getStatus() {
        if (this.localFlag) {
            return this.acLocal.getStatus();
        }
        return this.loginStatus;
    }

    public String getAuthIdentifier() {
        if (this.localFlag) {
            return this.acLocal.getAuthIdentifier();
        }
        return this.getAuthHandle();
    }

    public String getSuccessURL() throws Exception {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.SUCCESS)) {
                throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
            }
            return this.acLocal.getSuccessURL();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
        }
        Node loginStatusNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (loginStatusNode == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        return XMLUtils.getNodeAttributeValue((Node)loginStatusNode, (String)"successURL");
    }

    public String getFailureURL() throws Exception {
        if (this.localFlag) {
            return this.acLocal.getFailureURL();
        }
        Node loginStatusNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (loginStatusNode == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        return XMLUtils.getNodeAttributeValue((Node)loginStatusNode, (String)"failureURL");
    }

    public void reset() {
        this.loginStatus = Status.NOT_STARTED;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Set getModuleInstanceNames() {
        if (this.authURL != null) {
            this.authServiceURL = AuthContext.getAuthServiceURL(this.authURL.getProtocol(), this.authURL.getHost(), Integer.toString(this.authURL.getPort()), this.authURL.getPath());
        }
        if (!this.localFlag) {
            this.setLocalFlag(this.authServiceURL);
        }
        if (this.localFlag) {
            return this.acLocal.getModuleInstanceNames();
        }
        if (this.authServiceURL == null) {
            try {
                this.authServiceURL = AuthContext.getAuthServiceURL(this.server_proto, this.server_host, this.server_port, this.server_uri);
            }
            catch (Exception e) {
                return Collections.EMPTY_SET;
            }
        }
        this.sendQueryInformation("moduleInstanceNames");
        Node queryResultNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"QueryResult");
        if (queryResultNode == null) {
            return null;
        }
        HashSet<String> moduleInstanceNames = new HashSet<String>();
        NodeList childNodes = queryResultNode.getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String moduleName = XMLUtils.getValueOfValueNode((Node)childNode);
                moduleInstanceNames.add(moduleName);
            }
        }
        return moduleInstanceNames;
    }

    public void abort() throws AuthLoginException {
        if (this.localFlag) {
            this.acLocal.abort();
            return;
        }
        try {
            StringBuffer xml = new StringBuffer(100);
            Object[] authHandles = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            xml.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", authHandles));
            if (appSSOToken != null) {
                xml.append("<AppSSOToken>");
                xml.append(((Object)appSSOToken.getTokenID()).toString()).append("</AppSSOToken>");
            }
            xml.append("<Abort>").append("</Abort>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(xml.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException le) {
            this.loginStatus = Status.FAILED;
            this.loginException = le;
        }
    }

    public static void setCertDBPassword(String password) {
        try {
            if (usingJSSEHandler) {
                Class<?> pcbClass = Class.forName(JSSE_PASSWORD_CALLBACK);
                Object passwdCallback = pcbClass.newInstance();
                Method method = pcbClass.getMethod("setPassword", String.class);
                KeyStore keystore = (KeyStore)method.invoke(passwdCallback, password);
            } else {
                Class<?> initializer = Class.forName(JSS_PASSWORD_UTIL);
                Constructor<?> initializerConstructor = initializer.getConstructor(String.class);
                initializerConstructor.newInstance(password);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            authDebug.message("Error in setCertDBPassword : " + e.getMessage());
        }
    }

    public String getErrorTemplate() {
        if (this.localFlag) {
            return this.acLocal.getErrorTemplate();
        }
        String errTemplate = "";
        Node exceptionNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (exceptionNode != null) {
            errTemplate = XMLUtils.getNodeAttributeValue((Node)exceptionNode, (String)"templateName");
        }
        return errTemplate;
    }

    public String getErrorMessage() {
        if (this.localFlag) {
            return this.acLocal.getErrorMessage();
        }
        String errMessage = null;
        Node exceptionNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (exceptionNode != null) {
            errMessage = XMLUtils.getNodeAttributeValue((Node)exceptionNode, (String)"message");
        }
        return errMessage;
    }

    public String getErrorCode() {
        if (this.localFlag) {
            return this.acLocal.getErrorCode();
        }
        String errCode = "";
        Node exceptionNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (exceptionNode != null) {
            errCode = XMLUtils.getNodeAttributeValue((Node)exceptionNode, (String)"errorCode");
        }
        return errCode;
    }

    public void setClientHostName(String hostname) {
        this.hostName = hostname;
    }

    public String getClientHostName() {
        return this.hostName;
    }

    public void setLocale(Locale loc) {
        this.clientLocale = loc;
    }

    public Locale getLocale() {
        return this.clientLocale;
    }

    private AuthLoginException checkException() {
        AuthLoginException exception = null;
        String error = this.getErrorCode();
        if (error != null && error.length() != 0) {
            exception = new AuthLoginException("amAuth", error, null);
        } else {
            error = this.getErrorMessage();
            if (error != null && error.length() != 0) {
                exception = new AuthLoginException(error);
            }
        }
        return exception;
    }

    protected void checkAndSetLoginStatus() {
        Node loginStatusNode = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (loginStatusNode == null) {
            this.loginException = this.checkException();
        } else {
            String status = XMLUtils.getNodeAttributeValue((Node)loginStatusNode, (String)"status");
            if (status != null) {
                if (status.equals("success")) {
                    this.loginStatus = Status.SUCCESS;
                } else if (status.equals("failed")) {
                    this.loginStatus = Status.FAILED;
                    this.loginException = this.checkException();
                } else if (status.equals("completed")) {
                    this.loginStatus = Status.COMPLETED;
                } else if (status.equals("in_progress")) {
                    this.loginStatus = Status.IN_PROGRESS;
                }
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("LoginStatus : " + this.loginStatus);
            }
        }
    }

    protected void sendQueryInformation(String reqInfo) {
        try {
            StringBuffer xml = new StringBuffer(100);
            Object[] authHandles = new String[]{this.getAuthHandle()};
            xml.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", authHandles));
            if (appSSOToken != null) {
                xml.append("<AppSSOToken>");
                xml.append(((Object)appSSOToken.getTokenID()).toString()).append("</AppSSOToken>");
            }
            xml.append("<QueryInformation").append(" ").append("requestedInformation").append("=").append("\"").append(reqInfo).append("\"");
            if (((String)authHandles[0]).equals("0")) {
                xml.append(" ").append("orgName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.organizationName)).append("\"");
            }
            xml.append(">").append("</QueryInformation>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(xml.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException le) {
            this.loginStatus = Status.FAILED;
            this.loginException = le;
        }
    }

    private void setLocalFlag(URL url) {
        try {
            String urlStr = url.getProtocol() + "://" + url.getHost() + ":" + Integer.toString(url.getPort());
            if (authDebug.messageEnabled()) {
                authDebug.message("in setLocalFlag(), url : " + urlStr);
                authDebug.message("AuthContext.localAuthServiceID : " + localAuthServiceID);
            }
            if (localAuthServiceID != null && urlStr.equalsIgnoreCase(localAuthServiceID)) {
                this.localFlag = true;
            }
        }
        catch (Exception e) {
            authDebug.error("AuthContext::setLocalFlag:: " + e);
        }
    }

    protected Document processRequest(String xmlRequest) throws AuthLoginException {
        Document doc = null;
        try {
            Vector responses;
            Request request = new Request(xmlRequest);
            RequestSet set = new RequestSet("auth");
            set.addRequest(request);
            URL url = this.authServiceURL;
            if (url.getProtocol().equals("https") && this.nickName != null) {
                Class[] paramtype = new Class[]{String.class};
                Object[] param = new Object[]{this.nickName};
                String protHandler = protHandlerPkg + ".https.Handler";
                Constructor<?> construct = Class.forName(protHandler).getConstructor(paramtype);
                URLStreamHandler handler = (URLStreamHandler)construct.newInstance(param);
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), handler);
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Service URL : " + url.toString());
            }
            if ((responses = PLLClient.send(url, set, this.cookieTable)).isEmpty() || responses.size() != 1) {
                throw new L10NMessageImpl(amAuthContext, "responseError", null);
            }
            Response res = (Response)responses.elementAt(0);
            String responseStr = res.getContent();
            doc = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(responseStr.getBytes("UTF-8")));
        }
        catch (Exception e) {
            authDebug.message("error in getting service url", (Throwable)e);
            throw new AuthLoginException(amAuthContext, "xmlProcessError", null, e);
        }
        return doc;
    }

    protected static void checkForException(Document document) throws AuthLoginException {
        Node exceptionNode = XMLUtils.getRootNode((Document)document, (String)"Exception");
        if (exceptionNode != null) {
            throw new AuthLoginException(XMLUtils.getNodeAttributeValue((Node)exceptionNode, (String)"message"));
        }
    }

    protected String getAuthenticationHandle(Document document) throws AuthLoginException {
        Node responseNode = XMLUtils.getRootNode((Document)document, (String)"Response");
        if (responseNode == null) {
            throw new AuthLoginException(amAuthContext, "responseError", null);
        }
        String authID = XMLUtils.getNodeAttributeValue((Node)responseNode, (String)"authIdentifier");
        return authID;
    }

    protected static Callback[] getCallbacks(Document document, boolean noFilter) {
        return AuthXMLUtils.getCallbacks(XMLUtils.getRootNode((Document)document, (String)"Callbacks"), noFilter);
    }

    protected static Subject getSubject(Document document) {
        Node loginStatusNode = XMLUtils.getRootNode((Document)document, (String)"LoginStatus");
        if (loginStatusNode == null) {
            return null;
        }
        Node subjectNode = XMLUtils.getChildNode((Node)loginStatusNode, (String)"Subject");
        if (subjectNode == null) {
            return null;
        }
        String subject = XMLUtils.getValueOfValueNode((Node)subjectNode);
        try {
            Subject sSubject = AuthXMLUtils.getDeSerializedSubject(subject);
            if (authDebug.messageEnabled()) {
                authDebug.message("Deserialized subject : " + sSubject.toString());
            }
            return sSubject;
        }
        catch (Exception e) {
            authDebug.message("get Deserialized subject error : ", (Throwable)e);
            return null;
        }
    }

    protected static String getXMLforSubject(Subject subject) {
        if (subject == null) {
            return "";
        }
        StringBuffer request = new StringBuffer(100);
        request.append("<Subject>");
        String serializeSubject = AuthXMLUtils.getSerializedSubject(subject);
        request.append(serializeSubject);
        request.append("</Subject>");
        return request.toString();
    }

    public String getLockoutMsg() {
        String lockoutMsg = null;
        if (this.localFlag) {
            lockoutMsg = this.acLocal.getLockoutMsg();
        } else {
            lockoutMsg = this.getErrorMessage();
            if (lockoutMsg == null || lockoutMsg.indexOf("Account lockout") == -1) {
                lockoutMsg = "";
            }
        }
        return lockoutMsg;
    }

    public boolean isLockedOut() {
        boolean isLockedOut = false;
        if (this.localFlag) {
            isLockedOut = this.acLocal.isLockedOut();
        }
        return isLockedOut;
    }

    private String getAuthHandle() {
        String handle = null;
        if (this.receivedDocument != null) {
            try {
                handle = this.getAuthenticationHandle(this.receivedDocument);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (handle == null) {
            handle = "0";
        }
        return handle;
    }

    private static URL getAuthServiceURL(String protocol, String host, String port, String uri) {
        URL authservice = null;
        try {
            authservice = WebtopNaming.getServiceURL("auth", protocol, host, port, uri);
        }
        catch (Exception e) {
            authDebug.error("Failed to obtain auth service url from server: " + protocol + "://" + host + ":" + port);
        }
        return authservice;
    }

    private void onSuccessLocal() {
        if (this.localSessionChecked) {
            return;
        }
        SSOToken currToken = this.acLocal.getSSOToken();
        InternalSession oldSess = this.acLocal.getLoginState().getOldSession();
        if (oldSess != null) {
            if (this.forceAuth) {
                try {
                    SSOTokenManager.getInstance().destroyToken(currToken);
                }
                catch (SSOException ssoExp) {
                    authDebug.error("AuthContext.onSuccessLocal: ", (Throwable)((Object)ssoExp));
                }
                this.acLocal.getLoginState().setSession(oldSess);
                this.acLocal.getLoginState().setSid(oldSess.getID());
                this.acLocal.getLoginState().setForceAuth(false);
                this.ssoToken = this.acLocal.getSSOToken();
                this.ssoTokenID = ((Object)this.ssoToken.getTokenID()).toString();
            } else {
                SessionService.getSessionService().destroyInternalSession(oldSess.getID());
            }
        }
        this.localSessionChecked = true;
    }

    public static class IndexType {
        private String index;
        public static final IndexType USER = new IndexType("user");
        public static final IndexType ROLE = new IndexType("role");
        public static final IndexType SERVICE = new IndexType("service");
        public static final IndexType LEVEL = new IndexType("level");
        public static final IndexType MODULE_INSTANCE = new IndexType("module_instance");
        public static final IndexType RESOURCE = new IndexType("resource");
        public static final IndexType COMPOSITE_ADVICE = new IndexType("composite_advice");

        private IndexType() {
        }

        private IndexType(String s) {
            this.index = s;
        }

        public String toString() {
            return this.index;
        }

        public boolean equals(Object indexType) {
            if (indexType instanceof IndexType) {
                IndexType s = (IndexType)indexType;
                return s.index.equalsIgnoreCase(this.index);
            }
            return false;
        }
    }

    public static class Status {
        private String status;
        public static final Status NOT_STARTED = new Status("not_started");
        public static final Status IN_PROGRESS = new Status("in_progress");
        public static final Status SUCCESS = new Status("success");
        public static final Status FAILED = new Status("failed");
        public static final Status COMPLETED = new Status("completed");
        public static final Status RESET = new Status("reset");
        public static final Status ORG_MISMATCH = new Status("org_mismatch");

        private Status() {
        }

        private Status(String s) {
            this.status = s;
        }

        public String toString() {
            return this.status;
        }

        public boolean equals(Object authStatus) {
            if (authStatus instanceof Status) {
                Status s = (Status)authStatus;
                return s.status.equalsIgnoreCase(this.status);
            }
            return false;
        }
    }
}

