/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.UI;

import com.iplanet.am.util.Locale;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.UI.AuthViewBeanBase;
import com.sun.identity.authentication.jaas.LoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessage;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogoutViewBean
extends AuthViewBeanBase {
    public static final String PAGE_NAME = "Logout";
    static Debug logoutDebug = Debug.getInstance((String)"amLogoutViewBean");
    String localeName = null;
    String orgDN = null;
    AuthContext.IndexType indexType = null;
    String indexName = null;
    HttpServletRequest request;
    HttpServletResponse response;
    public String ResultVal = "";
    public String gotoUrl = "";
    public String jsp_page = "";
    private static String LOGINURL = "";
    private String loginURL = "";
    public ResourceBundle rb = null;
    private static final String LOGOUTCOOKIEVAULE = "LOGOUT";
    private String logoutCookie = null;
    private boolean cookieSupported;
    public static final String URL_LOGIN = "urlLogin";
    public static final String TXT_LOGOUT = "txtLogout";
    public static final String TXT_GOTO_LOGIN_AFTER_LOGOUT = "txtGotoLoginAfterLogout";
    public static final String HTML_TITLE_LOGOUT = "htmlTitle_Logout";
    private String clientType = null;
    private static final String LOGOUT_JSP = "Logout.jsp";
    private static final String LOGIN_JSP = "Login.jsp";

    public LogoutViewBean() {
        super(PAGE_NAME);
        logoutDebug.message("LogoutViewBean() constructor called");
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(URL_LOGIN, StaticTextField.class);
        this.registerChild(TXT_LOGOUT, StaticTextField.class);
        this.registerChild(TXT_GOTO_LOGIN_AFTER_LOGOUT, StaticTextField.class);
    }

    public void forwardTo(RequestContext requestContext) {
        boolean isTokenValid;
        java.util.Locale locale;
        SSOToken token;
        SessionID sessionID;
        block65: {
            Cookie[] cookieArr;
            InternalSession intSess;
            block64: {
                sessionID = null;
                token = null;
                intSess = null;
                locale = null;
                logoutDebug.message("In forwardTo()");
                if (requestContext != null) {
                    this.request = requestContext.getRequest();
                    this.response = requestContext.getResponse();
                }
                this.response.setHeader("Pragma", "no-cache");
                this.response.setHeader("Expires", "0");
                this.gotoUrl = this.request.getParameter("goto");
                if (logoutDebug.messageEnabled()) {
                    logoutDebug.message("Goto query param : " + this.gotoUrl);
                }
                try {
                    sessionID = new SessionID(this.request);
                    intSess = AuthD.getSession(sessionID);
                    if (intSess != null) {
                        this.populateL10NFileAttrs(intSess);
                        String localeStr = intSess.getProperty("Locale");
                        this.fallbackLocale = locale = Locale.getLocale(localeStr);
                    } else {
                        ISLocaleContext localeContext = new ISLocaleContext();
                        localeContext.setLocale(this.request);
                        locale = localeContext.getLocale();
                        if (locale == null) {
                            String localeStr = AuthD.getAuth().getPlatformLocale();
                            locale = Locale.getLocale(localeStr);
                        }
                    }
                    this.rb = rbCache.getResBundle("amAuthUI", locale);
                    this.clientType = AuthUtils.getClientType(this.request);
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("clienttype is : " + this.clientType);
                    }
                    token = SSOTokenManager.getInstance().createSSOToken(sessionID.toString());
                }
                catch (Exception e) {
                    this.ResultVal = this.getL10NMessage(e, locale);
                }
                if (token != null) {
                    try {
                        this.loginURL = token.getProperty("FullLoginURL");
                    }
                    catch (SSOException ssoExp) {
                        if (!logoutDebug.messageEnabled()) break block64;
                        logoutDebug.message("LogoutViewBean.forwardTo:  Cannot get Login URL");
                    }
                }
            }
            this.cookieSupported = (cookieArr = this.request.getCookies()) != null && cookieArr.length != 0;
            if (this.cookieSupported) {
                logoutDebug.message("Cookie is supported");
                AuthUtils.clearAllCookies(this.request, this.response);
            } else {
                logoutDebug.message("Cookie is not supported");
                if (sessionID != null && sessionID.toString().length() != 0) {
                    this.logoutCookie = AuthUtils.getLogoutCookieString(sessionID);
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Logout Cookie is " + this.logoutCookie);
                    }
                }
            }
            this.jsp_page = this.appendLogoutCookie(this.getFileName(LOGOUT_JSP));
            if (intSess != null && intSess.isTimedOut()) {
                try {
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Goto Login URL : " + this.loginURL);
                    }
                    if (this.doSendRedirect(this.loginURL)) {
                        this.response.sendRedirect(this.appendLogoutCookie(this.loginURL));
                        return;
                    }
                    int queryIndex = this.loginURL.indexOf("?");
                    String qString = null;
                    if (queryIndex != -1) {
                        qString = this.loginURL.substring(queryIndex);
                    }
                    this.jsp_page = qString != null ? this.appendLogoutCookie(this.getFileName(LOGIN_JSP) + qString) : this.appendLogoutCookie(this.getFileName(LOGIN_JSP));
                }
                catch (Exception e) {
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Redirect failed : " + this.loginURL, (Throwable)e);
                    }
                    this.ResultVal = this.getL10NMessage(e, locale);
                }
                super.forwardTo(requestContext);
                return;
            }
            Object loginContext = null;
            if (intSess != null) {
                loginContext = intSess.getObject("sunAMAuthLoginContext");
            }
            try {
                if (loginContext != null) {
                    if (loginContext instanceof javax.security.auth.login.LoginContext) {
                        javax.security.auth.login.LoginContext lc = (javax.security.auth.login.LoginContext)loginContext;
                        lc.logout();
                    } else {
                        LoginContext jlc = (LoginContext)loginContext;
                        jlc.logout();
                    }
                }
            }
            catch (LoginException loginExp) {
                logoutDebug.error("LogoutViewBean.forwardTo:  Cannot Execute module Logout", (Throwable)loginExp);
            }
            Set postAuthSet = null;
            if (intSess != null) {
                postAuthSet = (Set)intSess.getObject("sunAMAuthPostProcessInstanceSet");
            }
            if (postAuthSet != null && !postAuthSet.isEmpty()) {
                AMPostAuthProcessInterface postLoginInstance = null;
                Iterator iter = postAuthSet.iterator();
                while (iter.hasNext()) {
                    try {
                        postLoginInstance = (AMPostAuthProcessInterface)iter.next();
                        postLoginInstance.onLogout(this.request, this.response, token);
                    }
                    catch (Exception exp) {
                        logoutDebug.error("LogoutViewBean.forwardTo: Failed in post logout.", (Throwable)exp);
                    }
                }
            } else {
                String plis = null;
                if (intSess != null) {
                    plis = intSess.getProperty("PostAuthProcessInstance");
                }
                if (plis != null && plis.length() > 0) {
                    StringTokenizer st = new StringTokenizer(plis, "|");
                    if (token != null) {
                        while (st.hasMoreTokens()) {
                            String pli = st.nextToken();
                            try {
                                AMPostAuthProcessInterface postProcess = (AMPostAuthProcessInterface)Thread.currentThread().getContextClassLoader().loadClass(pli).newInstance();
                                AuthUtils.resetPostProcessURLs(this.request);
                                postProcess.onLogout(this.request, this.response, token);
                                String postProcessURL = AuthUtils.getPostProcessURL(this.request, "PostProcessLogoutURL");
                                if (postProcessURL == null) continue;
                                this.gotoUrl = postProcessURL;
                            }
                            catch (Exception e) {
                                logoutDebug.error("Failed in post logout process of " + pli, (Throwable)e);
                            }
                        }
                    }
                }
            }
            isTokenValid = false;
            try {
                isTokenValid = SSOTokenManager.getInstance().isValidToken(token);
            }
            catch (SSOException ssoExp) {
                if (!logoutDebug.messageEnabled()) break block65;
                logoutDebug.message("LogoutViewBean.forwardTo:  SSOException checking validity of SSO Token");
            }
        }
        if (token != null && isTokenValid) {
            try {
                AuthD.getAuth().logLogout(token);
                Session session = Session.getSession(sessionID);
                session.logout();
                logoutDebug.message("logout successful.");
                this.ResultVal = this.rb.getString("logout.successful");
            }
            catch (SessionException se) {
                try {
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Exception during logout", (Throwable)((Object)se));
                        logoutDebug.message("Goto Login URL : " + LOGINURL);
                    }
                    if (this.doSendRedirect(LOGINURL)) {
                        this.response.sendRedirect(this.appendLogoutCookie(LOGINURL));
                        return;
                    }
                    this.jsp_page = this.appendLogoutCookie(this.getFileName(LOGIN_JSP));
                }
                catch (Exception e) {
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Redirect failed:" + LOGINURL, (Throwable)e);
                    }
                    this.ResultVal = e.getMessage();
                }
                super.forwardTo(requestContext);
                return;
            }
        }
        if (!this.isGotoSet()) {
            String originalRedirectURL = AuthUtils.getOrigRedirectURL(this.request, sessionID);
            if (originalRedirectURL != null) {
                try {
                    int index;
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Original Redirect URL: " + originalRedirectURL);
                    }
                    if ((index = originalRedirectURL.indexOf("/Login")) != -1) {
                        originalRedirectURL = originalRedirectURL.substring(0, index) + "/Logout";
                    }
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Redirect to Original Redirect URL :" + originalRedirectURL);
                    }
                    if (this.doSendRedirect(originalRedirectURL)) {
                        this.response.sendRedirect(this.appendLogoutCookie(originalRedirectURL));
                        return;
                    }
                }
                catch (Exception e) {
                    this.ResultVal = this.getL10NMessage(e, locale);
                }
            } else {
                try {
                    if (logoutDebug.messageEnabled()) {
                        logoutDebug.message("Goto LOGINURL : " + LOGINURL);
                    }
                    if (this.doSendRedirect(LOGINURL)) {
                        this.response.sendRedirect(this.appendLogoutCookie(LOGINURL));
                        return;
                    }
                    this.jsp_page = this.appendLogoutCookie(this.getFileName(LOGIN_JSP));
                }
                catch (Exception e) {
                    this.ResultVal = this.getL10NMessage(e, locale);
                }
            }
        }
        if (!this.redirectToGoto(locale)) {
            super.forwardTo(requestContext);
        }
    }

    private void populateL10NFileAttrs(InternalSession intSess) {
        if (intSess != null) {
            this.localeName = intSess.getProperty("Locale");
            this.orgDN = intSess.getClientDomain();
            String serviceName = intSess.getProperty("Service");
            if (serviceName != null && serviceName.length() != 0) {
                this.indexType = AuthContext.IndexType.SERVICE;
                this.indexName = serviceName;
            }
        }
    }

    private String getFileName(String fileName) {
        String relativeFileName = null;
        relativeFileName = this.orgDN != null ? AuthUtils.getFileName(fileName, this.localeName, this.orgDN, this.request, AuthD.getAuth().getServletContext(), this.indexType, this.indexName) : AuthUtils.getDefaultFileName(this.request, fileName);
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("fileName is : " + fileName);
            logoutDebug.message("relativeFileName is : " + relativeFileName);
        }
        return relativeFileName;
    }

    public String getDisplayURL() {
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("In getDisplayURL() jsp_page " + this.jsp_page);
        }
        return this.jsp_page;
    }

    protected View createChild(String name) {
        if (logoutDebug.messageEnabled()) {
            logoutDebug.message("In createChild() : child name = " + name);
        }
        if (name.equals(TXT_LOGOUT)) {
            return new StaticTextField((ContainerView)this, name, (Object)this.ResultVal);
        }
        if (name.equals(TXT_GOTO_LOGIN_AFTER_LOGOUT)) {
            return new StaticTextField((ContainerView)this, name, (Object)"");
        }
        if (name.equals(URL_LOGIN)) {
            if (this.loginURL == null || this.loginURL.length() == 0) {
                this.loginURL = LOGINURL;
            }
            this.loginURL = this.appendLogoutCookie(this.loginURL);
            return new StaticTextField((ContainerView)this, name, (Object)this.loginURL);
        }
        if (name.equals(HTML_TITLE_LOGOUT)) {
            String logoutTitle = this.rb.getString(HTML_TITLE_LOGOUT);
            return new StaticTextField((ContainerView)this, name, (Object)logoutTitle);
        }
        return super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        logoutDebug.message("In beginDisplay()");
        this.setPageEncoding(this.request, this.response);
    }

    private String appendLogoutCookie(String url) {
        return AuthUtils.addLogoutCookieToURL(url, this.logoutCookie, this.cookieSupported);
    }

    private boolean doSendRedirect(String redirectURL) {
        return redirectURL != null && redirectURL.length() != 0 && AuthUtils.isGenericHTMLClient(this.clientType);
    }

    private boolean isGotoSet() {
        return this.gotoUrl != null && this.gotoUrl.length() != 0;
    }

    private boolean redirectToGoto(java.util.Locale locale) {
        if (this.isGotoSet()) {
            if (logoutDebug.messageEnabled()) {
                logoutDebug.message("Redirect to 'goto' URL : " + this.gotoUrl);
            }
            try {
                if (this.doSendRedirect(this.gotoUrl)) {
                    this.response.sendRedirect(this.appendLogoutCookie(this.gotoUrl));
                    return true;
                }
            }
            catch (Exception e) {
                if (logoutDebug.messageEnabled()) {
                    logoutDebug.message("'goto' Redirect failed : " + this.gotoUrl, (Throwable)e);
                }
                this.ResultVal = this.getL10NMessage(e, locale);
            }
        }
        return false;
    }

    public void handleHrefLogoutRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.forwardTo();
    }

    public boolean beginHrefLogoutDisplay(ChildDisplayEvent event) {
        return true;
    }

    public boolean beginContentHrefLogoutDisplay(ChildDisplayEvent event) {
        this.setDisplayFieldValue(TXT_GOTO_LOGIN_AFTER_LOGOUT, this.rb.getString("gotoLoginAfterLogout"));
        return true;
    }

    public boolean beginStaticTextLogoutDisplay(ChildDisplayEvent event) {
        return true;
    }

    public String getTileIndex() {
        return "";
    }

    public boolean beginContentStaticTextLogoutDisplay(ChildDisplayEvent event) {
        return true;
    }

    private String getL10NMessage(Exception e, java.util.Locale locale) {
        if (e instanceof L10NMessage) {
            return ((L10NMessage)e).getL10NMessage(locale);
        }
        return e.getMessage();
    }

    static {
        LOGINURL = serviceUri + "/UI/Login";
    }
}

