/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;

public class AuthXMLResponse {
    String authErrorCode;
    String authErrorMessage;
    String authErrorTemplate;
    String authURL;
    static Debug debug;
    String tokenId = null;
    AuthContextLocal authContext = null;
    AuthContext.Status loginStatus = AuthContext.Status.IN_PROGRESS;
    String errorCode = null;
    String errorMessage = null;
    String errorTemplate = null;
    String loginURL = null;
    Callback[] reqdCallbacks;
    int requestType;
    String successURL = null;
    String failureURL = null;
    boolean isException = false;
    SSOToken ssoToken = null;
    SSOTokenID ssoTokenID = null;
    String authIdentifier;
    String prevAuthIdentifier;
    Set moduleNames = new HashSet();
    InternalSession oldSession = null;
    boolean validSessionNoUpgrade = false;
    AuthXMLRequest authXMLReq = null;

    public AuthXMLResponse(int requestType) {
        debug = Debug.getInstance((String)"amXMLHandler");
        this.requestType = requestType;
    }

    public void setErrorCode(String errorCode) {
        try {
            this.errorCode = errorCode;
            this.authErrorMessage = AuthUtils.getErrorMessage(errorCode);
            this.authErrorTemplate = AuthUtils.getErrorTemplate(errorCode);
            if (debug.messageEnabled()) {
                debug.message("Auth error message " + this.authErrorMessage);
                debug.message("Auth error template" + this.authErrorTemplate);
            }
            this.loginStatus = AuthContext.Status.FAILED;
        }
        catch (Exception e) {
            debug.message("error : ", (Throwable)e);
        }
    }

    public void setErrorMessage(String msg) {
        this.authErrorMessage = msg;
    }

    public void setErrorTemplate(String template) {
        this.authErrorTemplate = template;
    }

    public void setFailureURL(String failureURL) {
        this.failureURL = failureURL;
    }

    public void setLoginStatus(AuthContext.Status loginStatus) {
        this.loginStatus = loginStatus;
    }

    public void setReqdCallbacks(Callback[] reqdCallbacks) {
        this.reqdCallbacks = reqdCallbacks;
    }

    public String createXMLErrorString() {
        StringBuffer errorXMLString = new StringBuffer();
        errorXMLString.append("<Exception").append(" ");
        if (this.authErrorMessage != null) {
            errorXMLString.append("message").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.authErrorMessage)).append("\"").append(" ");
        }
        if (this.tokenId != null) {
            errorXMLString.append("tokenId").append("=").append("\"").append(this.tokenId).append("\"");
        }
        if (this.errorCode != null) {
            errorXMLString.append(" ").append("errorCode").append("=").append("\"").append(this.errorCode).append("\"");
        }
        if (this.authErrorTemplate != null) {
            errorXMLString.append(" ").append("templateName").append("=").append("\"").append(this.authErrorTemplate).append("\"");
        }
        errorXMLString.append(">").append("</Exception>");
        String errorString = errorXMLString.toString();
        if (debug.messageEnabled()) {
            debug.message("Error Response String : " + errorString);
        }
        return errorString;
    }

    String createLoginStatusString() {
        debug.message("in createLoginStatusSTring");
        StringBuffer statusString = new StringBuffer();
        String status = this.loginStatus.toString();
        statusString.append("<LoginStatus");
        if (status != null) {
            statusString.append(" ").append("status").append("=").append("\"").append(status).append("\"");
        }
        if (this.loginStatus == AuthContext.Status.SUCCESS) {
            String sessionID = null;
            if (this.validSessionNoUpgrade) {
                sessionID = this.authXMLReq.getAuthIdentifier();
            } else {
                this.setSSOToken();
            }
            if (this.ssoToken != null) {
                this.ssoTokenID = this.ssoToken.getTokenID();
                if (debug.messageEnabled()) {
                    debug.message("ssoTokenID is : " + ((Object)this.ssoTokenID).toString());
                }
            }
            if (this.ssoTokenID != null || sessionID != null) {
                statusString.append(" ").append("ssoToken").append("=").append("\"");
                if (this.validSessionNoUpgrade) {
                    statusString.append(sessionID);
                } else {
                    statusString.append(((Object)this.ssoTokenID).toString());
                }
                statusString.append("\"");
            }
            if (this.validSessionNoUpgrade) {
                try {
                    SSOToken ssot = SSOTokenManager.getInstance().createSSOToken(sessionID);
                    this.successURL = ssot.getProperty("successURL");
                }
                catch (SSOException ssoExp) {
                    debug.error("AuthXMLResponse.createLoginStatusString:" + ssoExp.getMessage());
                }
            } else {
                this.successURL = AuthUtils.getLoginSuccessURL(this.authContext);
            }
            if (this.successURL != null) {
                statusString.append(" ").append("successURL").append("=").append("\"").append(this.successURL).append("\"");
            }
            Subject subject = null;
            subject = this.validSessionNoUpgrade ? this.authXMLReq.getSubject() : this.authContext.getSubject();
            if (debug.messageEnabled()) {
                debug.message("Subject is : " + subject);
            }
            String serializedSubject = AuthXMLUtils.getSerializedSubject(subject);
            if (debug.messageEnabled()) {
                debug.message("serialized Subject is : " + serializedSubject);
            }
            statusString.append(">").append("<Subject>").append(serializedSubject).append("</Subject>");
        } else if (this.loginStatus == AuthContext.Status.FAILED) {
            this.failureURL = AuthUtils.getLoginFailedURL(this.authContext);
            if (this.failureURL != null) {
                statusString.append(" ").append("failureURL").append("=").append("\"").append(this.failureURL).append("\"");
            }
            statusString.append(">");
        } else {
            statusString.append(">");
        }
        statusString.append("</LoginStatus>");
        String statusXMLString = statusString.toString();
        if (debug.messageEnabled()) {
            debug.message("LoginStatus XML STring : " + statusXMLString);
        }
        return statusXMLString;
    }

    public String toXMLString() {
        try {
            StringBuffer xmlString = new StringBuffer();
            String[] authIdentifierArray = new String[]{this.authIdentifier};
            if (debug.messageEnabled()) {
                debug.message("New authIdentifier : " + this.authIdentifier);
                debug.message("Returning authIdentifier : " + authIdentifierArray[0]);
            }
            xmlString.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Response authIdentifier=\"{0}\">", authIdentifierArray));
            if (debug.messageEnabled()) {
                debug.message("Request type is : " + this.requestType);
            }
            switch (this.requestType) {
                case 0: {
                    if (this.loginStatus == AuthContext.Status.FAILED || this.isException) {
                        xmlString.append(this.createXMLErrorString());
                        AuthUtils.destroySession(this.authContext);
                        break;
                    }
                    if (this.loginStatus == AuthContext.Status.SUCCESS) {
                        xmlString.append(this.createLoginStatusString());
                        debug.message("destroying old session");
                        if (this.oldSession == null) break;
                        AuthD authD = AuthD.getAuth();
                        authD.destroySession(this.oldSession.getID());
                        break;
                    }
                    xmlString.append(this.createLoginStatusString());
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 8: {
                    if (this.validSessionNoUpgrade) {
                        debug.message("Session is Valid and does not need update. Returning success.");
                        this.loginStatus = AuthContext.Status.SUCCESS;
                        xmlString.append(this.createLoginStatusString());
                        break;
                    }
                    if (this.reqdCallbacks != null) {
                        String xmlCallback = AuthXMLUtils.getXMLForCallbacks(this.reqdCallbacks);
                        xmlString.append("<GetRequirements>");
                        xmlString.append(xmlCallback);
                        xmlString.append("</GetRequirements>");
                        break;
                    }
                    if (this.loginStatus == AuthContext.Status.FAILED || this.isException) {
                        xmlString.append(this.createLoginStatusString());
                        xmlString.append(this.createXMLErrorString());
                        AuthUtils.destroySession(this.authContext);
                        break;
                    }
                    if (this.loginStatus != AuthContext.Status.SUCCESS) break;
                    if (this.oldSession != null) {
                        AuthD authD = AuthD.getAuth();
                        if (this.authContext.getLoginState().getForceFlag()) {
                            authD.destroySession(this.authContext.getLoginState().getSid());
                            this.authContext.getLoginState().setSession(this.oldSession);
                            this.authContext.getLoginState().setSid(this.oldSession.getID());
                            this.authContext.getLoginState().setForceAuth(false);
                        } else {
                            if (debug.messageEnabled()) {
                                debug.message("AuthXMLResponse.toXMLString : destroying old session");
                            }
                            authD.destroySession(this.oldSession.getID());
                        }
                    }
                    xmlString.append(this.createLoginStatusString());
                    break;
                }
                case 3: {
                    if (this.isException) {
                        xmlString.append(this.createXMLErrorString());
                        break;
                    }
                    xmlString.append(this.getXMLForQueryInfo());
                    break;
                }
                case 4: 
                case 5: {
                    if (this.isException) {
                        xmlString.append(this.createXMLErrorString());
                        break;
                    }
                    xmlString.append(this.createLoginStatusString());
                }
            }
            xmlString.append("</Response></AuthContext>");
            return xmlString.toString();
        }
        catch (Exception e) {
            debug.message("Exceiton in toXMLString : ", (Throwable)e);
            return null;
        }
    }

    public void setAuthContext(AuthContextLocal authContext) {
        this.authContext = authContext;
    }

    public void setIsException(boolean isException) {
        this.isException = isException;
    }

    public void setAuthIdentifier(String authIdentifier) {
        this.authIdentifier = authIdentifier;
    }

    public void setModuleNames(Set moduleNames) {
        this.moduleNames = moduleNames;
    }

    public String getXMLForQueryInfo() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<QueryResult").append(" ").append("requestedInformation").append("=").append("\"").append("moduleInstanceNames").append("\"").append(">");
        if (!this.moduleNames.isEmpty()) {
            for (String moduleName : this.moduleNames) {
                xmlString.append("<Value>").append(moduleName).append("</Value>");
            }
        }
        xmlString.append("</QueryResult>");
        String queryResult = xmlString.toString();
        if (debug.messageEnabled()) {
            debug.message("Query Result : " + queryResult);
        }
        return queryResult;
    }

    public void setSSOToken() {
        if (this.authContext != null) {
            this.ssoToken = this.authContext.getSSOToken();
        }
        if (debug.messageEnabled()) {
            debug.message("ssoToken is: " + this.ssoToken);
        }
    }

    public void setOldSession(InternalSession aOldSession) {
        this.oldSession = aOldSession;
    }

    public void setValidSessionNoUpgrade(boolean aValidSessionNoUpgrade) {
        this.validSessionNoUpgrade = aValidSessionNoUpgrade;
    }

    public void setAuthXMLRequest(AuthXMLRequest authXMLReq) {
        this.authXMLReq = authXMLReq;
    }
}

