/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;

public class AuthConfigMonitor
implements ServiceListener {
    ServiceSchemaManager schemaManager = null;
    static Debug debug;

    protected AuthConfigMonitor(ServiceSchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        String schemaName = schemaManager.getName();
        debug = Debug.getInstance((String)"amAuth");
        this.addServiceListener(schemaName);
    }

    public void schemaChanged(String serviceName, String version) {
        block10: {
            if (debug.messageEnabled()) {
                debug.message("Global config changed " + serviceName);
            }
            try {
                AuthD authd = AuthD.getAuth();
                if (serviceName.equals("iPlanetAMAuthService")) {
                    authd.updateAuthServiceGlobals(this.schemaManager);
                } else if (serviceName.equals("iPlanetAMAuthConfiguration")) {
                    authd.updateAuthConfigGlobals(this.schemaManager);
                } else if (serviceName.equals("iPlanetAMPlatformService")) {
                    authd.updatePlatformServiceGlobals(this.schemaManager);
                } else if (serviceName.equals("iPlanetAMSessionService")) {
                    authd.updateSessionServiceDynamics(this.schemaManager);
                }
            }
            catch (Exception e) {
                debug.error("Error schemaChanged : " + e.getMessage());
                if (!debug.messageEnabled()) break block10;
                debug.message("Stack trace: ", (Throwable)e);
            }
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    void addServiceListener(String service) {
        block2: {
            debug.message("Adding service listener");
            try {
                this.schemaManager.addListener(this);
            }
            catch (Exception ee) {
                debug.error("addServiceListener: " + ee.getMessage());
                if (!debug.messageEnabled()) break block2;
                debug.message("Stack trace:", (Throwable)ee);
            }
        }
    }
}

