/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthThreadManager;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStateCallback;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DSAMECallbackHandler
implements CallbackHandler {
    static Debug debug = Debug.getInstance((String)"amCallback");
    AMLoginContext am;
    LoginState loginState;
    Callback[] submitRequiredInfo = null;
    static AuthThreadManager authThreadManager;
    String sid = null;

    public DSAMECallbackHandler(AMLoginContext am) {
        this.am = am;
        authThreadManager = AMLoginContext.authThread;
        this.loginState = am.getLoginState();
    }

    private void setPageTimeout(Callback[] callbacks) {
        long pageTimeOut = this.getTimeOut(callbacks);
        this.loginState.setPageTimeOut(pageTimeOut);
        long lastCallbackSent = System.currentTimeMillis();
        this.loginState.setLastCallbackSent(lastCallbackSent);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (debug.messageEnabled()) {
            debug.message("callback handler method");
        }
        if (callbacks.length == 1 && callbacks[0] instanceof LoginStateCallback) {
            debug.message("LoginState Callbacks");
            ((LoginStateCallback)callbacks[0]).setLoginState(this.loginState);
        } else {
            if (this.am.isPureJAAS()) {
                this.setPageTimeout(callbacks);
                this.loginState.setSubmittedCallback(null, this.am);
                this.loginState.setReceivedCallback(callbacks, this.am);
                Thread thread = Thread.currentThread();
                if (debug.messageEnabled()) {
                    debug.message("waiting for submitted info " + thread);
                }
                callbacks = this.am.submitCallbackInfo();
                if (authThreadManager.isTimedOut(thread)) {
                    this.loginState.setTimedOut(true);
                    this.loginState.setReceivedCallback(null, this.am);
                    authThreadManager.removeFromHash(thread, "timedOutHash");
                    throw new IOException("110");
                }
                this.checkLoginTimeout();
            } else if (this.loginState.getSubmittedInfo() != null) {
                debug.message("DSAMEHandler: found submitted callbacks !");
                this.checkLoginTimeout();
                Callback[] callbacks2 = this.loginState.getSubmittedInfo();
                this.copyCallbacks(callbacks, callbacks2);
                this.loginState.setReceivedCallback_NoThread(null);
            } else {
                this.setPageTimeout(callbacks);
                this.loginState.setReceivedCallback_NoThread(callbacks);
                debug.message("Set callbacks, throwing java.lang.Error.");
                throw new Error("return from DSAMECallback");
            }
            if (debug.messageEnabled()) {
                debug.message("DSAMECAllbackhandler..." + callbacks);
            }
            if (this.am.isPureJAAS()) {
                this.loginState.setReceivedCallback(null, this.am);
            }
        }
    }

    private void copyCallbacks(Callback[] cb1, Callback[] cb2) {
        int len1 = cb1.length;
        int len2 = cb2.length;
        if (len1 == len2) {
            for (int m = 0; m < len1; ++m) {
                if (cb1[m] == cb2[m]) continue;
                cb1[m] = cb2[m];
            }
        } else {
            int indx1 = 0;
            int indx2 = 0;
            while (cb1[indx1] instanceof PagePropertiesCallback) {
                ++indx1;
            }
            while (cb2[indx2] instanceof PagePropertiesCallback) {
                ++indx2;
            }
            int n = len1 - indx1;
            if (n > len2 - indx2) {
                n = len2 - indx2;
            }
            for (int m = 0; m < n; ++m) {
                if (cb1[indx1] != cb2[indx2]) {
                    cb1[indx1] = cb2[indx2];
                }
                ++indx1;
                ++indx2;
            }
        }
    }

    long getTimeOut(Callback[] callbacks) {
        long pageTimeOut = 60L;
        if (callbacks != null && callbacks[0] instanceof PagePropertiesCallback) {
            PagePropertiesCallback pagePropertyCallback = (PagePropertiesCallback)callbacks[0];
            pageTimeOut = new Integer(pagePropertyCallback.getTimeOutValue()).longValue();
        }
        return pageTimeOut;
    }

    void checkLoginTimeout() throws IOException {
        long now;
        long pageTimeOut;
        long lastCallbackSent = this.loginState.getLastCallbackSent();
        if (lastCallbackSent + ((pageTimeOut = this.loginState.getPageTimeOut()) - 3L) * 1000L < (now = System.currentTimeMillis())) {
            debug.message("Page Timeout");
            this.loginState.setTimedOut(true);
            this.loginState.setReceivedCallback(null, this.am);
            throw new IOException("110");
        }
    }
}

