/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.util;

import com.sun.identity.shared.debug.Debug;
import java.util.HashSet;
import java.util.StringTokenizer;

public class ISValidation {
    private static Debug debug = null;
    private static String SEPERATOR = "|";

    public static boolean validate(String str, String regEx, Debug tmpDebug) {
        debug = tmpDebug;
        if (str == null || str.length() == 0) {
            debug.message("Source string is null or empty");
            return false;
        }
        char[] value = str.toCharArray();
        int count = value.length;
        HashSet<String> hSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(regEx, SEPERATOR);
        while (st.hasMoreTokens()) {
            hSet.add(st.nextToken());
        }
        for (String obj : hSet) {
            if (ISValidation.process(value, obj, 0, count) <= -1) continue;
            debug.message("detected invalid chars ...");
            return false;
        }
        return true;
    }

    private static int process(char[] value, String str, int fromIndex, int count) {
        return ISValidation.processString(value, 0, count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    private static int processString(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }
}

