/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLICommand;
import com.sun.identity.cli.CLIConstants;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IDefinition;
import com.sun.identity.cli.RequestContext;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class SubCommand {
    private IDefinition definition;
    private ResourceBundle rb;
    private String name;
    private String implClassName;
    private Map optionAliases = new HashMap();
    private Set setOptionAliases = new HashSet();
    private List mandatoryOptions = new ArrayList();
    private List optionalOptions = new ArrayList();
    private boolean webSupport;
    private Map optionNameToShortName = new HashMap();
    private Set unaryOptionNames = new HashSet();
    private Set singleOptionNames = new HashSet();
    private Set multipleOptionNames = new HashSet();
    private Set textAreaUI = new HashSet();
    private Set textBoxUI = new HashSet();
    private Set checkboxUI = new HashSet();
    private static Set reservedLongOptionNames = new HashSet();
    private static Set reservedShortOptionNames = new HashSet();
    private static Map mapLongToShortOptionName = new HashMap();

    public static boolean isReservedShortOption(String name) {
        return reservedShortOptionNames.contains(name);
    }

    public static boolean isReservedLongOption(String name) {
        return reservedLongOptionNames.contains(name);
    }

    public static String getReservedShortOptionName(String longName) {
        return (String)mapLongToShortOptionName.get(longName);
    }

    public static String getReservedLongOptionName(String shortName) {
        String longName = null;
        Iterator i = mapLongToShortOptionName.keySet().iterator();
        while (i.hasNext() && longName == null) {
            String key = (String)i.next();
            String value = (String)mapLongToShortOptionName.get(key);
            if (!value.equals(shortName)) continue;
            longName = key;
        }
        return longName;
    }

    public SubCommand(IDefinition definition, ResourceBundle rb, String name, List mandatoryOptions, List optionalOptions, List optionAliases, String implClassName, boolean webSupport) throws CLIException {
        this.definition = definition;
        this.name = name;
        this.rb = rb;
        this.implClassName = implClassName;
        this.webSupport = webSupport;
        HashSet shortOptions = new HashSet();
        this.parseOptions(mandatoryOptions, this.mandatoryOptions, shortOptions);
        this.parseOptions(optionalOptions, this.optionalOptions, shortOptions);
        this.parseAliases(optionAliases);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.rb.getString("subcmd-" + this.name);
    }

    public List getOptionalOptions() {
        return this.optionalOptions;
    }

    public List getMandatoryOptions() {
        return this.mandatoryOptions;
    }

    public List getOptionAliases(String name) {
        return (List)this.optionAliases.get(name);
    }

    public Set getOptionAliasesGroup(String fullName) {
        HashSet<String> group = null;
        Iterator i = this.optionAliases.keySet().iterator();
        while (i.hasNext() && group == null) {
            String opt = (String)i.next();
            List list = this.getOptionAliases(opt);
            if (list == null) continue;
            Iterator j = list.iterator();
            while (j.hasNext() && group == null) {
                String name = (String)j.next();
                if (!name.equals(fullName)) continue;
                group = new HashSet<String>();
                group.addAll(list);
                group.add(opt);
            }
        }
        return group;
    }

    public boolean isOptionAlias(String name) {
        return this.setOptionAliases.contains(name);
    }

    public void execute(RequestContext rc) throws CLIException {
        CommandManager mgr = rc.getCommandManager();
        if (mgr.isVerbose()) {
            mgr.getOutputWriter().printlnMessage(rc.getResourceString("verbose-processing-sub-command"));
        }
        try {
            Class<?> clazz = Class.forName(this.implClassName);
            CLICommand cmd = (CLICommand)clazz.newInstance();
            cmd.handleRequest(rc);
        }
        catch (IllegalAccessException e) {
            throw new CLIException(e.getMessage(), 15);
        }
        catch (InstantiationException e) {
            throw new CLIException(e.getMessage(), 14);
        }
        catch (ClassNotFoundException e) {
            throw new CLIException(e.getMessage(), 13);
        }
    }

    public boolean validateOptions(Map options, SSOToken ssoToken) {
        List list;
        String name;
        String opt;
        boolean valid = true;
        Iterator<Object> i = this.optionAliases.keySet().iterator();
        while (i.hasNext() && valid) {
            opt = (String)i.next();
            valid = this.validateAliasOptions(opt, (List)this.optionAliases.get(opt), options);
        }
        i = this.mandatoryOptions.iterator();
        while (i.hasNext() && valid) {
            opt = (String)i.next();
            List values = (List)options.get(opt);
            if (values != null || ssoToken != null && this.definition.isAuthOption(opt)) continue;
            List aliases = (List)this.optionAliases.get(opt);
            if (aliases == null || aliases.isEmpty()) {
                Set aliasGroup = this.getOptionAliasesGroup(opt);
                valid = this.hasOptionValue(aliasGroup, options, ssoToken);
                continue;
            }
            valid = this.hasOptionValue(aliases, options, ssoToken);
        }
        i = this.unaryOptionNames.iterator();
        while (i.hasNext() && valid) {
            name = (String)i.next();
            list = (List)options.get(name);
            valid = list == null || list.isEmpty();
        }
        i = this.singleOptionNames.iterator();
        while (i.hasNext() && valid) {
            name = (String)i.next();
            list = (List)options.get(name);
            valid = list == null || list.size() == 1;
        }
        i = this.multipleOptionNames.iterator();
        while (i.hasNext() && valid) {
            name = (String)i.next();
            list = (List)options.get(name);
            valid = list == null || list.size() > 0;
        }
        return valid;
    }

    private boolean hasOptionValue(Collection options, Map optionValues, SSOToken ssoToken) {
        boolean has = false;
        if (options != null && optionValues != null) {
            Iterator i = options.iterator();
            while (i.hasNext() && !has) {
                String opt = (String)i.next();
                if (ssoToken != null && this.definition.isAuthOption(opt)) {
                    has = true;
                    continue;
                }
                List values = (List)optionValues.get(opt);
                has = values != null && !values.isEmpty();
            }
        }
        return has;
    }

    private boolean validateAliasOptions(String opt, List aliases, Map options) {
        HashSet<String> set = new HashSet<String>();
        set.add(opt);
        set.addAll(aliases);
        boolean existed = false;
        boolean valid = true;
        Iterator i = set.iterator();
        while (i.hasNext() && valid) {
            String o = (String)i.next();
            if (!options.containsKey(o)) continue;
            if (existed) {
                valid = false;
                continue;
            }
            existed = true;
        }
        return valid;
    }

    public String getLongOptionName(String name) {
        String longName = null;
        Iterator i = this.optionNameToShortName.keySet().iterator();
        while (i.hasNext() && longName == null) {
            String opt = (String)i.next();
            String val = (String)this.optionNameToShortName.get(opt);
            if (!val.equals(name)) continue;
            longName = opt;
        }
        return longName;
    }

    public String getShortOptionName(String name) {
        return (String)this.optionNameToShortName.get(name);
    }

    public boolean isSupportedOption(String name) {
        String opt;
        boolean isSupported = false;
        Iterator i = this.mandatoryOptions.iterator();
        while (i.hasNext() && !isSupported) {
            opt = (String)i.next();
            isSupported = opt.equals(name);
        }
        i = this.optionalOptions.iterator();
        while (i.hasNext() && !isSupported) {
            opt = (String)i.next();
            isSupported = opt.equals(name);
        }
        return isSupported;
    }

    public String getOptionDescription(String name) {
        return this.getOptionDescription(name, false);
    }

    public String getOptionDescription(String name, boolean isWeb) {
        String desc = null;
        if (isWeb) {
            try {
                desc = this.rb.getString("subcmd-" + this.name + "-" + "__web__" + "-" + name);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (desc == null) {
            desc = this.rb.getString("subcmd-" + this.name + "-" + name);
        }
        desc = desc.replaceAll("&pipe;", "|");
        desc = desc.replaceAll("&amp;", "&");
        return desc;
    }

    private void parseOptions(List strOpt, List options, Set shortOptions) throws CLIException {
        for (String token : strOpt) {
            Object[] params;
            StringTokenizer t = new StringTokenizer(token, "|");
            String name = t.nextToken();
            String shortName = t.nextToken();
            String type = t.nextToken();
            boolean unary = type.equals("u");
            boolean single = type.equals("s");
            if (t.countTokens() == 2) {
                String webUI = t.nextToken();
                if (webUI.equals("t")) {
                    this.textAreaUI.add(name);
                } else if (webUI.equals("i")) {
                    this.textBoxUI.add(name);
                } else if (webUI.equals("c")) {
                    this.checkboxUI.add(name);
                }
            }
            if (reservedLongOptionNames.contains(name)) {
                params = new Object[]{name, this.name};
                throw new CLIException(MessageFormat.format(CommandManager.resourceBundle.getString("exception-message-reserved-option"), params), 9);
            }
            if (reservedShortOptionNames.contains(shortName)) {
                params = new Object[]{shortName, this.name};
                throw new CLIException(MessageFormat.format(CommandManager.resourceBundle.getString("exception-message-reserved-option"), params), 9);
            }
            if (options.contains(name)) {
                params = new Object[]{name, this.name};
                throw new CLIException(MessageFormat.format(CommandManager.resourceBundle.getString("exception-message-duplicated-option"), params), 21);
            }
            if (shortOptions.contains(shortName)) {
                params = new Object[]{shortName, this.name};
                throw new CLIException(MessageFormat.format(CommandManager.resourceBundle.getString("exception-message-duplicated-option"), params), 21);
            }
            options.add(name);
            shortOptions.add(shortName);
            this.optionNameToShortName.put(name, shortName);
            if (unary) {
                this.unaryOptionNames.add(name);
                continue;
            }
            if (single) {
                this.singleOptionNames.add(name);
                continue;
            }
            this.multipleOptionNames.add(name);
        }
    }

    private void parseAliases(List aliases) {
        for (String al : aliases) {
            StringTokenizer t = new StringTokenizer(al, "|");
            String head = t.nextToken();
            String alias = t.nextToken();
            ArrayList<String> array = new ArrayList<String>();
            array.add(alias);
            this.setOptionAliases.add(alias);
            while (t.hasMoreTokens()) {
                String a = t.nextToken();
                array.add(a);
                this.setOptionAliases.add(a);
            }
            this.optionAliases.put(head, array);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.rb;
    }

    public boolean isUnaryOption(String cmdName) {
        return this.unaryOptionNames.contains(cmdName);
    }

    public boolean isBinaryOption(String cmdName) {
        return this.singleOptionNames.contains(cmdName);
    }

    public boolean webEnabled() {
        return this.webSupport;
    }

    public boolean textareaUI(String opt) {
        String shortName = this.getShortOptionName(opt);
        return !this.textBoxUI.contains(opt) && (!shortName.equals(shortName.toLowerCase()) || this.textAreaUI.contains(opt));
    }

    public boolean checkboxUI(String opt) {
        return this.isUnaryOption(opt) || this.checkboxUI.contains(opt);
    }

    static {
        try {
            Field[] allFields = CLIConstants.class.getFields();
            for (int i = 0; i < allFields.length; ++i) {
                Field fld = allFields[i];
                if (fld.getName().startsWith("ARGUMENT_")) {
                    reservedLongOptionNames.add((String)fld.get(null));
                    String option = fld.getName().substring("ARGUMENT_".length());
                    Field fldShort = CLIConstants.class.getField("SHORT_ARGUMENT_" + option);
                    mapLongToShortOptionName.put((String)fld.get(null), (String)fldShort.get(null));
                    continue;
                }
                if (!fld.getName().startsWith("SHORT_ARGUMENT_")) continue;
                reservedShortOptionNames.add((String)fld.get(null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

