/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.FQDNUrl;
import com.sun.identity.sm.SMSException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class CreateAgent
extends AuthenticatedCommand {
    private static final String AGENT_URL = "agenturl";

    public void handleRequest(RequestContext rc) throws CLIException {
        String[] args;
        boolean webJ2EEAgent;
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String agentName = this.getStringOptionValue("agentname");
        String agentType = this.getStringOptionValue("agenttype");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        Map attributeValues = Collections.EMPTY_MAP;
        if (datafile != null || attrValues != null) {
            attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        }
        if (attributeValues == null || attributeValues.isEmpty()) {
            throw new CLIException(this.getResourceString("agent-creation-pwd-needed"), 127);
        }
        String serverURL = this.getStringOptionValue("serverurl");
        String agentURL = this.getStringOptionValue(AGENT_URL);
        boolean bl = webJ2EEAgent = agentType.equals("WebAgent") || agentType.equals("J2EEAgent");
        if (!webJ2EEAgent) {
            if (serverURL != null) {
                throw new CLIException(this.getResourceString("does-not-support-server-url"), 127);
            }
            if (agentURL != null) {
                throw new CLIException(this.getResourceString("does-not-support-agent-url"), 127);
            }
        }
        if (serverURL == null && agentURL != null) {
            throw new CLIException(this.getResourceString("server-url-missing"), 127);
        }
        if (serverURL != null && agentURL == null) {
            throw new CLIException(this.getResourceString("agent-url-missing"), 127);
        }
        boolean hasPassword = false;
        Iterator i = attributeValues.keySet().iterator();
        while (i.hasNext() && !hasPassword) {
            Set values;
            String k = (String)i.next();
            if (!k.equals("userpassword") || (values = (Set)attributeValues.get(k)) == null || values.isEmpty()) continue;
            String pwd = (String)values.iterator().next();
            hasPassword = pwd.trim().length() > 0;
        }
        if (!hasPassword) {
            throw new CLIException(this.getResourceString("agent-creation-pwd-needed"), 127);
        }
        String[] params = new String[]{realm, agentType, agentName};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_AGENT", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set set = amir.getAllowedIdOperations(IdType.AGENTONLY);
            if (!set.contains(IdOperation.CREATE)) {
                String[] args2 = new String[]{realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("does-not-support-agent-creation"), args2), 127);
            }
            if (webJ2EEAgent) {
                if (serverURL != null) {
                    FQDNUrl fqdnServerURL = null;
                    try {
                        fqdnServerURL = new FQDNUrl(serverURL);
                    }
                    catch (MalformedURLException e) {
                        throw new CLIException(this.getResourceString("server-url-invalid"), 127);
                    }
                    FQDNUrl fqdnAgentURL = null;
                    try {
                        fqdnAgentURL = new FQDNUrl(agentURL);
                    }
                    catch (MalformedURLException e) {
                        throw new CLIException(this.getResourceString("agent-url-invalid"), 127);
                    }
                    Map map = AgentConfiguration.getDefaultValues(agentType, false);
                    map.putAll(attributeValues);
                    AgentConfiguration.tagswapAttributeValues(map, agentType, fqdnServerURL, fqdnAgentURL);
                    AgentConfiguration.createAgent(adminSSOToken, realm, agentName, agentType, map);
                } else {
                    AgentConfiguration.createAgent(adminSSOToken, realm, agentName, agentType, attributeValues);
                }
            } else {
                AgentConfiguration.createAgent(adminSSOToken, realm, agentName, agentType, attributeValues);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-agent-succeeded"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_AGENT", params);
        }
        catch (ConfigurationException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException(e, 127);
        }
        catch (IdRepoException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

