/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.util.List;

public class DeleteAuthConfigurations
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        List names = rc.getOption("names");
        String[] params = new String[]{realm, names.toString()};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_AUTH_CONFIGURATIONS", params);
        try {
            for (String name : names) {
                AMAuthConfigUtils.removeNamedConfig(name, realm, adminSSOToken);
            }
            if (names.size() == 1) {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-delete-auth-configuration-succeeded"));
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-delete-auth-configurations-succeeded"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_AUTH_CONFIGURATIONS", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("DeleteAuthConfiguraton.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AUTH_CONFIGURATIONS", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("DeleteAuthConfiguraton.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AUTH_CONFIGURATIONS", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("DeleteAuthConfiguraton.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AUTH_CONFIGURATIONS", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

