/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class GetAllowedIdOperations
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String type = this.getStringOptionValue("idtype");
        String[] params = new String[]{realm, type};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_ALLOWED_OPS", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            IdType idType = this.convert2IdType(type);
            Set ops = amir.getAllowedIdOperations(idType);
            String msg = this.getResourceString("allowed-ops-result");
            String[] arg = new String[]{""};
            if (ops != null && !ops.isEmpty()) {
                Iterator i = ops.iterator();
                while (i.hasNext()) {
                    arg[0] = ((IdOperation)i.next()).getName();
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("get-allowed-ops-no-ops"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_ALLOWED_OPS", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, e.getMessage()};
            this.debugError("GetAllowedIdOperations.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_ALLOWED_OPS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, e.getMessage()};
            this.debugError("GetAllowedIdOperations.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_ALLOWED_OPS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

