/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RealmSetServiceAttributeValues
extends AuthenticatedCommand {
    private static final String OPT_APPEND = "append";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        boolean bAppend = this.isOptionSet(OPT_APPEND);
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        try {
            AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity ai = repo.getRealmIdentity();
            Set servicesFromIdRepo = ai.getAssignedServices();
            if (servicesFromIdRepo.contains(serviceName)) {
                this.handleDynamicAttributes(ai, realm, serviceName, attributeValues, bAppend);
            } else {
                this.handleOrganizatioAttribute(realm, serviceName, attributeValues, bAppend);
            }
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmSetServiceAttributeValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SVC_ATTR_VALUES_REALM", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmSetServiceAttributeValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SVC_ATTR_VALUES_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private void handleDynamicAttributes(AMIdentity idRealm, String realm, String serviceName, Map attributeValues, boolean bAppend) throws CLIException, IdRepoException, SSOException {
        String[] params = new String[]{realm, serviceName};
        IOutput outputWriter = this.getOutputWriter();
        this.writeLog(0, Level.INFO, "ATTEMPT_SET_SVC_ATTR_VALUES_REALM", params);
        if (bAppend) {
            HashMap<String, Set> newValues = new HashMap<String, Set>();
            Map currentVal = idRealm.getAttributes(attributeValues.keySet());
            for (String attrName : attributeValues.keySet()) {
                Set origVal = (Set)currentVal.get(attrName);
                Set newVal = (Set)attributeValues.get(attrName);
                if (origVal == null || origVal.isEmpty()) {
                    newValues.put(attrName, newVal);
                    continue;
                }
                origVal.addAll(newVal);
                newValues.put(attrName, origVal);
            }
            idRealm.modifyService(serviceName, newValues);
        } else {
            idRealm.modifyService(serviceName, attributeValues);
        }
        this.writeLog(0, Level.INFO, "SUCCEED_SET_SVC_ATTR_VALUES_REALM", params);
        outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("set-svc-attribute-values-realm-succeed"), params));
    }

    private void handleOrganizatioAttribute(String realm, String serviceName, Map attributeValues, boolean bAppend) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            if (!ocm.getAssignedServices().contains(serviceName)) {
                throw new CLIException(this.getResourceString("realm-set-svc-attr-values-service-not-assigned"), 127);
            }
            ServiceConfig config = ocm.getServiceConfig(serviceName);
            String[] params = new String[]{realm, serviceName};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_SVC_ATTR_VALUES_REALM", params);
            if (bAppend) {
                for (String attributeName : attributeValues.keySet()) {
                    Set values = (Set)attributeValues.get(attributeName);
                    config.addAttribute(attributeName, values);
                }
            } else {
                config.setAttributes(attributeValues);
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SET_SVC_ATTR_VALUES_REALM", params);
            outputWriter.printlnMessage(this.getResourceString("set-svc-attribute-values-realm-succeed"));
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmSetServiceAttributeValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SVC_ATTR_VALUES_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmSetServiceAttributeValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SVC_ATTR_VALUES_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

